/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;

public class BinContents {
    private final Map map_ = new HashMap();
    private final ProgressIndicator indicator_;
    private long nrow_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$join$BinContents;

    public BinContents(ProgressIndicator indicator) {
        this.indicator_ = indicator;
    }

    public void putRowInBin(Object key, RowRef row) {
        ++this.nrow_;
        Object value = this.map_.get(key);
        if (value == null) {
            if (!$assertionsDisabled && this.map_.containsKey(key)) {
                throw new AssertionError();
            }
            this.map_.put(key, row);
        } else {
            LinkedList<RowRef> rowList;
            if (value instanceof RowRef) {
                rowList = new LinkedList<RowRef>();
                rowList.add((RowRef)value);
                this.map_.put(key, rowList);
            } else {
                rowList = (LinkedList<RowRef>)value;
            }
            rowList.add(row);
        }
    }

    public boolean containsKey(Object key) {
        return this.map_.containsKey(key);
    }

    public void addRowLinks(LinkSet links) throws InterruptedException {
        this.indicator_.logMessage(this.nrow_ + " row refs in " + this.map_.size() + " bins");
        this.indicator_.logMessage("(average bin occupancy " + (float)this.nrow_ / (float)this.map_.size() + ")");
        this.indicator_.startStage("Consolidating potential match groups");
        double nl = this.map_.size();
        int il = 0;
        Iterator it = this.map_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (value instanceof List) {
                links.addLink(new RowLink((List)value));
            } else if (!$assertionsDisabled && !(value instanceof RowRef)) {
                throw new AssertionError();
            }
            it.remove();
            this.indicator_.setLevel((double)il++ / nl);
        }
        if (!$assertionsDisabled && !this.map_.isEmpty()) {
            throw new AssertionError();
        }
        this.nrow_ = 0L;
        this.indicator_.endStage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$join$BinContents == null ? (class$uk$ac$starlink$table$join$BinContents = BinContents.class$("uk.ac.starlink.table.join.BinContents")) : class$uk$ac$starlink$table$join$BinContents).desiredAssertionStatus();
    }
}

