/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import edu.jhu.htm.core.Domain;
import edu.jhu.htm.core.HTMException;
import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.core.HTMrangeIterator;
import edu.jhu.htm.geometry.Circle;
import java.util.ArrayList;
import uk.ac.starlink.table.join.SkyMatchEngine;

public class HTMMatchEngine
extends SkyMatchEngine {
    private HTMindexImp htm_;
    public static final double MESH_SCALE = 1.0;

    public HTMMatchEngine(double separation, boolean useErrors) {
        super(separation, useErrors);
    }

    public void setSeparation(double separation) {
        super.setSeparation(separation);
        try {
            this.htm_ = new HTMindexImp(Math.toDegrees(separation) * 1.0);
        }
        catch (HTMException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Bad separation? " + separation + " radians").initCause(e);
        }
    }

    public Object[] getBins(double ra, double dec, double err) {
        double arcminErr = Math.toDegrees(err) * 60.0;
        Circle zone = new Circle(ra, dec, arcminErr);
        Domain domain = zone.getDomain();
        domain.setOlevel(this.htm_.maxlevel_);
        HTMrange range = new HTMrange();
        domain.intersect(this.htm_, range, false);
        ArrayList binList = new ArrayList();
        try {
            HTMrangeIterator it = new HTMrangeIterator(range, false);
            while (it.hasNext()) {
                binList.add(it.next());
            }
        }
        catch (HTMException e) {
            throw new RuntimeException("Uh-oh", e);
        }
        return binList.toArray();
    }
}

