/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.BitSet;
import java.util.Iterator;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;
import uk.ac.starlink.table.join.TreeSetLinkSet;

public abstract class JoinType {
    private final String name_;
    private final String longName_;
    public static final JoinType _1AND2 = new JoinType("1and2", "1 and 2"){

        public String getDescription() {
            return "An output row for each row represented in both input tables";
        }

        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            return links;
        }

        public boolean[] getUsedTableFlags() {
            return new boolean[]{true, true};
        }

        public boolean getUsedMatchFlag() {
            return true;
        }
    };
    public static final JoinType _1OR2 = new JoinType("1or2", "1 or 2"){

        public String getDescription() {
            return "An output row for each row represented in either or both of the input tables";
        }

        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            BitSet[] present = new BitSet[2];
            int iTable = 0;
            while (iTable < 2) {
                present[iTable] = JoinType.getInclusion(links, iTable);
                ++iTable;
            }
            int iTable2 = 0;
            while (iTable2 < 2) {
                int iRow = 0;
                while (iRow < rowCounts[iTable2]) {
                    if (!present[iTable2].get(iRow)) {
                        links.addLink(new RowLink(new RowRef(iTable2, iRow)));
                    }
                    ++iRow;
                }
                ++iTable2;
            }
            return links;
        }

        public boolean[] getUsedTableFlags() {
            return new boolean[]{true, true};
        }

        public boolean getUsedMatchFlag() {
            return true;
        }
    };
    public static final JoinType _ALL1 = new AllType("all1", "All from 1", 0);
    public static final JoinType _ALL2 = new AllType("all2", "All from 2", 1);
    public static final JoinType _2NOT1 = new NotType("2not1", "2 not 1", 0);
    public static final JoinType _1NOT2 = new NotType("1not2", "1 not 2", 1);
    public static final JoinType _1XOR2 = new JoinType("1xor2", "1 xor 2"){

        public String getDescription() {
            return "An output row only for rows represented in one of the input tables but not the other one";
        }

        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            BitSet[] present = new BitSet[2];
            int iTable = 0;
            while (iTable < 2) {
                present[iTable] = JoinType.getInclusion(links, iTable);
                ++iTable;
            }
            links = JoinType.createLinkSet();
            int iTable2 = 0;
            while (iTable2 < 2) {
                int iRow = 0;
                while (iRow < rowCounts[iTable2]) {
                    if (!present[iTable2].get(iRow)) {
                        links.addLink(new RowLink(new RowRef(iTable2, iRow)));
                    }
                    ++iRow;
                }
                ++iTable2;
            }
            return links;
        }

        public boolean[] getUsedTableFlags() {
            return new boolean[]{true, true};
        }

        public boolean getUsedMatchFlag() {
            return false;
        }
    };

    private JoinType(String name, String longName) {
        this.name_ = name;
        this.longName_ = longName;
    }

    public abstract LinkSet processLinks(LinkSet var1, int[] var2);

    public abstract boolean[] getUsedTableFlags();

    public abstract boolean getUsedMatchFlag();

    public String getName() {
        return this.name_;
    }

    public abstract String getDescription();

    public String toString() {
        return this.longName_;
    }

    public static JoinType[] getPairTypes() {
        return new JoinType[]{_1AND2, _1OR2, _ALL1, _ALL2, _1NOT2, _2NOT1, _1XOR2};
    }

    private static LinkSet createLinkSet() {
        return new TreeSetLinkSet();
    }

    private static BitSet getInclusion(LinkSet links, int iTable) {
        BitSet present = new BitSet();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() == iTable) {
                    present.set(Tables.checkedLongToInt(ref.getRowIndex()));
                }
                ++i;
            }
        }
        return present;
    }

    private static class NotType
    extends JoinType {
        final int yesTable_;
        final int noTable_;

        NotType(String name, String longName, int noTable) {
            super(name, longName);
            this.noTable_ = noTable;
            this.yesTable_ = 1 - this.noTable_;
        }

        public String getDescription() {
            String[] ordinals = new String[]{"first", "second"};
            return "An output row only for rows which appear in the " + ordinals[this.yesTable_] + " table but are not matched in the " + ordinals[this.noTable_] + " table";
        }

        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            BitSet matched = new BitSet();
            Iterator it = links.iterator();
            while (it.hasNext()) {
                RowLink link = (RowLink)it.next();
                int nref = link.size();
                long noRow = -1L;
                long yesRow = -1L;
                int i = 0;
                while (i < nref) {
                    RowRef ref = link.getRef(i);
                    if (ref.getTableIndex() == this.noTable_) {
                        noRow = ref.getRowIndex();
                    } else if (ref.getTableIndex() == this.yesTable_) {
                        yesRow = ref.getRowIndex();
                    }
                    ++i;
                }
                if (noRow < 0L || yesRow < 0L) continue;
                matched.set(Tables.checkedLongToInt(yesRow));
            }
            links = JoinType.createLinkSet();
            int irow = 0;
            while (irow < rowCounts[this.yesTable_]) {
                if (!matched.get(irow)) {
                    links.addLink(new RowLink(new RowRef(this.yesTable_, irow)));
                }
                ++irow;
            }
            return links;
        }

        public boolean[] getUsedTableFlags() {
            boolean[] flags = new boolean[2];
            flags[this.noTable_] = false;
            flags[this.yesTable_] = true;
            return flags;
        }

        public boolean getUsedMatchFlag() {
            return false;
        }
    }

    private static class AllType
    extends JoinType {
        final int iTable_;

        AllType(String name, String longName, int iTable) {
            super(name, longName);
            this.iTable_ = iTable;
        }

        public String getDescription() {
            return "An output row for each matched or unmatched row in table " + (this.iTable_ + 1);
        }

        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            BitSet present = JoinType.getInclusion(links, this.iTable_);
            int irow = 0;
            while (irow < rowCounts[this.iTable_]) {
                if (!present.get(irow)) {
                    links.addLink(new RowLink(new RowRef(this.iTable_, irow)));
                }
                ++irow;
            }
            return links;
        }

        public boolean[] getUsedTableFlags() {
            return new boolean[]{true, true};
        }

        public boolean getUsedMatchFlag() {
            return true;
        }
    }
}

