/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.table.join.LinkGroup;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;

public class MatchStarTables {
    public static final ValueInfo GRP_ID_INFO;
    public static final ValueInfo GRP_SIZE_INFO;
    private static final Logger logger_;
    static /* synthetic */ Class class$java$lang$Integer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$join$MatchStarTables;

    public static StarTable makeJoinTable(StarTable table1, StarTable table2, LinkSet pairs, JoinType joinType, boolean addGroups, JoinFixAction[] fixActs, ValueInfo matchScoreInfo) {
        int nrows1 = Tables.checkedLongToInt(table1.getRowCount());
        int nrows2 = Tables.checkedLongToInt(table2.getRowCount());
        LinkSet links = joinType.processLinks(pairs, new int[]{nrows1, nrows2});
        boolean[] useFlags = joinType.getUsedTableFlags();
        StarTable[] tables = new StarTable[2];
        if (useFlags[0]) {
            tables[0] = table1;
        }
        if (useFlags[1]) {
            tables[1] = table2;
        }
        if (!joinType.getUsedMatchFlag()) {
            matchScoreInfo = null;
        }
        return MatchStarTables.makeJoinTable(tables, links, addGroups, fixActs, matchScoreInfo);
    }

    public static StarTable makeJoinTable(StarTable[] tables, LinkSet rowLinks, boolean addGroups, JoinFixAction[] fixActs, ValueInfo matchScoreInfo) {
        double[] scores;
        int nTable = tables.length;
        int nRow = rowLinks.size();
        long[][] rowIndices = new long[nTable][];
        int iTable = 0;
        while (iTable < nTable) {
            if (tables[iTable] != null) {
                rowIndices[iTable] = new long[nRow];
                Arrays.fill(rowIndices[iTable], -1L);
            }
            ++iTable;
        }
        if (matchScoreInfo != null) {
            try {
                scores = new double[nRow];
                Arrays.fill(scores, Double.NaN);
            }
            catch (OutOfMemoryError e) {
                scores = null;
                logger_.warning("Out of memory calculating match scores - no " + matchScoreInfo.getName() + " column in output");
            }
        } else {
            scores = null;
        }
        int nScore = 0;
        Map grpMap = null;
        int[] grpSizes = null;
        int[] grpIds = null;
        if (addGroups) {
            try {
                grpMap = MatchStarTables.findGroups(rowLinks);
                if (grpMap.size() > 0) {
                    grpSizes = new int[nRow];
                    grpIds = new int[nRow];
                } else {
                    grpMap = null;
                }
            }
            catch (OutOfMemoryError e) {
                grpMap = null;
                grpSizes = null;
                grpIds = null;
                logger_.warning("Out of memory calculating match groups - no " + GRP_ID_INFO.getName() + " or " + GRP_SIZE_INFO.getName() + " columns in output");
            }
        }
        int iLink = 0;
        Iterator it = rowLinks.iterator();
        while (it.hasNext()) {
            LinkGroup grp;
            double score;
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                int iTable2 = ref.getTableIndex();
                if (tables[iTable2] != null) {
                    rowIndices[iTable2][iLink] = ref.getRowIndex();
                }
                ++i;
            }
            if (scores != null && !Double.isNaN(score = link.getScore())) {
                scores[iLink] = score;
                ++nScore;
            }
            if (grpMap != null && (grp = (LinkGroup)grpMap.get(link)) != null) {
                grpIds[iLink] = grp.getID();
                grpSizes[iLink] = grp.getSize();
            }
            ++iLink;
        }
        if (!$assertionsDisabled && iLink != nRow) {
            throw new AssertionError();
        }
        ArrayList<StarTable> subTableList = new ArrayList<StarTable>();
        ArrayList<JoinFixAction> fixActList = new ArrayList<JoinFixAction>();
        int iTable3 = 0;
        while (iTable3 < nTable) {
            StarTable table = tables[iTable3];
            if (table != null) {
                subTableList.add(new RowPermutedStarTable(table, rowIndices[iTable3]));
                fixActList.add(fixActs[iTable3]);
            }
            ++iTable3;
        }
        ArrayList<ColumnData> extraCols = new ArrayList<ColumnData>();
        if (grpMap != null) {
            ColumnInfo grpIdInfo = new ColumnInfo(GRP_ID_INFO);
            ColumnInfo grpSizeInfo = new ColumnInfo(GRP_SIZE_INFO);
            final int[] grpIdData = grpIds;
            final int[] grpSizeData = grpSizes;
            if (!$assertionsDisabled && grpIdData == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && grpSizeData == null) {
                throw new AssertionError();
            }
            extraCols.add(new ColumnData(GRP_ID_INFO){

                public Object readValue(long lrow) {
                    int irow;
                    if (lrow < Integer.MAX_VALUE && grpSizeData[irow = (int)lrow] > 1) {
                        return new Integer(grpIdData[irow]);
                    }
                    return null;
                }
            });
            extraCols.add(new ColumnData(GRP_SIZE_INFO){

                public Object readValue(long lrow) {
                    int irow;
                    if (lrow < Integer.MAX_VALUE && grpSizeData[irow = (int)lrow] > 1) {
                        return new Integer(grpSizeData[irow]);
                    }
                    return null;
                }
            });
        }
        if (nScore > 0) {
            extraCols.add(ArrayColumn.makeColumn(new ColumnInfo(matchScoreInfo), (Object)scores));
        }
        if (extraCols.size() > 0) {
            ColumnStarTable extraTable = ColumnStarTable.makeTableWithRows(nRow);
            Iterator it2 = extraCols.iterator();
            while (it2.hasNext()) {
                extraTable.addColumn((ColumnData)it2.next());
            }
            subTableList.add(extraTable);
            fixActList.add(JoinFixAction.NO_ACTION);
        }
        StarTable[] subTables = subTableList.toArray(new StarTable[0]);
        JoinFixAction[] subFixes = fixActList.toArray(new JoinFixAction[0]);
        JoinStarTable joined = new JoinStarTable(subTables, subFixes);
        joined.setName("Joined");
        return joined;
    }

    public static StarTable makeInternalMatchTable(int iTable, LinkSet rowLinks, long rowCount) {
        final int nrow = Tables.checkedLongToInt(rowCount);
        final int[] grpIds = new int[nrow];
        final int[] grpSizes = new int[nrow];
        int grpId = 0;
        Iterator it = rowLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            ++grpId;
            int nref = link.size();
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() == iTable) {
                    long lrow = ref.getRowIndex();
                    int irow = Tables.checkedLongToInt(lrow);
                    grpIds[irow] = grpId;
                    int n = grpId;
                    grpSizes[n] = grpSizes[n] + 1;
                }
                ++i;
            }
        }
        ColumnData grpIdColumn = new ColumnData(GRP_ID_INFO){

            public Object readValue(long lrow) {
                if (lrow >= (long)nrow) {
                    return null;
                }
                int grpId = grpIds[(int)lrow];
                return grpId > 0 ? new Integer(grpId) : null;
            }
        };
        ColumnData grpSizeColumn = new ColumnData(GRP_SIZE_INFO){

            public Object readValue(long lrow) {
                if (lrow >= (long)nrow) {
                    return null;
                }
                int grpId = grpIds[(int)lrow];
                return grpId > 0 ? new Integer(grpSizes[grpId]) : null;
            }
        };
        ColumnStarTable grpTable = ColumnStarTable.makeTableWithRows(nrow);
        grpTable.addColumn(grpIdColumn);
        grpTable.addColumn(grpSizeColumn);
        return grpTable;
    }

    public static StarTable makeParallelMatchTable(StarTable table, int iTable, LinkSet links, int width, int minSize, int maxSize, JoinFixAction[] fixActs) {
        String name;
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            int n0ref = 0;
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() == iTable) {
                    ++n0ref;
                }
                ++i;
            }
            if (n0ref >= minSize && n0ref <= maxSize) continue;
            it.remove();
        }
        int nrow = links.size();
        long[][] rowIndices = new long[width][];
        int i = 0;
        while (i < width) {
            rowIndices[i] = new long[nrow];
            Arrays.fill(rowIndices[i], -1L);
            ++i;
        }
        int iLink = 0;
        Iterator it2 = links.iterator();
        while (it2.hasNext()) {
            RowLink link = (RowLink)it2.next();
            int nref = link.size();
            int refPos = 0;
            int i2 = 0;
            while (i2 < nref && refPos < width) {
                RowRef ref = link.getRef(i2);
                if (ref.getTableIndex() == iTable) {
                    rowIndices[refPos++][iLink] = ref.getRowIndex();
                }
                ++i2;
            }
            if (!($assertionsDisabled || refPos >= minSize && refPos <= maxSize)) {
                throw new AssertionError();
            }
            ++iLink;
        }
        if (!$assertionsDisabled && iLink != nrow) {
            throw new AssertionError();
        }
        StarTable[] subTables = new StarTable[width];
        int i3 = 0;
        while (i3 < width) {
            subTables[i3] = new RowPermutedStarTable(table, rowIndices[i3]);
            ++i3;
        }
        int ncol = table.getColumnCount();
        int xNcol = ncol * width;
        final ColumnInfo[] colinfos = new ColumnInfo[xNcol];
        int ic = 0;
        while (ic < ncol) {
            ColumnInfo cinfo = table.getColumnInfo(ic);
            int iw = 0;
            while (iw < width) {
                ColumnInfo ci = new ColumnInfo(cinfo);
                ci.setName(ci.getName() + "_" + (iw + 1));
                colinfos[ic + iw * ncol] = ci;
                ++iw;
            }
            ++ic;
        }
        JoinStarTable joined = new JoinStarTable(subTables, fixActs){

            public ColumnInfo getColumnInfo(int icol) {
                return colinfos[icol];
            }
        };
        switch (width) {
            case 2: {
                name = "pairs";
                break;
            }
            case 3: {
                name = "triples";
                break;
            }
            case 4: {
                name = "quads";
                break;
            }
            default: {
                name = "setsOf" + width;
            }
        }
        joined.setName(name);
        return joined;
    }

    public static Map findGroups(LinkSet links) {
        HashMap<RowRef, Token> refMap = new HashMap<RowRef, Token>();
        int iLink = 0;
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            Token linkToken = new Token(++iLink);
            int i = 0;
            while (i < link.size()) {
                RowRef ref = link.getRef(i);
                if (refMap.containsKey(ref)) {
                    Token refToken = (Token)refMap.get(ref);
                    refToken.join(linkToken);
                } else {
                    refMap.put(ref, linkToken);
                }
                ++i;
            }
        }
        Iterator it2 = refMap.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            Token token = (Token)entry.getValue();
            if (token.getGroupSize() != 1) continue;
            it2.remove();
        }
        int[] idMap = MatchStarTables.getSortedGroupIds(refMap.values());
        HashMap<Integer, LinkGroup> knownGroups = new HashMap<Integer, LinkGroup>();
        Iterator it3 = refMap.entrySet().iterator();
        while (it3.hasNext()) {
            Map.Entry entry = it3.next();
            Token token = (Token)entry.getValue();
            int grpSize = token.getGroupSize();
            if (!$assertionsDisabled && grpSize <= 1) {
                throw new AssertionError();
            }
            int id = Arrays.binarySearch(idMap, token.getGroupId()) + 1;
            Integer groupKey = new Integer(id);
            if (!knownGroups.containsKey(groupKey)) {
                knownGroups.put(groupKey, new LinkGroup(id, grpSize));
            }
            entry.setValue(knownGroups.get(groupKey));
        }
        knownGroups = null;
        HashMap<RowLink, LinkGroup> result = new HashMap<RowLink, LinkGroup>();
        Iterator it4 = links.iterator();
        while (it4.hasNext()) {
            RowLink link = (RowLink)it4.next();
            RowRef ref0 = link.getRef(0);
            LinkGroup group = (LinkGroup)refMap.get(ref0);
            if (group != null) {
                result.put(link, group);
            }
            int i = 0;
            while (i < link.size()) {
                if (!$assertionsDisabled && group != refMap.get(link.getRef(i))) {
                    throw new AssertionError();
                }
                ++i;
            }
        }
        return result;
    }

    private static int[] getSortedGroupIds(Collection tokens) {
        HashSet<Integer> idSet = new HashSet<Integer>();
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            Token token = (Token)it.next();
            idSet.add(new Integer(token.getGroupId()));
        }
        int[] ids = new int[idSet.size()];
        int index = 0;
        Iterator it2 = idSet.iterator();
        while (it2.hasNext()) {
            ids[index++] = (Integer)it2.next();
        }
        if (!$assertionsDisabled && index != idSet.size()) {
            throw new AssertionError();
        }
        Arrays.sort(ids);
        return ids;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$join$MatchStarTables == null ? (class$uk$ac$starlink$table$join$MatchStarTables = MatchStarTables.class$("uk.ac.starlink.table.join.MatchStarTables")) : class$uk$ac$starlink$table$join$MatchStarTables).desiredAssertionStatus();
        GRP_ID_INFO = new DefaultValueInfo("GroupID", class$java$lang$Integer == null ? (class$java$lang$Integer = MatchStarTables.class$("java.lang.Integer")) : class$java$lang$Integer, "ID for match group");
        GRP_SIZE_INFO = new DefaultValueInfo("GroupSize", class$java$lang$Integer == null ? (class$java$lang$Integer = MatchStarTables.class$("java.lang.Integer")) : class$java$lang$Integer, "Number of rows in match group");
        logger_ = Logger.getLogger("uk.ac.starlink.table.join");
    }

    private static class Token
    implements Comparable {
        private final int id_;
        private Set group_;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Token(int id) {
            this.id_ = id;
        }

        public void join(Token other) {
            if (this.group_ == null && other.group_ == null) {
                this.group_ = new HashSet();
                this.group_.add(this);
                this.group_.add(other);
                other.group_ = this.group_;
            } else if (this.group_ == null && other.group_ != null) {
                other.group_.add(this);
                this.group_ = other.group_;
            } else if (this.group_ != null && other.group_ == null) {
                this.group_.add(other);
                other.group_ = this.group_;
            } else if (this.group_ != null && other.group_ != null) {
                if (!$assertionsDisabled && !this.group_.contains(this)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !other.group_.contains(other)) {
                    throw new AssertionError();
                }
                if (this.group_ != other.group_) {
                    Token[] others = other.group_.toArray(new Token[0]);
                    int i = 0;
                    while (i < others.length) {
                        Token tok = others[i];
                        if (!$assertionsDisabled && tok.group_ == this.group_) {
                            throw new AssertionError();
                        }
                        this.group_.add(tok);
                        tok.group_ = this.group_;
                        ++i;
                    }
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.group_ != other.group_) {
                throw new AssertionError();
            }
        }

        public int getGroupId() {
            if (this.group_ == null) {
                return this.id_;
            }
            int id = Integer.MAX_VALUE;
            Iterator it = this.group_.iterator();
            while (it.hasNext()) {
                Token token = (Token)it.next();
                id = Math.min(id, token.id_);
            }
            return id;
        }

        public int getGroupSize() {
            return this.group_ == null ? 1 : this.group_.size();
        }

        public String toString() {
            return "token" + this.getGroupId() + "[" + this.getGroupSize() + "]" + "-" + this.id_;
        }

        public int compareTo(Object o) {
            Token other = (Token)o;
            if (this.id_ == other.id_) {
                return 0;
            }
            return this.id_ > other.id_ ? 1 : -1;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$table$join$MatchStarTables == null ? (class$uk$ac$starlink$table$join$MatchStarTables = MatchStarTables.class$("uk.ac.starlink.table.join.MatchStarTables")) : class$uk$ac$starlink$table$join$MatchStarTables).desiredAssertionStatus();
        }
    }
}

