/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Arrays;
import java.util.Collection;
import uk.ac.starlink.table.join.RowRef;

public class RowLink
implements Comparable {
    private final RowRef[] rowRefs;
    private Integer hashCode;
    private double score = Double.NaN;

    public RowLink(Collection rows) {
        this(rows.toArray(new RowRef[0]));
    }

    public RowLink(RowRef[] rows) {
        this.rowRefs = (RowRef[])rows.clone();
        Arrays.sort(this.rowRefs);
    }

    public RowLink(RowRef row) {
        this.rowRefs = new RowRef[]{row};
    }

    public RowLink(RowRef rowA, RowRef rowB) {
        this(new RowRef[]{rowA, rowB});
    }

    public int size() {
        return this.rowRefs.length;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public RowRef getRef(int i) {
        return this.rowRefs[i];
    }

    public boolean equals(Object o) {
        if (o instanceof RowLink) {
            RowLink other = (RowLink)o;
            if (this.size() == other.size()) {
                int nref = this.size();
                int i = 0;
                while (i < nref) {
                    if (!this.getRef(i).equals(other.getRef(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = 37;
            int i = 0;
            while (i < this.size()) {
                result = 23 * result + this.getRef(i).hashCode();
                ++i;
            }
            this.hashCode = new Integer(result);
        }
        return this.hashCode;
    }

    public int compareTo(Object o) {
        RowLink other = (RowLink)o;
        int nTable = Math.max(other.getRef(other.size() - 1).getTableIndex() + 1, this.getRef(this.size() - 1).getTableIndex() + 1);
        long[] thisRowIndices = RowLink.getRowIndices(this, nTable);
        long[] otherRowIndices = RowLink.getRowIndices(other, nTable);
        int i = 0;
        while (i < nTable) {
            if (thisRowIndices[i] < otherRowIndices[i]) {
                return -1;
            }
            if (thisRowIndices[i] > otherRowIndices[i]) {
                return 1;
            }
            ++i;
        }
        return new Integer(this.hashCode()).compareTo(new Integer(other.hashCode()));
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer("(");
        int i = 0;
        while (i < this.rowRefs.length) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.rowRefs[i].toString());
            ++i;
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    private static long[] getRowIndices(RowLink link, int nTable) {
        long[] rowIndices = new long[nTable];
        Arrays.fill(rowIndices, Long.MAX_VALUE);
        int nref = link.size();
        int i = 0;
        while (i < nref) {
            RowRef ref = link.getRef(i);
            int iTable = ref.getTableIndex();
            long iRow = ref.getRowIndex();
            if (iRow < rowIndices[iTable]) {
                rowIndices[iTable] = iRow;
            }
            ++i;
        }
        return rowIndices;
    }
}

