/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.BinContents;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.NullProgressIndicator;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.ProgressRowSequence;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;
import uk.ac.starlink.table.join.TreeSetLinkSet;

public class RowMatcher {
    private final MatchEngine engine;
    private final StarTable[] tables;
    private final int nTable;
    private ProgressIndicator indicator = new NullProgressIndicator();
    private long startTime;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$table$join$RowMatcher;
    static /* synthetic */ Class class$java$lang$Comparable;

    public RowMatcher(MatchEngine engine, StarTable[] tables) {
        this.engine = engine;
        this.tables = tables;
        this.nTable = tables.length;
    }

    public void setIndicator(ProgressIndicator indicator) {
        this.indicator = indicator;
    }

    public ProgressIndicator getIndicator() {
        return this.indicator;
    }

    public LinkSet createLinkSet() {
        return new TreeSetLinkSet();
    }

    public LinkSet findPairMatches(boolean bestOnly) throws IOException, InterruptedException {
        this.checkRandom();
        if (this.nTable != 2) {
            throw new IllegalStateException("findPairMatches only makes sense for 2 tables");
        }
        this.startMatch();
        LinkSet possibleLinks = this.getPossibleInterLinks(0, 1);
        LinkSet pairs = this.findInterPairs(possibleLinks, 0, 1);
        if (bestOnly) {
            pairs = this.eliminateMultipleRowEntries(pairs);
        }
        this.endMatch();
        return pairs;
    }

    public LinkSet findPairMatches(boolean req1, boolean req2) throws IOException, InterruptedException {
        this.checkRandom();
        if (this.nTable != 2) {
            throw new IllegalStateException("findPairMatches only makes sense for 2 tables");
        }
        this.startMatch();
        LinkSet links = this.getPossibleInterLinks(0, 1);
        links = this.findInterPairs(links, 0, 1);
        links = this.eliminateMultipleRowEntries(links);
        LinkSet[] missing = new LinkSet[]{req1 ? null : this.missingSingles(links, 0), req2 ? null : this.missingSingles(links, 1)};
        int i = 0;
        while (i < 2) {
            if (missing[i] != null) {
                Iterator it = missing[i].iterator();
                while (it.hasNext()) {
                    links.addLink((RowLink)it.next());
                    it.remove();
                }
                missing[i] = null;
            }
            ++i;
        }
        this.endMatch();
        return links;
    }

    public LinkSet findGroupMatches(boolean[] useAll) throws IOException, InterruptedException {
        Iterator it;
        this.checkRandom();
        if (this.nTable < 2) {
            throw new IllegalStateException("Find matches only makes sense for multiple tables");
        }
        if (useAll.length != this.nTable) {
            throw new IllegalArgumentException("Options length " + useAll.length + " differs from table count " + this.nTable);
        }
        this.startMatch();
        LinkSet pairs = this.findPairs(this.getAllPossibleLinks());
        this.eliminateInternalLinks(pairs);
        LinkSet links = this.agglomerateLinks(pairs);
        pairs = null;
        this.eliminateInternalLinks(links);
        LinkSet[] missing = new LinkSet[this.nTable];
        int i = 0;
        while (i < this.nTable) {
            if (useAll[i]) {
                missing[i] = this.missingSingles(links, i);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nTable) {
            if (missing[i2] != null) {
                it = missing[i2].iterator();
                while (it.hasNext()) {
                    links.addLink((RowLink)it.next());
                }
                missing[i2] = null;
            }
            ++i2;
        }
        it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            if (this.acceptRow(link, useAll)) continue;
            it.remove();
        }
        this.endMatch();
        return links;
    }

    public LinkSet findInternalMatches(boolean includeSingles) throws IOException, InterruptedException {
        this.checkRandom();
        if (this.nTable != 1) {
            throw new IllegalStateException("Internal matches only make sense with a single table");
        }
        this.startMatch();
        LinkSet links = this.findPairs(this.getAllPossibleLinks());
        links = this.agglomerateLinks(links);
        if (includeSingles) {
            Iterator it = this.missingSingles(links, 0).iterator();
            while (it.hasNext()) {
                links.addLink((RowLink)it.next());
                it.remove();
            }
        }
        this.endMatch();
        return links;
    }

    private LinkSet findPairs(LinkSet possibleLinks) throws IOException, InterruptedException {
        LinkSet pairs = this.createLinkSet();
        double nLink = possibleLinks.size();
        int iLink = 0;
        this.indicator.startStage("Locating pairs");
        Iterator it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            it.remove();
            int nref = link.size();
            if (nref > 1) {
                Object[][] binnedRows = new Object[nref][];
                int i = 0;
                while (i < nref) {
                    RowRef ref = link.getRef(i);
                    StarTable table = this.tables[ref.getTableIndex()];
                    binnedRows[i] = table.getRow(ref.getRowIndex());
                    ++i;
                }
                int i2 = 0;
                while (i2 < nref) {
                    int j = 0;
                    while (j < i2) {
                        double score;
                        RowLink pair = new RowLink(link.getRef(i2), link.getRef(j));
                        if (!pairs.containsLink(pair) && (score = this.engine.matchScore(binnedRows[i2], binnedRows[j])) >= 0.0) {
                            pair.setScore(score);
                            pairs.addLink(pair);
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        return pairs;
    }

    private LinkSet findInterPairs(LinkSet possibleLinks, int index1, int index2) throws IOException, InterruptedException {
        LinkSet pairs = this.createLinkSet();
        double nLink = possibleLinks.size();
        int iLink = 0;
        this.indicator.startStage("Locating inter-table pairs");
        Iterator it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            it.remove();
            int nref = link.size();
            if (nref > 1) {
                boolean got1 = false;
                boolean got2 = false;
                int i = 0;
                while (!(i >= nref || got1 && got2)) {
                    int tableIndex = link.getRef(i).getTableIndex();
                    got1 = got1 || tableIndex == index1;
                    got2 = got2 || tableIndex == index2;
                    ++i;
                }
                if (got1 && got2) {
                    Object[][] binnedRows = new Object[nref][];
                    int i2 = 0;
                    while (i2 < nref) {
                        RowRef ref = link.getRef(i2);
                        StarTable table = this.tables[ref.getTableIndex()];
                        binnedRows[i2] = table.getRow(ref.getRowIndex());
                        ++i2;
                    }
                    int i3 = 0;
                    while (i3 < nref) {
                        RowRef refI = link.getRef(i3);
                        int iTableI = refI.getTableIndex();
                        int j = 0;
                        while (j < i3) {
                            double score;
                            RowLink pair;
                            RowRef refJ = link.getRef(j);
                            int iTableJ = refJ.getTableIndex();
                            if ((iTableI == index1 && iTableJ == index2 || iTableI == index2 && iTableJ == index1) && !pairs.containsLink(pair = new RowLink(refI, refJ)) && (score = this.engine.matchScore(binnedRows[i3], binnedRows[j])) >= 0.0) {
                                pair.setScore(score);
                                pairs.addLink(pair);
                            }
                            ++j;
                        }
                        ++i3;
                    }
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        return pairs;
    }

    private LinkSet getAllPossibleLinks() throws IOException, InterruptedException {
        BinContents bins = new BinContents(this.indicator);
        long totalRows = 0L;
        long nBin = 0L;
        int itab = 0;
        while (itab < this.nTable) {
            StarTable table = this.tables[itab];
            ProgressRowSequence rseq = new ProgressRowSequence(this.tables[itab], this.indicator, "Binning rows for table " + (itab + 1));
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] keys = this.engine.getBins(rseq.getRow());
                int nkey = keys.length;
                if (nkey > 0) {
                    RowRef rref = new RowRef(itab, lrow);
                    int ikey = 0;
                    while (ikey < nkey) {
                        bins.putRowInBin(keys[ikey], rref);
                        ++ikey;
                    }
                }
                nBin += (long)nkey;
                ++totalRows;
                ++lrow;
            }
            rseq.close();
            ++itab;
        }
        this.indicator.logMessage("Average bin count per row: " + (float)((double)nBin / (double)totalRows));
        LinkSet links = this.createLinkSet();
        bins.addRowLinks(links);
        return links;
    }

    public LinkSet getPossibleInterLinks(int index1, int index2) throws IOException, InterruptedException {
        int ncol = this.tables[index1].getColumnCount();
        if (this.tables[index2].getColumnCount() != ncol) {
            throw new IllegalStateException();
        }
        long nIncludedRows1 = this.tables[index1].getRowCount();
        long nIncludedRows2 = this.tables[index2].getRowCount();
        Object[] min = new Comparable[ncol];
        Object[] max = new Comparable[ncol];
        if (this.engine.canBoundMatch()) {
            this.indicator.logMessage("Attempt to locate restricted common region");
            try {
                Comparable[][] bounds1 = this.getBounds(index1);
                Comparable[][] bounds2 = this.getBounds(index2);
                Comparable[] min1 = bounds1[0];
                Comparable[] max1 = bounds1[1];
                Comparable[] min2 = bounds2[0];
                Comparable[] max2 = bounds2[1];
                int i = 0;
                while (i < ncol) {
                    if (min1[i] != null && min2[i] != null) {
                        Object object = min[i] = min1[i].compareTo(min2[i]) > 0 ? min1[i] : min2[i];
                    }
                    if (max1[i] != null && max2[i] != null) {
                        max[i] = max1[i].compareTo(max2[i]) < 0 ? max1[i] : max2[i];
                    }
                    ++i;
                }
                this.logTupleBounds("Potential match region: ", min, max);
                nIncludedRows1 = this.countInRange(index1, (Comparable[])min, (Comparable[])max);
                nIncludedRows2 = this.countInRange(index2, (Comparable[])min, (Comparable[])max);
            }
            catch (ClassCastException e) {
                this.indicator.logMessage("Common region location failed (incompatible value types)");
                min = new Comparable[ncol];
                max = new Comparable[ncol];
            }
        }
        return nIncludedRows1 < nIncludedRows2 ? this.getPossibleInterLinks(index1, index2, (Comparable[])min, (Comparable[])max) : this.getPossibleInterLinks(index2, index1, (Comparable[])min, (Comparable[])max);
    }

    private LinkSet getPossibleInterLinks(int index1, int index2, Comparable[] min, Comparable[] max) throws IOException, InterruptedException {
        int ikey;
        RowRef rref;
        Object[] keys;
        int nkey;
        Object[] row;
        BinContents bins = new BinContents(this.indicator);
        ProgressRowSequence rseq1 = new ProgressRowSequence(this.tables[index1], this.indicator, "Binning rows for table " + (index1 + 1));
        long exclude1 = 0L;
        long lrow1 = 0L;
        while (rseq1.nextProgress()) {
            row = rseq1.getRow();
            if (this.inRange(row, min, max) && (nkey = (keys = this.engine.getBins(row)).length) > 0) {
                rref = new RowRef(index1, lrow1);
                ikey = 0;
                while (ikey < nkey) {
                    bins.putRowInBin(keys[ikey], rref);
                    ++ikey;
                }
            }
            ++lrow1;
        }
        rseq1.close();
        if (exclude1 > 0L) {
            this.indicator.logMessage(exclude1 + " rows excluded (out of match region)");
        }
        ProgressRowSequence rseq2 = new ProgressRowSequence(this.tables[index2], this.indicator, "Binning rows for table " + (index2 + 1));
        long exclude2 = 0L;
        long lrow2 = 0L;
        while (rseq2.nextProgress()) {
            row = rseq2.getRow();
            if (this.inRange(row, min, max) && (nkey = (keys = this.engine.getBins(row)).length) > 0) {
                rref = new RowRef(index2, lrow2);
                ikey = 0;
                while (ikey < nkey) {
                    Object key = keys[ikey];
                    if (bins.containsKey(key)) {
                        bins.putRowInBin(key, rref);
                    }
                    ++ikey;
                }
            }
            ++lrow2;
        }
        rseq2.close();
        if (exclude2 > 0L) {
            this.indicator.logMessage(exclude2 + " rows excluded (out of match region)");
        }
        LinkSet links = this.createLinkSet();
        bins.addRowLinks(links);
        return links;
    }

    private void eliminateInternalLinks(LinkSet links) throws InterruptedException {
        Object[] refs = new RowRef[this.nTable];
        LinkSet replacements = this.createLinkSet();
        this.indicator.startStage("Eliminating internal links");
        double nLink = links.size();
        int iLink = 0;
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            if (link.size() > 1) {
                Arrays.fill(refs, null);
                boolean dup = false;
                int i = 0;
                while (i < nref) {
                    RowRef ref = link.getRef(i);
                    int iTable = ref.getTableIndex();
                    if (refs[iTable] == null) {
                        refs[iTable] = ref;
                    } else {
                        dup = true;
                    }
                    ++i;
                }
                if (dup) {
                    it.remove();
                    ArrayList<Object> repRefs = new ArrayList<Object>();
                    int i2 = 0;
                    while (i2 < this.nTable) {
                        if (refs[i2] != null) {
                            repRefs.add(refs[i2]);
                        }
                        ++i2;
                    }
                    RowLink repLink = new RowLink(repRefs);
                    replacements.addLink(repLink);
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        this.indicator.logMessage("Internal links removed: " + replacements.size());
        Iterator it2 = replacements.iterator();
        while (it2.hasNext()) {
            RowLink repLink = (RowLink)it2.next();
            links.addLink(repLink);
            it2.remove();
        }
    }

    private LinkSet missingSingles(LinkSet links, int iTable) {
        BitSet present = new BitSet();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() == iTable) {
                    present.set(this.checkedLongToInt(ref.getRowIndex()));
                }
                ++i;
            }
        }
        int nrow = this.checkedLongToInt(this.tables[iTable].getRowCount());
        LinkSet singles = this.createLinkSet();
        int iRow = 0;
        while (iRow < nrow) {
            if (!present.get(iRow)) {
                singles.addLink(new RowLink(new RowRef(iTable, iRow)));
            }
            ++iRow;
        }
        return singles;
    }

    private boolean acceptRow(RowLink link, boolean[] useAll) {
        boolean[] present = new boolean[this.nTable];
        int nref = link.size();
        int i = 0;
        while (i < nref) {
            RowRef ref = link.getRef(i);
            int iTable = ref.getTableIndex();
            present[iTable] = true;
            ++i;
        }
        boolean ok = true;
        int i2 = 0;
        while (i2 < this.nTable) {
            boolean pres = present[i2];
            if (useAll[i2]) {
                if (pres) {
                    return true;
                }
            } else if (!pres) {
                ok = false;
            }
            ++i2;
        }
        return ok;
    }

    private LinkSet eliminateMultipleRowEntries(LinkSet pairs) throws InterruptedException {
        HashMap<RowRef, RowLink> bestRowScores = new HashMap<RowRef, RowLink>();
        LinkSet inPairs = pairs;
        LinkSet outPairs = this.createLinkSet();
        double nPair = inPairs.size();
        int iPair = 0;
        this.indicator.startStage("Eliminating multiple row references");
        Iterator it = inPairs.iterator();
        while (it.hasNext()) {
            RowLink pair = (RowLink)it.next();
            it.remove();
            double score = pair.getScore();
            if (pair.size() != 2 || Double.isNaN(score) || score < 0.0) {
                throw new IllegalArgumentException();
            }
            RowRef ref1 = pair.getRef(0);
            RowRef ref2 = pair.getRef(1);
            if (ref1.getTableIndex() != 0 || ref2.getTableIndex() != 1) {
                throw new IllegalArgumentException();
            }
            RowLink best1 = (RowLink)bestRowScores.get(ref1);
            RowLink best2 = (RowLink)bestRowScores.get(ref2);
            if ((best1 == null || score < best1.getScore()) && (best2 == null || score < best2.getScore())) {
                if (best1 != null) {
                    outPairs.removeLink(best1);
                }
                if (best2 != null) {
                    outPairs.removeLink(best2);
                }
                outPairs.addLink(pair);
                bestRowScores.put(ref1, pair);
                bestRowScores.put(ref2, pair);
            }
            this.indicator.setLevel((double)(++iPair) / nPair);
        }
        this.indicator.endStage();
        if (!$assertionsDisabled && inPairs.size() != 0) {
            throw new AssertionError();
        }
        return outPairs;
    }

    private LinkSet agglomerateLinks(LinkSet links) throws InterruptedException {
        this.indicator.logMessage("Agglomerating links");
        HashMap refMap = new HashMap();
        Iterator linkIt = links.iterator();
        while (linkIt.hasNext()) {
            RowLink link = (RowLink)linkIt.next();
            int nref = link.size();
            int i = 0;
            while (i < nref) {
                RowRef ref = link.getRef(i);
                if (!refMap.containsKey(ref)) {
                    refMap.put(ref, new LinkedList());
                }
                ((Collection)refMap.get(ref)).add(link);
                ++i;
            }
        }
        LinkSet agglomeratedLinks = this.createLinkSet();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            boolean isolated = true;
            int i = 0;
            while (isolated && i < nref) {
                RowRef ref = link.getRef(i);
                Collection refLinks = (Collection)refMap.get(ref);
                isolated = isolated && refLinks.size() == 1;
                ++i;
            }
            if (!isolated) continue;
            agglomeratedLinks.addLink(link);
            int i2 = 0;
            while (i2 < nref) {
                RowRef ref = link.getRef(i2);
                Object removed = refMap.remove(ref);
                if (!$assertionsDisabled && removed == null) {
                    throw new AssertionError();
                }
                ++i2;
            }
        }
        double nRefs = refMap.size();
        this.indicator.startStage("Walking links");
        while (!refMap.isEmpty()) {
            this.indicator.setLevel(1.0 - (double)refMap.size() / nRefs);
            RowRef ref1 = (RowRef)refMap.keySet().iterator().next();
            HashSet refSet = new HashSet();
            RowMatcher.walkLinks(ref1, refMap, refSet);
            agglomeratedLinks.addLink(new RowLink(refSet));
        }
        this.indicator.endStage();
        return agglomeratedLinks;
    }

    private static void walkLinks(RowRef baseRef, Map refMap, Set outSet) {
        if (!outSet.contains(baseRef)) {
            Collection links = (Collection)refMap.get(baseRef);
            if (!links.isEmpty()) {
                outSet.add(baseRef);
                Iterator linkIt = links.iterator();
                while (linkIt.hasNext()) {
                    RowLink link = (RowLink)linkIt.next();
                    int i = 0;
                    while (i < link.size()) {
                        RowRef rref = link.getRef(i);
                        RowMatcher.walkLinks(rref, refMap, outSet);
                        ++i;
                    }
                    linkIt.remove();
                }
            }
            if (links.isEmpty()) {
                refMap.remove(baseRef);
            }
        }
    }

    private void checkRandom() {
        int itab = 0;
        while (itab < this.tables.length) {
            if (!this.tables[itab].isRandom()) {
                throw new IllegalArgumentException("Table " + this.tables[itab] + " is not random access");
            }
            ++itab;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparable[][] getBounds(int tIndex) throws IOException, InterruptedException {
        if (!this.engine.canBoundMatch()) {
            return new Comparable[2][];
        }
        StarTable table = this.tables[tIndex];
        int ncol = table.getColumnCount();
        boolean[] isComparable = new boolean[ncol];
        int ncomp = 0;
        int icol = 0;
        while (icol < ncol) {
            if ((class$java$lang$Comparable == null ? RowMatcher.class$("java.lang.Comparable") : class$java$lang$Comparable).isAssignableFrom(table.getColumnInfo(icol).getContentClass())) {
                isComparable[icol] = true;
                ++ncomp;
            }
            ++icol;
        }
        if (ncomp == 0) {
            return new Comparable[2][];
        }
        Object[] mins = new Comparable[ncol];
        Object[] maxs = new Comparable[ncol];
        ProgressRowSequence rseq = new ProgressRowSequence(table, this.indicator, "Assessing range of coordinates from table " + (tIndex + 1));
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                int icol2 = 0;
                while (icol2 < ncol) {
                    Object cell;
                    if (isComparable[icol2] && (cell = row[icol2]) instanceof Comparable) {
                        Comparable val = (Comparable)cell;
                        if (mins[icol2] == null || mins[icol2].compareTo(val) > 0) {
                            mins[icol2] = val;
                        }
                        if (maxs[icol2] == null || maxs[icol2].compareTo(val) < 0) {
                            maxs[icol2] = val;
                        }
                    }
                    ++icol2;
                }
                ++lrow;
            }
            Object var17_15 = null;
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
        this.logTupleBounds("Limits are: ", mins, maxs);
        return this.engine.getMatchBounds((Comparable[])mins, (Comparable[])maxs);
    }

    private boolean inRange(Object[] row, Comparable[] min, Comparable[] max) {
        if (min != null && max != null) {
            int ncol = row.length;
            int i = 0;
            while (i < ncol) {
                if (row[i] instanceof Comparable) {
                    Comparable val = (Comparable)row[i];
                    if (min[i] != null && val.compareTo(min[i]) < 0 || max[i] != null && val.compareTo(max[i]) > 0) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countInRange(int tIndex, Comparable[] min, Comparable[] max) throws IOException, InterruptedException {
        ProgressRowSequence rseq = new ProgressRowSequence(this.tables[tIndex], this.indicator, "Counting rows in match region for table " + (tIndex + 1));
        long nInclude = 0L;
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                if (this.inRange(rseq.getRow(), min, max)) {
                    ++nInclude;
                }
                ++lrow;
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
        this.indicator.logMessage(nInclude + " rows in match region");
        return nInclude;
    }

    private void logTupleBounds(String heading, Object[] mins, Object[] maxs) {
        int ncol = 0;
        if (mins != null) {
            ncol = mins.length;
        } else if (maxs != null) {
            ncol = maxs.length;
        }
        if (ncol == 0) {
            return;
        }
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < ncol) {
            if (i > 0) {
                sbuf.append(", ");
            }
            if (mins != null && mins[i] instanceof Number) {
                sbuf.append(((Number)mins[i]).floatValue());
            }
            sbuf.append(" .. ");
            if (maxs != null && maxs[i] instanceof Number) {
                sbuf.append(((Number)maxs[i]).floatValue());
            }
            ++i;
        }
        this.indicator.logMessage(heading + sbuf);
    }

    private void startMatch() {
        this.startTime = new Date().getTime();
    }

    private void endMatch() {
        long millis = new Date().getTime() - this.startTime;
        this.indicator.logMessage("Elapsed time for match: " + millis / 1000L + " seconds");
    }

    private int checkedLongToInt(long lval) {
        return Tables.checkedLongToInt(lval);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$table$join$RowMatcher == null ? (class$uk$ac$starlink$table$join$RowMatcher = RowMatcher.class$("uk.ac.starlink.table.join.RowMatcher")) : class$uk$ac$starlink$table$join$RowMatcher).desiredAssertionStatus();
    }
}

