/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hdx;

import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import uk.ac.starlink.hdx.HdxDOMImplementation;
import uk.ac.starlink.hdx.HdxDocument;
import uk.ac.starlink.hdx.HdxElement;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFacade;
import uk.ac.starlink.hdx.HdxNode;
import uk.ac.starlink.hdx.HdxResourceType;
import uk.ac.starlink.hdx.PluginException;
import uk.ac.starlink.util.DOMUtils;

public class HdxDocument
extends HdxNode
implements Document {
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$hdx$HdxDocument;

    public HdxDocument() {
        super((short)9, null);
    }

    public DocumentType getDoctype() {
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public DOMImplementation getImplementation() {
        return HdxDOMImplementation.getInstance();
    }

    public Element getDocumentElement() {
        Node kid = this.getFirstChild();
        while (kid != null) {
            if (kid.getNodeType() == 1) {
                if (!$assertionsDisabled && !(kid instanceof HdxElement)) {
                    throw new AssertionError();
                }
                return (Element)kid;
            }
            kid = kid.getNextSibling();
        }
        return null;
    }

    public Element createElement(String tagName) throws DOMException {
        return new HdxElement(tagName, (Document)this);
    }

    public Element createElement(HdxFacade facade) throws DOMException {
        return new HdxFacadeElement(facade.getHdxResourceType(), this, facade);
    }

    public DocumentFragment createDocumentFragment() {
        final class HdxDocumentFragment
        extends HdxNode
        implements DocumentFragment {
            private final /* synthetic */ HdxDocument this$0;

            HdxDocumentFragment(HdxDocument this$0, Document owner) {
                this.this$0 = this$0;
                super((short)11, owner);
            }

            public String getNodeName() {
                return "#document-fragment";
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append("HdxDocumentFragment(");
                Node kid = this.getFirstChild();
                while (kid != null) {
                    sb.append(((HdxNode)kid).getNodeName());
                    sb.append(',');
                    kid = kid.getNextSibling();
                }
                sb.append(')');
                return sb.toString();
            }
        }
        return new HdxDocumentFragment(this, (Document)this);
    }

    public Text createTextNode(String data) {
        return new HdxText(3, this, data);
    }

    public Comment createComment(String data) {
        class HdxComment
        extends HdxCharacterData
        implements Comment {
            private final /* synthetic */ HdxDocument this$0;

            HdxComment(HdxDocument this$0, String data) {
                this.this$0 = this$0;
                super((short)8, this$0, data);
            }

            public String getNodeName() {
                return "#comment";
            }
        }
        return new HdxComment(this, data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        class HdxCDATASection
        extends HdxText
        implements CDATASection {
            private final /* synthetic */ HdxDocument this$0;

            HdxCDATASection(HdxDocument this$0, Document owner, String data) {
                this.this$0 = this$0;
                super((short)4, owner, data);
            }

            public String getNodeName() {
                return "#cdata-section";
            }
        }
        return new HdxCDATASection(this, this, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        class HdxProcessingInstruction
        extends HdxNode
        implements ProcessingInstruction {
            private String target;
            private String data;
            private final /* synthetic */ HdxDocument this$0;

            HdxProcessingInstruction(HdxDocument this$0, Document owner, String target, String data) {
                this.this$0 = this$0;
                super((short)7, owner);
                this.target = target;
                this.data = data;
            }

            public String getTarget() {
                return this.target;
            }

            public String getData() {
                return this.data;
            }

            public void setData(String data) {
                this.data = data;
            }

            public String getNodeName() {
                return this.target;
            }

            public String getNodeValue() {
                return this.data;
            }

            public void setNodeValue(String nodeValue) {
                this.data = nodeValue;
            }

            public Object clone() {
                HdxProcessingInstruction c = (HdxProcessingInstruction)super.clone();
                c.target = new String(this.target);
                c.data = new String(this.data);
                return c;
            }

            public boolean equals(Object o) {
                if (o == null || !(o instanceof HdxProcessingInstruction)) {
                    return false;
                }
                HdxProcessingInstruction ho = (HdxProcessingInstruction)o;
                return this.target.equals(ho.target) && this.data.equals(ho.data);
            }

            public int hashCode() {
                return new HdxNode.HashCode(this.target.hashCode()).add(this.data.hashCode()).value();
            }
        }
        return new HdxProcessingInstruction(this, this, target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return HdxElement.newHdxAttr(name, this);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        throw new DOMException(9, "HdxDocument does not support Entity References");
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.getDocumentElement().getElementsByTagName(tagname);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new NodeList(){

            public int getLength() {
                return 0;
            }

            public Node item(int index) {
                return null;
            }
        };
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        Node retNode = null;
        switch (importedNode.getNodeType()) {
            case 2: {
                Attr a = (Attr)importedNode;
                retNode = this.createAttribute(a.getName());
                ((Attr)retNode).setValue(a.getValue());
                break;
            }
            case 4: {
                retNode = this.createCDATASection(((CDATASection)importedNode).getData());
                break;
            }
            case 8: {
                retNode = this.createComment(((Comment)importedNode).getData());
                break;
            }
            case 11: {
                retNode = this.createDocumentFragment();
                break;
            }
            case 9: 
            case 10: {
                throw new DOMException(9, "Nodes of type " + DOMUtils.mapNodeType(importedNode.getNodeType()) + " cannot be imported");
            }
            case 1: {
                retNode = this.createElement(importedNode.getNodeName());
                NamedNodeMap atts = importedNode.getAttributes();
                int i = 0;
                while (i < atts.getLength()) {
                    ((Element)retNode).setAttributeNode((Attr)this.importNode(atts.item(i), deep));
                    ++i;
                }
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                throw new DOMException(9, "HdxDocument.importNode: importing node type " + importedNode.getNodeType() + '=' + DOMUtils.mapNodeType(importedNode.getNodeType()) + " not supported");
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)importedNode;
                retNode = this.createProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 3: {
                retNode = this.createTextNode(((Text)importedNode).getData());
                break;
            }
            default: {
                throw new DOMException(9, "HdxDocument.importNode: Unrecognised node type " + importedNode.getNodeType() + '=' + DOMUtils.mapNodeType(importedNode.getNodeType()) + " not supported");
            }
        }
        if (deep) {
            Node n = importedNode.getFirstChild();
            while (n != null) {
                retNode.appendChild(this.importNode(n, true));
                n = n.getNextSibling();
            }
        }
        return retNode;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "createElementNS not supported");
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "createAttributeNS not supported");
    }

    public Element getElementById(String elementId) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$hdx$HdxDocument == null ? (class$uk$ac$starlink$hdx$HdxDocument = HdxDocument.class$("uk.ac.starlink.hdx.HdxDocument")) : class$uk$ac$starlink$hdx$HdxDocument).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.hdx");
    }

    public static class NodeUtil {
        private static Transformer trans;

        public static String serializeNode(Node n) {
            String ret;
            try {
                StringWriter sw = new StringWriter();
                if (trans == null) {
                    trans = TransformerFactory.newInstance().newTransformer();
                    trans.setOutputProperty("omit-xml-declaration", "yes");
                }
                trans.transform(new DOMSource(n), new StreamResult(sw));
                ret = sw.toString();
            }
            catch (TransformerException ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("Can't transform DOM: " + ex);
                }
                ret = "";
            }
            return ret;
        }
    }

    private class HdxText
    extends HdxCharacterData
    implements Text {
        HdxText(short nodeType, Document owner, String content) {
            super(nodeType, owner, content);
        }

        public Text splitText(int offset) {
            HdxText newText = new HdxText(3, this.getOwnerDocument(), this.content.substring(offset));
            this.content = this.content.substring(0, offset);
            Node parent = this.getParentNode();
            if (parent != null) {
                parent.insertBefore(newText, this.getNextSibling());
            }
            return newText;
        }

        public String getNodeName() {
            return "#text";
        }
    }

    private class HdxCharacterData
    extends HdxNode
    implements CharacterData {
        protected String content;
        private String chdataType;
        private StringBuffer sb;

        HdxCharacterData(short nodeType, Document owner, String content) {
            super(nodeType, owner);
            switch (nodeType) {
                case 8: {
                    this.chdataType = "Comment";
                    break;
                }
                case 4: {
                    this.chdataType = "CDATA section";
                    break;
                }
                case 3: {
                    this.chdataType = "Text";
                    break;
                }
                default: {
                    throw new AssertionError((Object)("HdxCharacterData does not support nodes of type " + DOMUtils.mapNodeType(nodeType)));
                }
            }
            this.content = content;
        }

        public String getData() throws DOMException {
            if (this.sb != null) {
                this.content = this.sb.toString();
                this.sb = null;
            }
            return this.content;
        }

        public String getNodeValue() {
            return this.getData();
        }

        public void setNodeValue(String value) throws DOMException {
            this.setData(value);
        }

        public void setData(String data) throws DOMException {
            this.sb = null;
            this.content = data;
        }

        public int getLength() {
            return this.getData().length();
        }

        public String substringData(int offset, int count) throws DOMException {
            if (this.sb != null) {
                this.content = this.sb.toString();
                this.sb = null;
            }
            if (offset < 0 || offset >= this.content.length() || count < 0) {
                throw new DOMException(1, this.chdataType + ": invalid offset");
            }
            int end = offset + count;
            if (end > this.content.length()) {
                end = this.content.length();
            }
            return this.content.substring(offset, end);
        }

        public void appendData(String arg) throws DOMException {
            if (this.sb == null) {
                this.sb = new StringBuffer(this.content);
            }
            this.sb.append(arg);
        }

        public void insertData(int offset, String arg) throws DOMException {
            if (this.sb == null) {
                this.sb = new StringBuffer(this.content);
            }
            this.sb.insert(offset, arg);
        }

        public void deleteData(int offset, int count) throws DOMException {
            if (this.sb == null) {
                this.sb = new StringBuffer(this.content);
            }
            this.sb.delete(offset, offset + count);
        }

        public void replaceData(int offset, int count, String arg) throws DOMException {
            if (this.sb == null) {
                this.sb = new StringBuffer(this.content);
            }
            this.sb.replace(offset, offset + count, arg);
        }

        public Object clone() {
            Object c = super.clone();
            HdxCharacterData d = (HdxCharacterData)c;
            d.content = new String(this.getData());
            d.sb = null;
            return d;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof HdxCharacterData)) {
                return false;
            }
            HdxCharacterData co = (HdxCharacterData)o;
            return this.getNodeType() == co.getNodeType() && this.getData().equals(co.getData());
        }

        public int hashCode() {
            return this.getData().hashCode();
        }
    }

    private static class HdxFacadeElement
    extends HdxElement
    implements Cloneable {
        private final HdxResourceType resourceType;
        private HdxFacade facade;
        private boolean suppressFacade;
        private Object facadeToken;
        static final /* synthetic */ boolean $assertionsDisabled;

        HdxFacadeElement(HdxResourceType resourceType, Document owner, HdxFacade facade) {
            super(resourceType == null ? null : resourceType.xmlName(), owner);
            if (resourceType == null || resourceType == HdxResourceType.NONE || facade == null) {
                throw new IllegalArgumentException("HdxFacadeElement: null Hdx type or facade");
            }
            this.resourceType = resourceType;
            this.facade = facade;
            if (!($assertionsDisabled || this.resourceType != null && this.facade != null)) {
                throw new AssertionError();
            }
            this.suppressFacade = false;
            this.facadeToken = null;
        }

        private boolean useFacade() {
            if (this.suppressFacade) {
                return false;
            }
            Node n = this.getParentNode();
            while (n != null) {
                if (!$assertionsDisabled && !(n instanceof HdxNode)) {
                    throw new AssertionError();
                }
                if (n instanceof HdxFacadeElement && ((HdxFacadeElement)n).suppressFacade) {
                    return false;
                }
                n = n.getParentNode();
            }
            return true;
        }

        public Object getNodeObject() {
            if (!$assertionsDisabled && this.facade == null) {
                throw new AssertionError();
            }
            try {
                Object ret = this.facade.getObject(this);
                if (!$assertionsDisabled && ret == null) {
                    throw new AssertionError();
                }
                return ret;
            }
            catch (HdxException ex) {
                throw new PluginException("facade.getObject() returned a null object for element " + this.getTagName());
            }
        }

        private void updateDOM() {
            try {
                if (!this.useFacade()) {
                    return;
                }
                this.suppressFacade = true;
                this.facadeToken = this.facade.synchronizeElement(this, this.facadeToken);
                this.suppressFacade = false;
            }
            catch (HdxException ex) {
                throw new PluginException(ex);
            }
        }

        public boolean hasAttribute(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.updateDOM();
            return super.hasAttribute(name);
        }

        public String getAttribute(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.updateDOM();
            return super.getAttribute(name);
        }

        public Attr getAttributeNode(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.updateDOM();
            return super.getAttributeNode(name);
        }

        public String getAttributeNS(String namespaceURI, String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            if (namespaceURI == null) {
                this.updateDOM();
            }
            return super.getAttributeNS(namespaceURI, name);
        }

        public Attr getAttributeNodeNS(String namespaceURI, String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            if (namespaceURI == null) {
                this.updateDOM();
            }
            return super.getAttributeNodeNS(namespaceURI, name);
        }

        void setAttribute(String name, String value, boolean useBacking) throws DOMException {
            if (name == null || value == null) {
                throw new IllegalArgumentException("name or value is null");
            }
            if (useBacking) {
                this.setAttribute(name, value);
            } else {
                super.setAttribute(name, value);
            }
        }

        public void setAttribute(String name, String value) throws DOMException {
            if (name == null || value == null) {
                throw new IllegalArgumentException("name or value is null");
            }
            if (this.useFacade() && !this.facade.setAttribute(this, name, value)) {
                this.readonlyFacade();
            }
            super.setAttribute(name, value);
        }

        public Attr setAttributeNode(Attr att) throws DOMException {
            if (att == null) {
                throw new IllegalArgumentException("att is null");
            }
            if (this.useFacade() && !this.facade.setAttribute(this, att.getName(), att.getValue())) {
                this.readonlyFacade();
            }
            return super.setAttributeNode(att);
        }

        public void setAttributeNS(String namespaceURI, String name, String value) throws DOMException {
            if (name == null || value == null) {
                throw new IllegalArgumentException("name or value is null");
            }
            if (this.useFacade() && namespaceURI != null && !this.facade.setAttribute(this, name, value)) {
                this.readonlyFacade();
            }
            super.setAttributeNS(namespaceURI, name, value);
        }

        public Attr setAttributeNodeNS(Attr att) throws DOMException {
            if (att == null) {
                throw new IllegalArgumentException("att is null");
            }
            if (this.useFacade() && att.getNamespaceURI() != null && !this.facade.setAttribute(this, att.getName(), att.getValue())) {
                this.readonlyFacade();
            }
            return super.setAttributeNodeNS(att);
        }

        public void removeAttribute(String name) throws DOMException {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            if (this.useFacade() && !this.facade.setAttribute(this, name, null)) {
                this.readonlyFacade();
            }
            super.removeAttribute(name);
        }

        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            if (oldAttr == null) {
                throw new IllegalArgumentException("oldAttr is null");
            }
            if (this.useFacade() && !this.facade.setAttribute(this, oldAttr.getName(), null)) {
                this.readonlyFacade();
            }
            return super.removeAttributeNode(oldAttr);
        }

        public void removeAttributeNS(String namespaceURI, String name) throws DOMException {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            if (this.useFacade() && namespaceURI != null && !this.facade.setAttribute(this, name, null)) {
                this.readonlyFacade();
            }
            super.removeAttributeNS(namespaceURI, name);
        }

        public NamedNodeMap getAttributes() {
            this.updateDOM();
            return super.getAttributes();
        }

        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            if (newChild == null) {
                throw new IllegalArgumentException("newChild is null");
            }
            if (this.useFacade() && !this.facade.addChildBefore(this, (Element)newChild, (Element)refChild)) {
                this.readonlyFacade();
            }
            return super.insertBefore(newChild, refChild);
        }

        public Node appendChild(Node newChild) throws DOMException {
            if (newChild == null) {
                throw new IllegalArgumentException("newChild is null");
            }
            if (this.useFacade() && !this.facade.addChildBefore(this, (Element)newChild, null)) {
                this.readonlyFacade();
            }
            return super.appendChild(newChild);
        }

        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            if (newChild == null) {
                throw new IllegalArgumentException("newChild is null");
            }
            if (this.useFacade() && !this.facade.replaceChild(this, (Element)oldChild, (Element)newChild)) {
                this.readonlyFacade();
            }
            return super.replaceChild(newChild, oldChild);
        }

        public Node removeChild(Node oldChild) throws DOMException {
            if (oldChild == null) {
                throw new IllegalArgumentException("oldChild is null");
            }
            if (this.useFacade() && !this.facade.replaceChild(this, (Element)oldChild, null)) {
                this.readonlyFacade();
            }
            return super.removeChild(oldChild);
        }

        private void readonlyFacade() throws DOMException {
            throw new DOMException(7, "HdxFacadeElement: no modification supported");
        }

        public Node getFirstChild() {
            this.updateDOM();
            return super.getFirstChild();
        }

        public Node getLastChild() {
            this.updateDOM();
            return super.getLastChild();
        }

        public boolean hasChildNodes() {
            this.updateDOM();
            return super.hasChildNodes();
        }

        public Node cloneNode(boolean deep) {
            return super.cloneNode(deep);
        }

        public boolean hasAttributes() {
            this.updateDOM();
            return super.hasAttributes();
        }

        public Object clone() {
            HdxFacadeElement fe = (HdxFacadeElement)super.clone(false);
            fe.facade = (HdxFacade)this.facade.clone();
            if (this.facadeToken != null) {
                try {
                    Class<?> ftc = this.facadeToken.getClass();
                    if (!$assertionsDisabled && ftc == null) {
                        throw new AssertionError();
                    }
                    Method ftclone = ftc.getMethod("clone", null);
                    System.err.println("cloning " + ftc.getName() + " with method " + ftclone + ", is accessible? " + ftclone.isAccessible());
                    fe.facadeToken = ftclone.invoke((Object)this, null);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Illegal access to clone: " + ex);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Coding error: can't call clone!? " + ex);
                }
            }
            return fe;
        }

        public boolean equals(Object t) {
            if (t == null) {
                return false;
            }
            if (!(t instanceof HdxFacadeElement)) {
                return false;
            }
            HdxFacadeElement tfe = (HdxFacadeElement)t;
            return this.resourceType == tfe.resourceType && this.facade.equals(tfe.facade);
        }

        public int hashCode() {
            return new HdxNode.HashCode(this.resourceType.hashCode()).add(this.facade.hashCode()).value();
        }

        public String toString() {
            return "HdxFacadeElement(" + this.resourceType + ")";
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$hdx$HdxDocument == null ? (class$uk$ac$starlink$hdx$HdxDocument = HdxDocument.class$("uk.ac.starlink.hdx.HdxDocument")) : class$uk$ac$starlink$hdx$HdxDocument).desiredAssertionStatus();
        }
    }
}

