/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hdx;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import uk.ac.starlink.hdx.HdxDocumentFactory;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFactory;

class XmlHdxDocumentFactory
implements HdxDocumentFactory {
    private static Logger logger = Logger.getLogger("uk.ac.starlink.hdx");
    private static XmlHdxDocumentFactory instance;
    private DocumentBuilder docBuilder;

    private XmlHdxDocumentFactory() throws HdxException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            this.docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new HdxException("Can't create parser: " + ex);
        }
    }

    public static HdxDocumentFactory getInstance() {
        return instance;
    }

    public Document makeHdxDocument(URL url) throws HdxException {
        String fn = url.getFile();
        if (fn.length() > 3 && fn.substring(fn.length() - 3).toLowerCase().equals("xml")) {
            return this.readXML(url);
        }
        return null;
    }

    public Source makeHdxSource(URL url) throws HdxException {
        Document d = this.makeHdxDocument(url);
        if (d == null) {
            return null;
        }
        return new DOMSource(d);
    }

    private Document readXML(URL url) throws HdxException {
        try {
            Document doc = this.docBuilder.parse(url.openStream());
            return doc;
        }
        catch (SAXException ex) {
            throw new HdxException("Can't parse XML: " + ex);
        }
        catch (IOException ex) {
            throw new HdxException("Can't open stream to URL: " + url);
        }
    }

    static {
        try {
            instance = new XmlHdxDocumentFactory();
            HdxFactory.registerHdxDocumentFactory(XmlHdxDocumentFactory.getInstance());
        }
        catch (HdxException e) {
            logger.severe("Failed to create XmlHdxDocumentFactory: " + e);
        }
    }
}

