/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.us_vo.www.SimpleResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableBuilder;

public class ConeSearch {
    SimpleResource resource_;
    private Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    static /* synthetic */ Class class$java$lang$String;

    public ConeSearch(SimpleResource resource) {
        this.resource_ = resource;
        String stype = this.resource_.getServiceType();
        if (!stype.equalsIgnoreCase("CONE")) {
            throw new IllegalArgumentException("ServiceType \"" + stype + "\" should be \"CONE\"");
        }
        new CgiQuery(this.resource_.getServiceURL());
    }

    public void performSearch(double ra, double dec, double sr, int verb, TableSink sink) throws IOException {
        URL qurl = this.getSearchURL(ra, dec, sr, verb);
        this.logger_.info("Submitting query: " + qurl);
        new VOTableBuilder().streamStarTable(qurl.openStream(), sink, null);
    }

    public StarTable performSearch(double ra, double dec, double sr, int verb, StarTableFactory tfact) throws IOException {
        VOElement topEl;
        URL qurl = this.getSearchURL(ra, dec, sr, verb);
        this.logger_.info("Submitting query: " + qurl);
        StoragePolicy storage = tfact.getStoragePolicy();
        try {
            topEl = new VOElementFactory(storage).makeVOElement(qurl.openStream(), qurl.toString());
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        NodeList tableEls = topEl.getElementsByTagName("TABLE");
        int i = 0;
        while (i < tableEls.getLength()) {
            Element tableEl = (Element)tableEls.item(i);
            if (tableEl instanceof TableElement) {
                VOStarTable st = new VOStarTable((TableElement)tableEl);
                st.setURL(qurl);
                return st;
            }
            ++i;
        }
        ConeSearch.throwErrorElement((Element)topEl);
        throw new IOException("No TABLE or error param in returned stream");
    }

    private static void throwErrorElement(Element el) throws IOException {
        String tagName = el.getTagName();
        if (tagName.indexOf(58) >= 0) {
            tagName = tagName.substring(tagName.indexOf(58) + 1);
        }
        if ((el.getTagName().equalsIgnoreCase("INFO") || el.getTagName().equalsIgnoreCase("PARAM")) && el.hasAttribute("name") && el.getAttribute("name").equalsIgnoreCase("ERROR")) {
            throw new IOException(el.getAttribute("value"));
        }
        Node node = el.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                ConeSearch.throwErrorElement((Element)node);
            }
            node = node.getNextSibling();
        }
    }

    public URL getSearchURL(double ra, double dec, double sr, int verb) {
        CgiQuery query = new CgiQuery(this.resource_.getServiceURL()).addArgument("RA", ra).addArgument("DEC", dec).addArgument("SR", sr);
        if (verb > 0 && verb < 3) {
            query.addArgument("VERB", sr);
        }
        return query.toURL();
    }

    public SimpleResource getResource() {
        return this.resource_;
    }

    public DescribedValue[] getMetadata() {
        ArrayList metadata = new ArrayList();
        ConeSearch.addMetadatum(metadata, this.resource_.getShortName(), "Service short name", "Short name for cone search service");
        ConeSearch.addMetadatum(metadata, this.resource_.getTitle(), "Service title", "Cone search service title");
        ConeSearch.addMetadatum(metadata, this.resource_.getDescription(), "Service description", "Description of cone search service");
        ConeSearch.addMetadatum(metadata, this.resource_.getReferenceURL(), "Service reference URL", "Descriptive URL for cone search service");
        ConeSearch.addMetadatum(metadata, this.resource_.getPublisher(), "Service publisher", "Publisher for cone search service");
        ConeSearch.addMetadatum(metadata, this.resource_.getServiceURL(), "Service endpoint", "Base URL for cone search service");
        return metadata.toArray(new DescribedValue[0]);
    }

    private static void addMetadatum(List metadata, String value, String name, String description) {
        if (value != null && value.trim().length() > 0) {
            DefaultValueInfo info = new DefaultValueInfo(name, class$java$lang$String == null ? (class$java$lang$String = ConeSearch.class$("java.lang.String")) : class$java$lang$String, description);
            metadata.add(new DescribedValue((ValueInfo)info, (Object)value));
        }
    }

    public String toString() {
        SimpleResource res = this.getResource();
        String id = null;
        if (id == null) {
            id = res.getShortName();
        }
        if (id == null) {
            id = res.getTitle();
        }
        if (id == null) {
            id = res.getServiceURL().toString();
        }
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

