/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.us_vo.www.SimpleResource;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.vo.ConeSearch;
import uk.ac.starlink.vo.ConeSearchDialog;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.RegistryServiceTableLoadDialog;
import uk.ac.starlink.vo.ResolverException;
import uk.ac.starlink.vo.ResolverInfo;
import uk.ac.starlink.vo.ValueFieldPanel;

public class ConeSearchDialog
extends RegistryServiceTableLoadDialog {
    private final Action resolveAction_;
    private final DoubleValueField raField_;
    private final DoubleValueField decField_;
    private final DoubleValueField srField_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public ConeSearchDialog() {
        super("Cone Search", "Obtain source catalogues using cone search web services", "serviceType like 'CONE'");
        Box resolveBox = Box.createHorizontalBox();
        JTextField resolveField = new JTextField(20);
        this.resolveAction_ = new ResolveAction(resolveField);
        resolveBox.add(new JLabel("Object Name: "));
        resolveBox.add(resolveField);
        resolveBox.add(Box.createHorizontalStrut(5));
        resolveBox.add(new JButton(this.resolveAction_));
        resolveBox.add(Box.createHorizontalGlue());
        this.getControlBox().add(resolveBox);
        this.getControlBox().add(Box.createVerticalStrut(5));
        Action okAction = this.getOkAction();
        this.raField_ = DoubleValueField.makeRADegreesField();
        this.raField_.getEntryField().addActionListener(okAction);
        this.raField_.setDescription("Right Ascension of cone centre (J2000)");
        this.decField_ = DoubleValueField.makeDecDegreesField();
        this.decField_.getEntryField().addActionListener(okAction);
        this.decField_.setDescription("Declination of cone centre (J2000)");
        this.srField_ = DoubleValueField.makeRadiusDegreesField();
        this.srField_.getEntryField().addActionListener(okAction);
        this.srField_.setDescription("Radius of cone search");
        ValueFieldPanel qPanel = new ValueFieldPanel();
        qPanel.addField(this.raField_, new JLabel("(J2000)"));
        qPanel.addField(this.decField_, new JLabel("(J2000)"));
        qPanel.addField(this.srField_);
        this.getControlBox().add(qPanel);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.raField_.setEnabled(enabled);
        this.decField_.setEnabled(enabled);
        this.srField_.setEnabled(enabled);
    }

    protected BasicTableLoadDialog.TableSupplier getTableSupplier() {
        SimpleResource[] resources = this.getRegistryPanel().getSelectedResources();
        if (resources.length != 1) {
            throw new IllegalStateException("No cone search service selected");
        }
        final ConeSearch coner = new ConeSearch(resources[0]);
        final double ra = this.raField_.getValue();
        final double dec = this.decField_.getValue();
        final double sr = this.srField_.getValue();
        boolean verb = false;
        final ArrayList<DescribedValue> metadata = new ArrayList<DescribedValue>();
        metadata.addAll(Arrays.asList(this.raField_.getDescribedValue(), this.decField_.getDescribedValue(), this.srField_.getDescribedValue()));
        metadata.addAll(Arrays.asList(coner.getMetadata()));
        return new BasicTableLoadDialog.TableSupplier(){

            public StarTable getTable(StarTableFactory factory, String format) throws IOException {
                StarTable st = coner.performSearch(ra, dec, sr, 0, factory);
                st.getParameters().addAll(metadata);
                return st;
            }

            public String getTableID() {
                return coner.toString();
            }
        };
    }

    private void setResolvedObject(ResolverInfo info) {
        this.setDegrees(this.raField_, info.getRaDegrees());
        this.setDegrees(this.decField_, info.getDecDegrees());
    }

    private void setDegrees(DoubleValueField field, double value) {
        JComboBox convSel = field.getConverterSelector();
        int i = 0;
        while (i < convSel.getItemCount()) {
            Object item = convSel.getItemAt(i);
            if ("degrees".equals(item.toString())) {
                convSel.setSelectedItem(item);
                field.getEntryField().setText(Double.toString(value));
                return;
            }
            ++i;
        }
        logger_.warning("Oops - no degrees option");
    }

    static /* synthetic */ void access$200(ConeSearchDialog x0, ResolverInfo x1) {
        x0.setResolvedObject(x1);
    }

    private class ResolveAction
    extends AbstractAction {
        final JTextField resolveField_;

        ResolveAction(JTextField field) {
            super("Resolve");
            this.resolveField_ = field;
            this.resolveField_.addActionListener(this);
        }

        public void actionPerformed(ActionEvent evt) {
            String name = this.resolveField_.getText();
            if (name == null || name.trim().length() == 0) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.setEnabled(false);
            new Thread(this, "Name Resolver: " + name, name){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ ResolveAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$name = val$name;
                    super(x0);
                }

                public void run() {
                    ResolverInfo info = null;
                    ResolverException error = null;
                    try {
                        info = ResolverInfo.resolve(this.val$name);
                    }
                    catch (ResolverException e) {
                        error = e;
                    }
                    ResolverInfo info1 = info;
                    ResolverException error1 = error;
                    SwingUtilities.invokeLater(new Runnable(this, info1, error1){
                        private final /* synthetic */ ResolverInfo val$info1;
                        private final /* synthetic */ ResolverException val$error1;
                        private final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = this$2;
                            this.val$info1 = val$info1;
                            this.val$error1 = val$error1;
                        }

                        public void run() {
                            if (this.val$info1 != null) {
                                ConeSearchDialog.access$200(ResolveAction.access$100(2.access$000(this.this$2)), this.val$info1);
                            } else {
                                ErrorDialog.showError((Component)((Object)ResolveAction.access$100(2.access$000(this.this$2))), (String)"Name Resolution Error", (Throwable)this.val$error1);
                            }
                            2.access$000(this.this$2).setEnabled(true);
                        }
                    });
                }

                static /* synthetic */ ResolveAction access$000(2 x0) {
                    return x0.this$1;
                }
            }.start();
        }

        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.resolveField_.setEnabled(isEnabled);
        }

        static /* synthetic */ ConeSearchDialog access$100(ResolveAction x0) {
            return x0.ConeSearchDialog.this;
        }
    }
}

