/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.vo.ValueConverter;

public class DoubleValueField {
    private final DefaultValueInfo info_;
    private final JLabel label_;
    private final JTextField entryField_;
    private final JComboBox convSelector_;
    static /* synthetic */ Class class$java$lang$Double;

    public DoubleValueField(String name, ValueConverter[] convs) {
        this((ValueInfo)new DefaultValueInfo(name, class$java$lang$Double == null ? (class$java$lang$Double = DoubleValueField.class$("java.lang.Double")) : class$java$lang$Double, ""), convs);
    }

    public DoubleValueField(ValueInfo info, ValueConverter[] convs) {
        this.info_ = new DefaultValueInfo(info);
        this.label_ = new JLabel(this.info_.getName() + ": ");
        this.entryField_ = new JTextField(12);
        this.convSelector_ = new JComboBox<ValueConverter>(convs);
        this.convSelector_.setSelectedIndex(0);
    }

    public DefaultValueInfo getValueInfo() {
        return this.info_;
    }

    public void setDescription(String description) {
        this.info_.setDescription(description);
        this.label_.setToolTipText(description);
        this.entryField_.setToolTipText(description);
    }

    public DescribedValue getDescribedValue() {
        Double val;
        try {
            val = new Double(this.getValue());
        }
        catch (Exception e) {
            val = null;
        }
        return new DescribedValue((ValueInfo)this.info_, (Object)val);
    }

    public JLabel getLabel() {
        return this.label_;
    }

    public JTextField getEntryField() {
        return this.entryField_;
    }

    public JComboBox getConverterSelector() {
        return this.convSelector_;
    }

    public double getValue() {
        ValueConverter vc = (ValueConverter)this.convSelector_.getSelectedItem();
        return vc.convertValue(this.getEntryField().getText());
    }

    public void setEnabled(boolean enabled) {
        this.entryField_.setEnabled(enabled);
        this.convSelector_.setEnabled(enabled);
    }

    public static DoubleValueField makeRADegreesField() {
        DefaultValueInfo info = new DefaultValueInfo("RA", class$java$lang$Double == null ? (class$java$lang$Double = DoubleValueField.class$("java.lang.Double")) : class$java$lang$Double, "Right Ascension");
        info.setUnitString("Degrees");
        return new DoubleValueField((ValueInfo)info, new ValueConverter[]{new ValueConverter.UnitValueConverter("degrees", 1.0), new ValueConverter.HMSDegreesValueConverter(), new ValueConverter.UnitValueConverter("radians", 57.29577951308232)});
    }

    public static DoubleValueField makeDecDegreesField() {
        DefaultValueInfo info = new DefaultValueInfo("Dec", class$java$lang$Double == null ? (class$java$lang$Double = DoubleValueField.class$("java.lang.Double")) : class$java$lang$Double, "Declination");
        info.setUnitString("Degrees");
        return new DoubleValueField((ValueInfo)info, new ValueConverter[]{new ValueConverter.UnitValueConverter("degrees", 1.0), new ValueConverter.DMSDegreesValueConverter(), new ValueConverter.UnitValueConverter("radians", 57.29577951308232)});
    }

    public static DoubleValueField makeRadiusDegreesField() {
        DefaultValueInfo info = new DefaultValueInfo("Radius", class$java$lang$Double == null ? (class$java$lang$Double = DoubleValueField.class$("java.lang.Double")) : class$java$lang$Double, "Search radius");
        info.setUnitString("Degrees");
        return new DoubleValueField((ValueInfo)info, new ValueConverter[]{new ValueConverter.UnitValueConverter("degrees", 1.0), new ValueConverter.UnitValueConverter("arcmin", 0.016666666666666666), new ValueConverter.UnitValueConverter("arcsec", 2.777777777777778E-4), new ValueConverter.UnitValueConverter("radians", 57.29577951308232)});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

