/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import uk.ac.starlink.vo.RegistryQuery;

public class RegistryQueryPanel
extends JPanel {
    private JComboBox urlSelector_;
    private JComboBox querySelector_;
    public static String[] KNOWN_REGISTRIES = new String[]{"http://voservices.net/registry/registry.asmx"};

    public RegistryQueryPanel() {
        super(new BorderLayout());
        Box qBox = Box.createVerticalBox();
        this.add((Component)qBox, "Center");
        Box urlLine = Box.createHorizontalBox();
        this.urlSelector_ = new JComboBox(KNOWN_REGISTRIES){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.urlSelector_.setSelectedIndex(0);
        urlLine.add(new JLabel("Registry: "));
        urlLine.add(this.urlSelector_);
        urlLine.add(Box.createHorizontalGlue());
        qBox.add(urlLine);
        qBox.add(Box.createVerticalStrut(5));
        Box queryLine = Box.createHorizontalBox();
        this.querySelector_ = new JComboBox();
        this.querySelector_.setEditable(true);
        queryLine.add(new JLabel("Query: "));
        queryLine.add(this.querySelector_);
        qBox.add(queryLine);
    }

    public void setPresetQueries(String[] queries) {
        this.querySelector_.setModel(new DefaultComboBoxModel<String>(queries));
        this.querySelector_.setSelectedIndex(0);
    }

    public JComboBox getUrlSelector() {
        return this.urlSelector_;
    }

    public JComboBox getQuerySelector() {
        return this.querySelector_;
    }

    public RegistryQuery getRegistryQuery() throws MalformedURLException {
        URL regURL;
        String regServ = (String)this.urlSelector_.getSelectedItem();
        String query = (String)this.querySelector_.getSelectedItem();
        if (query == null || query.trim().length() == 0) {
            throw new MalformedURLException("Query URL is blank");
        }
        if (regServ == null || regServ.trim().length() == 0) {
            throw new MalformedURLException("Registry URL is blank");
        }
        try {
            regURL = new URL(regServ);
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("Bad registry URL: " + regServ);
        }
        ComboBoxModel qModel = this.querySelector_.getModel();
        if (qModel instanceof MutableComboBoxModel) {
            boolean present = false;
            int i = 0;
            while (!present && i < qModel.getSize()) {
                if (query.equals(qModel.getElementAt(i))) {
                    present = true;
                }
                ++i;
            }
            if (!present) {
                ((MutableComboBoxModel)qModel).addElement(query);
            }
        }
        return new RegistryQuery(regURL, query);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.urlSelector_.setEnabled(enabled);
        this.querySelector_.setEnabled(enabled);
    }
}

