/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.connect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.BranchComboBox;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.connect.ConnectorManager;
import uk.ac.starlink.connect.FileBranch;
import uk.ac.starlink.connect.Leaf;
import uk.ac.starlink.connect.Node;
import uk.ac.starlink.connect.NodeComparator;

public class FilestoreChooser
extends JPanel {
    private final BranchComboBox branchSelector_;
    private final JList nodeList_;
    private final JScrollPane scroller_;
    private final JTextField nameField_;
    private final JButton logButton_;
    private final JComponent logBox_;
    private final JLabel logLabel_;
    private final PropertyChangeListener connectorWatcher_;
    private final Action upAction_;
    private final Action okAction_;
    private final Component[] activeComponents_;
    private Branch lastBranch_;
    private ConnectorAction connectorAction_;
    private List connectorActions_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.connect");

    public FilestoreChooser() {
        super(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        this.add((Component)main, "Center");
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border etchBorder = BorderFactory.createEtchedBorder();
        ArrayList<JComponent> activeList = new ArrayList<JComponent>();
        this.branchSelector_ = new BranchComboBox();
        activeList.add(this.branchSelector_);
        Box branchBox = Box.createHorizontalBox();
        branchBox.add(new JLabel("Location: "));
        branchBox.add(this.branchSelector_);
        branchBox.setBorder(gapBorder);
        this.add((Component)branchBox, "North");
        Icon upIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.upAction_ = new AbstractAction(null, upIcon){

            public void actionPerformed(ActionEvent evt) {
                Branch parent = FilestoreChooser.this.getBranch().getParent();
                if (parent != null) {
                    FilestoreChooser.this.setBranch(parent);
                }
            }
        };
        JButton upButton = new JButton(this.upAction_);
        branchBox.add(Box.createHorizontalStrut(5));
        branchBox.add(upButton);
        Icon homeIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        final Branch homedir = FilestoreChooser.getHomeBranch();
        AbstractAction homeAction = new AbstractAction(null, homeIcon){

            public void actionPerformed(ActionEvent evt) {
                if (homedir != null) {
                    FilestoreChooser.this.setBranch(homedir);
                }
            }
        };
        homeAction.setEnabled(homedir != null);
        JButton homeButton = new JButton(homeAction);
        activeList.add(homeButton);
        branchBox.add(Box.createHorizontalStrut(5));
        branchBox.add(homeButton);
        this.logBox_ = Box.createHorizontalBox();
        this.logButton_ = new JButton();
        this.logLabel_ = new JLabel();
        this.logBox_.add(this.logLabel_);
        this.logBox_.add(Box.createHorizontalStrut(5));
        this.logBox_.add(this.logButton_);
        this.logBox_.add(Box.createHorizontalGlue());
        this.logBox_.setBorder(gapBorder);
        this.setConnectorAction(null);
        main.add((Component)this.logBox_, "North");
        this.nodeList_ = new JList();
        this.nodeList_.setCellRenderer(new NodeRenderer());
        this.scroller_ = new JScrollPane(this.nodeList_);
        this.scroller_.setBorder(BorderFactory.createCompoundBorder(gapBorder, etchBorder));
        this.scroller_.setPreferredSize(new Dimension(450, 300));
        main.add((Component)this.scroller_, "Center");
        this.nameField_ = new JTextField();
        activeList.add(this.nameField_);
        Box nameBox = Box.createHorizontalBox();
        nameBox.add(new JLabel("File Name: "));
        nameBox.add(this.nameField_);
        nameBox.setBorder(gapBorder);
        this.add((Component)nameBox, "South");
        this.branchSelector_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    FilestoreChooser.this.setBranch((Branch)evt.getItem());
                }
            }
        });
        this.okAction_ = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent evt) {
                FilestoreChooser.this.ok();
            }
        };
        this.nameField_.addActionListener(this.okAction_);
        this.nodeList_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    FilestoreChooser.this.ok();
                }
            }
        });
        this.nodeList_.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "select");
        this.nodeList_.getActionMap().put("select", this.okAction_);
        this.nodeList_.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Object[] selected = FilestoreChooser.this.nodeList_.getSelectedValues();
                String text = null;
                if (selected.length == 1) {
                    text = ((Node)selected[0]).getName();
                    FilestoreChooser.this.nameField_.setText(text);
                }
            }
        });
        this.nameField_.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                FilestoreChooser.this.nodeList_.clearSelection();
            }

            public void focusLost(FocusEvent evt) {
            }
        });
        this.connectorWatcher_ = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof ConnectorAction) {
                    ConnectorAction connAct = (ConnectorAction)evt.getSource();
                    if (FilestoreChooser.this.branchSelector_.getConnectorAction() == connAct) {
                        if (evt.getPropertyName().equals("connection")) {
                            FilestoreChooser.this.refreshList();
                        }
                    }
                }
            }
        };
        this.activeComponents_ = activeList.toArray(new Component[0]);
    }

    public FilestoreChooser(Branch branch) {
        this();
        this.setBranch(branch);
    }

    public synchronized List getConnectorActions() {
        if (this.connectorActions_ == null) {
            this.connectorActions_ = new ArrayList<ConnectorAction>(Arrays.asList(ConnectorManager.getConnectorActions()));
        }
        return this.connectorActions_;
    }

    public Action getOkAction() {
        return this.okAction_;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.okAction_.setEnabled(enabled);
            int i = 0;
            while (i < this.activeComponents_.length) {
                this.activeComponents_[i].setEnabled(enabled);
                ++i;
            }
            this.upAction_.setEnabled(enabled && this.lastBranch_.getParent() != null);
        }
        super.setEnabled(enabled);
    }

    public void addDefaultBranches() {
        File[] fileRoots = File.listRoots();
        int i = 0;
        while (i < fileRoots.length) {
            File fileRoot = fileRoots[i];
            if (fileRoot.isDirectory() && fileRoot.canRead()) {
                this.branchSelector_.addBranch(new FileBranch(fileRoot));
            } else {
                logger_.warning("Local filesystem root " + fileRoot + " is not a readable directory");
            }
            ++i;
        }
        ConnectorAction[] actions = ConnectorManager.getConnectorActions();
        int i2 = 0;
        while (i2 < actions.length) {
            this.branchSelector_.addConnection(actions[i2]);
            ++i2;
        }
        File dir = new File(".");
        try {
            dir = new File(System.getProperty("user.dir"));
        }
        catch (SecurityException e) {
            logger_.warning("Can't get current directory");
        }
        if (dir.isDirectory()) {
            this.setBranch(new FileBranch(dir));
        } else {
            logger_.warning("Can't read current directory");
        }
    }

    public void setBranch(Branch branch) {
        if (branch != this.branchSelector_.getSelectedBranch()) {
            this.branchSelector_.setSelectedBranch(branch);
        }
        if (branch != this.lastBranch_) {
            this.lastBranch_ = branch;
            BoundedRangeModel scrollModel = this.scroller_.getVerticalScrollBar().getModel();
            scrollModel.setValue(scrollModel.getMinimum());
            this.refreshList();
            this.setConnectorAction(this.branchSelector_.getConnectorAction());
        }
        this.upAction_.setEnabled(branch.getParent() != null);
    }

    public void refreshList() {
        Branch branch = this.getBranch();
        Node[] children = branch == null ? new Node[]{} : branch.getChildren();
        Arrays.sort(children, NodeComparator.getInstance());
        this.nodeList_.setListData(children);
    }

    public Branch getBranch() {
        return this.branchSelector_.getSelectedBranch();
    }

    public void addConnection(ConnectorAction connAct) {
        this.branchSelector_.addConnection(connAct);
    }

    public Node[] getSelectedNodes() {
        return Arrays.asList(this.nodeList_.getSelectedValues()).toArray(new Node[0]);
    }

    public Node getSelectedNode() {
        Node[] nodes = this.getSelectedNodes();
        if (nodes.length == 1) {
            return nodes[0];
        }
        if (nodes.length == 0) {
            String name = this.nameField_.getText();
            if (name != null && name.trim().length() > 0) {
                return this.getBranch().createNode(name);
            }
            return null;
        }
        return null;
    }

    private void ok() {
        if (this.okAction_.isEnabled()) {
            Node node = this.getSelectedNode();
            if (node instanceof Leaf) {
                this.leafSelected((Leaf)node);
            } else if (node instanceof Branch) {
                this.setBranch((Branch)node);
            }
        }
    }

    private void setConnectorAction(ConnectorAction connectorAction) {
        if (connectorAction != this.connectorAction_) {
            if (this.connectorAction_ != null) {
                this.connectorAction_.removePropertyChangeListener(this.connectorWatcher_);
            }
            this.connectorAction_ = connectorAction;
            if (connectorAction != null) {
                this.logLabel_.setText(connectorAction.getConnector().getName());
                this.logButton_.setAction(connectorAction);
                connectorAction.addPropertyChangeListener(this.connectorWatcher_);
            }
        }
        this.logBox_.setVisible(connectorAction != null);
    }

    public ComboBoxModel getModel() {
        return this.branchSelector_.getModel();
    }

    public void setModel(ComboBoxModel model) {
        this.branchSelector_.setModel(model);
    }

    protected void leafSelected(Leaf leaf) {
    }

    private static Branch getHomeBranch() {
        try {
            File homedir;
            String home = System.getProperty("user.home");
            if (home != null && (homedir = new File(home)).isDirectory() && homedir.canRead()) {
                return new FileBranch(homedir);
            }
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        FilestoreChooser chooser = new FilestoreChooser(){

            /*
             * WARNING - void declaration
             */
            public void leafSelected(Leaf leaf) {
                try {
                    int c;
                    InputStream istrm = leaf.getDataSource().getInputStream();
                    while ((c = istrm.read()) >= 0) {
                        void var3_4;
                        System.out.write((int)var3_4);
                    }
                    System.exit(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        chooser.addDefaultBranches();
        JFrame frame = new JFrame();
        frame.getContentPane().add(chooser);
        frame.setLocationRelativeTo(null);
        frame.pack();
        frame.setVisible(true);
    }

    private static class NodeRenderer
    extends DefaultListCellRenderer {
        private Icon branchIcon = UIManager.getIcon("Tree.closedIcon");
        private Icon leafIcon = UIManager.getIcon("Tree.leafIcon");

        private NodeRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Icon icon = null;
            if (value instanceof Branch) {
                value = ((Branch)value).getName();
                icon = this.branchIcon;
            } else if (value instanceof Leaf) {
                value = ((Leaf)value).getName();
                icon = this.leafIcon;
            }
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (comp instanceof JLabel) {
                ((JLabel)comp).setIcon(icon);
            }
            return comp;
        }
    }
}

