/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pal;

import java.text.NumberFormat;
import uk.ac.starlink.pal.palError;

public class mjDate {
    private int year;
    private int month;
    private int day;
    private int dayinyear;
    private double fraction;
    private double djm;
    private int[] mtab = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public mjDate(int yr, int mn, int d) throws palError {
        if (yr < -4711) {
            throw new palError(1, "Invalid Year");
        }
        if (mn < 1 || mn > 12) {
            throw new palError(2, "Invalid Month");
        }
        int n = this.mtab[1] = yr % 4 == 0 && (yr % 100 != 0 || yr % 400 == 0) ? 29 : 28;
        if (d < 1 || d > this.mtab[mn - 1]) {
            throw new palError(3, "Invalid Day");
        }
        int i = 0;
        int dayinyear = d;
        while (i < mn) {
            dayinyear += this.mtab[i];
            ++i;
        }
        this.year = yr;
        this.month = mn;
        this.day = d;
        this.fraction = 0.0;
        this.djm = 0.0;
    }

    public mjDate(int yr, int mn, int d, double fract) throws palError {
        if (yr < -4711) {
            throw new palError(1, "Invalid Year");
        }
        if (mn < 1 || mn > 12) {
            throw new palError(2, "Invalid Month");
        }
        if (fract < 0.0 || fract > 1.0) {
            throw new palError(4, "Invalid Fraction");
        }
        int n = this.mtab[1] = yr % 4 == 0 && (yr % 100 != 0 || yr % 400 == 0) ? 29 : 28;
        if (d < 1 || d > this.mtab[mn - 1]) {
            throw new palError(3, "Invalid Day");
        }
        int i = 0;
        int dayinyear = d;
        while (i < mn) {
            dayinyear += this.mtab[i];
            ++i;
        }
        this.year = yr;
        this.month = mn;
        this.day = d;
        this.fraction = fract;
        this.djm = 0.0;
    }

    public mjDate(int yr, int diy) throws palError {
        if (yr < -4711) {
            throw new palError(1, "Invalid Year");
        }
        this.mtab[1] = yr % 4 == 0 && (yr % 100 != 0 || yr % 400 == 0) ? 29 : 28;
        int days = 0;
        int m = 0;
        while (m < 12) {
            if (diy <= (days += this.mtab[m])) {
                days -= this.mtab[m];
                this.month = m + 1;
                break;
            }
            ++m;
        }
        if (diy > days) {
            throw new palError(3, "Invalid day");
        }
        this.day = diy - days;
        this.year = yr;
        this.dayinyear = diy;
        this.fraction = 0.0;
        this.djm = 0.0;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getFraction(int n) {
        return (int)(this.fraction * Math.pow(10.0, n));
    }

    public double getFraction() {
        return this.fraction;
    }

    public int getDayinYear() {
        return this.dayinyear;
    }

    public String toString(int n) {
        NumberFormat frac = NumberFormat.getNumberInstance();
        frac.setMaximumIntegerDigits(0);
        frac.setMinimumIntegerDigits(0);
        frac.setMaximumFractionDigits(n);
        frac.setMinimumFractionDigits(n);
        return this.year + " " + this.month + " " + this.day + frac.format(this.fraction);
    }

    public String toString() {
        NumberFormat leadzero = NumberFormat.getNumberInstance();
        leadzero.setMinimumIntegerDigits(2);
        return this.day + "/" + leadzero.format(this.month) + "/" + this.year;
    }
}

