/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog;

import java.awt.geom.Point2D;
import jsky.coords.WorldCoordinateConverter;
import uk.ac.starlink.ast.AstException;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.FitsChan;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.SkyFrame;

public class AstTransform
implements WorldCoordinateConverter {
    private FrameSet frameSet = null;
    protected int raIndex = 1;
    protected int decIndex = 2;
    protected int nxpix = 0;
    protected int nypix = 0;
    protected Point2D.Double degPerPixel = null;
    public static final double R2D = 57.29577951308232;
    public static final double D2R = Math.PI / 180;
    protected static final double EPSILON = 2.220446049250313E-16;
    private String[] domains = null;
    private boolean isCelestial = true;

    public AstTransform(FrameSet frameSet, int nxpix, int nypix) {
        this.setFrameSet(frameSet, nxpix, nypix);
    }

    public AstTransform(double cra, double cdec, double xsecpix, double ysecpix, double xrpix, double yrpix, int nxpix, int nypix, double rotate, int equinox, double epoch, String proj) {
        FitsChan fitsChan = new FitsChan();
        fitsChan.putFits("NAXIS  = 2", false);
        fitsChan.putFits("NAXIS1 = " + nxpix, false);
        fitsChan.putFits("NAXIS2 = " + nypix, false);
        fitsChan.putFits("EQUINOX= " + equinox, false);
        if (epoch != 0.0) {
            fitsChan.putFits("EPOCH  = " + epoch, false);
        }
        fitsChan.putFits("CTYPE1 = RA---" + proj, false);
        fitsChan.putFits("CTYPE2 = DEC--" + proj, false);
        fitsChan.putFits("CRVAL1 = " + cra, false);
        fitsChan.putFits("CRVAL2 = " + cdec, false);
        fitsChan.putFits("CDELT1 = " + -xsecpix / 3600.0, false);
        fitsChan.putFits("CDELT2 = " + -ysecpix / 3600.0, false);
        fitsChan.putFits("CRPIX1 = " + xrpix, false);
        fitsChan.putFits("CRPIX2 = " + yrpix, false);
        fitsChan.putFits("CROTA1 = " + rotate, false);
        fitsChan.clear("Card");
        this.setFrameSet((FrameSet)fitsChan.read(), nxpix, nypix);
    }

    public void setFrameSet(FrameSet frameSet, int nxpix, int nypix) {
        this.frameSet = frameSet;
        this.setCelestial();
        this.nxpix = nxpix;
        this.nypix = nypix;
        this.setSecPix();
        this.domains = null;
    }

    protected void setCelestial() {
        this.isCelestial = false;
        Frame frame = this.frameSet.getFrame(FrameSet.AST__CURRENT);
        if (frame instanceof SkyFrame) {
            this.isCelestial = true;
            try {
                int astime2 = this.frameSet.getI("astime(2)");
                if (astime2 == 1) {
                    this.raIndex = 2;
                    this.decIndex = 1;
                } else {
                    this.raIndex = 1;
                    this.decIndex = 2;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        frame.annul();
    }

    public FrameSet getFrameSet() {
        return this.frameSet;
    }

    public String[] getDomains() {
        if (this.domains == null) {
            int icur = this.frameSet.getCurrent();
            int nframe = this.frameSet.getNframe();
            this.domains = new String[nframe];
            int i = 1;
            while (i <= nframe) {
                this.frameSet.setCurrent(i);
                this.domains[i - 1] = this.frameSet.getDomain();
                ++i;
            }
            this.frameSet.setCurrent(icur);
        }
        return this.domains;
    }

    public String getDomain() {
        return this.frameSet.getDomain();
    }

    public void setDomain(String domain) {
        String[] domains = this.getDomains();
        int i = 0;
        while (i < domains.length) {
            if (domains[i].equals(domain)) {
                this.setCurrent(i + 1);
            }
            ++i;
        }
    }

    public int getCurrent() {
        return this.frameSet.getCurrent();
    }

    public void setCurrent(int frame) {
        this.frameSet.setCurrent(frame);
        this.setCelestial();
    }

    public int getBase() {
        return this.frameSet.getBase();
    }

    public void setBase(int frame) {
        this.frameSet.setBase(frame);
    }

    public double getHeight() {
        return this.nypix;
    }

    public double getWidth() {
        return this.nxpix;
    }

    public boolean isWCS() {
        return this.frameSet != null;
    }

    public double getEquinox() {
        try {
            return this.frameSet.getD("Equinox");
        }
        catch (AstException e) {
            return -1.0;
        }
    }

    public void imageToWorldCoords(Point2D.Double p, boolean isDistance) {
        if (isDistance) {
            p.x = Math.abs(p.x * this.degPerPixel.x);
            p.y = Math.abs(p.y * this.degPerPixel.y);
        } else {
            double[] oldx = new double[1];
            double[] oldy = new double[1];
            oldx[0] = p.x;
            oldy[0] = p.y;
            double[][] newp = this.frameSet.tran2(1, oldx, oldy, true);
            double[] point = new double[]{newp[0][0], newp[1][0]};
            this.frameSet.norm(point);
            if (this.isCelestial) {
                if (this.raIndex == 1) {
                    p.x = point[0] * 57.29577951308232;
                    p.y = point[1] * 57.29577951308232;
                } else {
                    p.x = point[1] * 57.29577951308232;
                    p.y = point[0] * 57.29577951308232;
                }
            } else {
                p.x = point[0];
                p.y = point[1];
            }
        }
    }

    public void worldToImageCoords(Point2D.Double p, boolean isDistance) {
        if (isDistance) {
            p.x = Math.abs(p.x / this.degPerPixel.x);
            p.y = Math.abs(p.y / this.degPerPixel.y);
        } else {
            double[] oldx = new double[1];
            double[] oldy = new double[1];
            if (this.isCelestial) {
                if (this.raIndex == 1) {
                    oldx[0] = p.x * (Math.PI / 180);
                    oldy[0] = p.y * (Math.PI / 180);
                } else {
                    oldy[0] = p.x * (Math.PI / 180);
                    oldx[0] = p.y * (Math.PI / 180);
                }
            } else {
                oldx[0] = p.x;
                oldy[0] = p.y;
            }
            double[][] newp = this.frameSet.tran2(1, oldx, oldy, false);
            p.x = newp[0][0];
            p.y = newp[1][0];
        }
    }

    public Point2D.Double getWCSCenter() {
        Point2D.Double point = new Point2D.Double(0.5 * (double)this.nxpix, 0.5 * (double)this.nypix);
        this.imageToWorldCoords(point, false);
        return point;
    }

    public double getWidthInDeg() {
        double[] xin = new double[]{1.0, this.nxpix};
        double[] yin = new double[2];
        yin[0] = yin[1] = 0.5 * (double)this.nypix;
        double[][] xyout = this.frameSet.tran2(2, xin, yin, true);
        double[] point1 = new double[2];
        double[] point2 = new double[2];
        point1[0] = xyout[0][0];
        point1[1] = xyout[1][0];
        point2[0] = xyout[0][1];
        point2[1] = xyout[1][1];
        double dist = this.frameSet.distance(point1, point2);
        dist = dist == 0.0 || dist < 2.220446049250313E-16 ? this.degPerPixel.x * (double)this.nxpix : (dist *= 57.29577951308232);
        return dist;
    }

    public double getHeightInDeg() {
        double[] xin = new double[2];
        xin[0] = xin[1] = 0.5 * (double)this.nxpix;
        double[] yin = new double[]{1.0, this.nypix};
        double[][] xyout = this.frameSet.tran2(2, xin, yin, true);
        double[] point1 = new double[2];
        double[] point2 = new double[2];
        point1[0] = xyout[0][0];
        point1[1] = xyout[1][0];
        point2[0] = xyout[0][1];
        point2[1] = xyout[1][1];
        double dist = this.frameSet.distance(point1, point2);
        dist = dist == 0.0 || dist < 2.220446049250313E-16 ? this.degPerPixel.y * (double)this.nypix : (dist *= 57.29577951308232);
        return dist;
    }

    public Point2D.Double getImageCenter() {
        return new Point2D.Double(0.5 * (double)this.nxpix, 0.5 * (double)this.nypix);
    }

    protected void setSecPix() {
        double[] point1 = new double[2];
        double[] point2 = new double[2];
        double[] xin = new double[2];
        double[] yin = new double[2];
        double xcen = 0.5 * (double)this.nxpix;
        double ycen = 0.5 * (double)this.nypix;
        xin[0] = xcen - 0.5;
        xin[1] = xcen + 0.5;
        yin[0] = yin[1] = ycen;
        double[][] xyout = this.frameSet.tran2(2, xin, yin, true);
        point1[0] = xyout[0][0];
        point1[1] = xyout[1][0];
        point2[0] = xyout[0][1];
        point2[1] = xyout[1][1];
        double dist = this.frameSet.distance(point1, point2);
        double xDegPix = 0.0;
        if (dist != AstObject.AST__BAD) {
            xDegPix = dist * 57.29577951308232;
        }
        xin[0] = xin[1] = xcen;
        yin[0] = ycen - 0.5;
        yin[1] = ycen + 0.5;
        xyout = this.frameSet.tran2(2, xin, yin, true);
        point1[0] = xyout[0][0];
        point1[1] = xyout[1][0];
        point2[0] = xyout[0][1];
        point2[1] = xyout[1][1];
        dist = this.frameSet.distance(point1, point2);
        double yDegPix = 0.0;
        if (dist != AstObject.AST__BAD) {
            yDegPix = dist * 57.29577951308232;
        }
        this.degPerPixel = new Point2D.Double(xDegPix, yDegPix);
    }
}

