/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog;

import com.sun.media.jai.codec.ImageCodec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.filechooser.FileFilter;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.NavigatorFrame;
import jsky.navigator.NavigatorInternalFrame;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.DesktopUtil;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.LookAndFeelMenu;
import uk.ac.starlink.jaiutil.HDXCodec;
import uk.ac.starlink.sog.SOGMenuBar;
import uk.ac.starlink.sog.SOGNavigatorImageDisplay;
import uk.ac.starlink.sog.SOGNavigatorImageDisplayFrame;
import uk.ac.starlink.sog.SOGNavigatorImageDisplayInternalFrame;
import uk.ac.starlink.sog.SOGRemoteControl;
import uk.ac.starlink.util.gui.BasicFileChooser;
import uk.ac.starlink.util.gui.BasicFileFilter;

public class SOG
extends JFrame {
    private static final I18N _I18N = I18N.getInstance(class$jsky$app$jskycat$JSkyCat == null ? (class$jsky$app$jskycat$JSkyCat = SOG.class$("jsky.app.jskycat.JSkyCat")) : class$jsky$app$jskycat$JSkyCat);
    public static final String DEFAULT_URL = "http://archive.eso.org/skycat/skycat2.0.cfg";
    protected JFileChooser fileChooser;
    protected static JDesktopPane desktop;
    protected Component imageFrame;
    protected JMenuBar menuBar;
    private static SOG instance;
    private boolean doExit;
    static /* synthetic */ Class class$jsky$app$jskycat$JSkyCat;

    public SOG() {
        this(null, false, false, 0, false, false);
    }

    public SOG(String imageFileOrUrl, boolean internalFrames, boolean showNavigator) {
        this(imageFileOrUrl, internalFrames, showNavigator, 0, true, false);
    }

    public SOG(String imageFileOrUrl) {
        this(imageFileOrUrl, false, false, 0, true, false);
    }

    public SOG(String imageFileOrUrl, boolean internalFrames, boolean showNavigator, int portNum, boolean doExit, boolean showPhotom) {
        block4: {
            super("SOG::JSky");
            this.doExit = true;
            instance = this;
            this.doExit = doExit;
            SOGNavigatorImageDisplay.setPhotomEnabled(showPhotom);
            if (internalFrames || desktop != null) {
                this.makeInternalFrameLayout(showNavigator, imageFileOrUrl);
            } else {
                this.makeFrameLayout(showNavigator, imageFileOrUrl);
            }
            this.addWindowListener(new BasicWindowMonitor());
            if (portNum <= 0) break block4;
            try {
                SOGRemoteControl control = SOGRemoteControl.getInstance();
                control.setPortNumber(portNum);
                control.start();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public static SOG getInstance() {
        return instance;
    }

    public void setDoExit(boolean exit) {
        this.doExit = exit;
        ((SOGNavigatorImageDisplay)this.getImageDisplay()).setDoExit(this.doExit);
    }

    public static JDesktopPane getDesktop() {
        return desktop;
    }

    public static void setDesktop(JDesktopPane dt) {
        desktop = dt;
    }

    protected void makeInternalFrameLayout(boolean showNavigator, String imageFileOrUrl) {
        boolean ownDesktop = false;
        if (desktop == null) {
            this.setJMenuBar(this.makeMenuBar());
            desktop = new JDesktopPane();
            desktop.setBorder(BorderFactory.createEtchedBorder());
            DialogUtil.setDesktop(desktop);
            ownDesktop = true;
            desktop.putClientProperty("JDesktopPane.dragMode", "outline");
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int w = screen.width - 10;
            int h = screen.height - 10;
            Preferences.manageSize(desktop, new Dimension(w, h), this.getClass().getName() + ".size");
            Preferences.manageLocation(this, 0, 0);
            this.setDesktopBackground();
            this.setContentPane(desktop);
        }
        NavigatorInternalFrame navigatorFrame = null;
        SOGNavigatorImageDisplayInternalFrame imageFrame = null;
        if (imageFileOrUrl != null || !showNavigator) {
            imageFrame = this.makeNavigatorImageDisplayInternalFrame(desktop, imageFileOrUrl);
            this.imageFrame = imageFrame;
            desktop.add((Component)imageFrame, JLayeredPane.DEFAULT_LAYER);
            desktop.moveToFront(imageFrame);
            imageFrame.setVisible(true);
            this.menuBar = imageFrame.getJMenuBar();
        }
        if (showNavigator) {
            if (imageFrame != null) {
                DivaMainImageDisplay imageDisplay = imageFrame.getImageDisplayControl().getImageDisplay();
                navigatorFrame = this.makeNavigatorInternalFrame(desktop, imageDisplay);
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int x = Math.min(screen.width - imageFrame.getWidth(), navigatorFrame.getWidth());
                imageFrame.setLocation(x, 0);
                imageFrame.setNavigator(navigatorFrame.getNavigator());
            } else {
                navigatorFrame = this.makeNavigatorInternalFrame(desktop, null);
            }
            desktop.add((Component)navigatorFrame, JLayeredPane.DEFAULT_LAYER);
            desktop.moveToFront(navigatorFrame);
            navigatorFrame.setLocation(0, 0);
            navigatorFrame.setVisible(true);
        }
        if (ownDesktop) {
            LookAndFeelMenu.addWindow(this);
            this.pack();
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    SOG.this.exit();
                }
            });
            this.setVisible(true);
        }
        this.setTitle(this.getAppName() + " - version " + this.getAppVersion());
    }

    protected void makeFrameLayout(boolean showNavigator, String imageFileOrUrl) {
        NavigatorFrame navigatorFrame = null;
        SOGNavigatorImageDisplayFrame imageFrame = null;
        if (imageFileOrUrl != null || !showNavigator) {
            imageFrame = this.makeNavigatorImageDisplayFrame(imageFileOrUrl);
            this.imageFrame = imageFrame;
            this.menuBar = imageFrame.getJMenuBar();
        }
        if (showNavigator) {
            if (imageFrame != null) {
                DivaMainImageDisplay imageDisplay = imageFrame.getImageDisplayControl().getImageDisplay();
                navigatorFrame = this.makeNavigatorFrame(imageDisplay);
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int x = Math.min(screen.width - imageFrame.getWidth(), navigatorFrame.getWidth());
                imageFrame.setLocation(x, 0);
                imageFrame.setNavigator(navigatorFrame.getNavigator());
            } else {
                navigatorFrame = this.makeNavigatorFrame(null);
            }
            navigatorFrame.setLocation(0, 0);
            navigatorFrame.setVisible(true);
        }
    }

    protected JMenuBar makeMenuBar() {
        return new SOGMenuBar(this);
    }

    protected SOGNavigatorImageDisplayInternalFrame makeNavigatorImageDisplayInternalFrame(JDesktopPane desktop, String imageFileOrUrl) {
        SOGNavigatorImageDisplayInternalFrame f = new SOGNavigatorImageDisplayInternalFrame(desktop, imageFileOrUrl);
        DivaMainImageDisplay d = f.getImageDisplayControl().getImageDisplay();
        if (d instanceof SOGNavigatorImageDisplay) {
            ((SOGNavigatorImageDisplay)d).setDoExit(this.doExit);
        }
        d.setTitle(this.getAppName());
        return f;
    }

    protected String getAppName() {
        return "SOG::JSky";
    }

    protected String getAppVersion() {
        return "jsky-2.0".substring(5);
    }

    protected SOGNavigatorImageDisplayFrame makeNavigatorImageDisplayFrame(String imageFileOrUrl) {
        SOGNavigatorImageDisplayFrame f = new SOGNavigatorImageDisplayFrame(imageFileOrUrl);
        DivaMainImageDisplay d = f.getImageDisplayControl().getImageDisplay();
        if (d instanceof SOGNavigatorImageDisplay) {
            ((SOGNavigatorImageDisplay)d).setDoExit(this.doExit);
        }
        d.setTitle(this.getAppName() + " - version " + this.getAppVersion());
        f.setVisible(true);
        return f;
    }

    protected NavigatorInternalFrame makeNavigatorInternalFrame(JDesktopPane desktop, MainImageDisplay imageDisplay) {
        NavigatorInternalFrame f = new NavigatorInternalFrame(desktop, imageDisplay);
        f.setVisible(true);
        return f;
    }

    protected NavigatorFrame makeNavigatorFrame(MainImageDisplay imageDisplay) {
        return new NavigatorFrame(imageDisplay);
    }

    protected void setDesktopBackground() {
        new DesktopUtil(desktop, "stars.gif");
    }

    public JFileChooser makeFileChooser() {
        BasicFileChooser fileChooser = new BasicFileChooser(false);
        BasicFileFilter configFileFilter = new BasicFileFilter(new String[]{"cfg"}, _I18N.getString("catalogConfigFilesSkycat"));
        fileChooser.addChoosableFileFilter((FileFilter)configFileFilter);
        BasicFileFilter skycatLocalCatalogFilter = new BasicFileFilter(new String[]{"table", "tbl", "cat"}, _I18N.getString("localCatalogFilesSkycat"));
        fileChooser.addChoosableFileFilter((FileFilter)skycatLocalCatalogFilter);
        BasicFileFilter fitsFilter = new BasicFileFilter(new String[]{"fit", "fits", "fts"}, _I18N.getString("fitsFileWithTableExt"));
        fileChooser.addChoosableFileFilter((FileFilter)fitsFilter);
        fileChooser.setFileFilter((FileFilter)fitsFilter);
        return fileChooser;
    }

    public void open() {
        int option;
        if (this.fileChooser == null) {
            this.fileChooser = this.makeFileChooser();
        }
        if ((option = this.fileChooser.showOpenDialog(this)) == 0 && this.fileChooser.getSelectedFile() != null) {
            this.open(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void open(String fileOrUrl) {
        if (desktop != null) {
            if (fileOrUrl.endsWith(".fits") || fileOrUrl.endsWith(".fts")) {
                SOGNavigatorImageDisplayInternalFrame frame = new SOGNavigatorImageDisplayInternalFrame(desktop);
                desktop.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
                desktop.moveToFront(frame);
                frame.setVisible(true);
                frame.getImageDisplayControl().getImageDisplay().setFilename(fileOrUrl);
            } else {
                NavigatorInternalFrame frame = new NavigatorInternalFrame(desktop);
                frame.getNavigator().open(fileOrUrl);
                desktop.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
                desktop.moveToFront(frame);
                frame.setVisible(true);
            }
        }
    }

    public void exit() {
        if (this.doExit) {
            System.exit(0);
        }
    }

    public Component getImageFrame() {
        return this.imageFrame;
    }

    public MainImageDisplay getImageDisplay() {
        if (this.imageFrame instanceof SOGNavigatorImageDisplayFrame) {
            return ((SOGNavigatorImageDisplayFrame)this.imageFrame).getImageDisplayControl().getImageDisplay();
        }
        if (this.imageFrame instanceof SOGNavigatorImageDisplayInternalFrame) {
            return ((SOGNavigatorImageDisplayInternalFrame)this.imageFrame).getImageDisplayControl().getImageDisplay();
        }
        return null;
    }

    public void setImageFrameVisible(boolean visible) {
        block4: {
            block5: {
                if (this.imageFrame == null) break block4;
                this.imageFrame.setVisible(visible);
                if (!(this.imageFrame instanceof JFrame)) break block5;
                if (!visible) break block4;
                ((JFrame)this.imageFrame).setState(0);
                break block4;
            }
            if (!(this.imageFrame instanceof JInternalFrame) || !visible) break block4;
            JInternalFrame f = (JInternalFrame)this.imageFrame;
            try {
                f.setIcon(false);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            try {
                f.setClosed(false);
            }
            catch (PropertyVetoException e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) {
        String imageFileOrUrl = null;
        boolean internalFrames = false;
        boolean showNavigator = false;
        boolean showPhotom = false;
        int portNum = 0;
        boolean ok = true;
        int i = 0;
        while (i < args.length) {
            block7: {
                block8: {
                    String opt;
                    block11: {
                        block10: {
                            block9: {
                                if (args[i].charAt(0) != '-') break block8;
                                opt = args[i];
                                if (!opt.equals("-internalframes")) break block9;
                                internalFrames = true;
                                break block7;
                            }
                            if (!opt.equals("-nointernalframes")) break block10;
                            internalFrames = false;
                            break block7;
                        }
                        if (!opt.equals("-shownavigator")) break block11;
                        showNavigator = true;
                        break block7;
                    }
                    if (opt.equals("-showphotom")) {
                        showPhotom = true;
                        break block7;
                    } else if (opt.equals("-port")) {
                        String arg = args[++i];
                        portNum = Integer.parseInt(arg);
                        break block7;
                    } else {
                        System.out.println(_I18N.getString("unknownOption") + ": " + opt);
                        ok = false;
                        break;
                    }
                }
                if (imageFileOrUrl != null) {
                    System.out.println(_I18N.getString("specifyOneImageOrURL") + ": " + imageFileOrUrl);
                    ok = false;
                    break;
                }
                imageFileOrUrl = args[i];
            }
            ++i;
        }
        if (!ok) {
            System.out.println("Usage: java [-Djsky.catalog.skycat.config=$SKYCAT_CONFIG] SOG [-[no]internalframes] [-shownavigator] [-port portNum] [-showphotom] [imageFileOrUrl]");
            System.exit(1);
        }
        new SOG(imageFileOrUrl, internalFrames, showNavigator, portNum, true, showPhotom);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ImageCodec.registerCodec((ImageCodec)new HDXCodec());
        instance = null;
    }
}

