/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import uk.ac.starlink.jaiutil.HDXImage;
import uk.ac.starlink.sog.SOGNavigatorImageDisplay;

public class SOGTransferHandler
extends TransferHandler {
    public static final DataFlavor[] flavors = new DataFlavor[]{new DataFlavor("application/xml;class=java.io.InputStream", "NDX stream"), new DataFlavor("application/x-java-serialized-object;class=java.net.URL", "URL")};
    protected SOGNavigatorImageDisplay imageDisplay = null;

    public SOGTransferHandler(SOGNavigatorImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        int i = 0;
        int n = flavor.length;
        while (i < n) {
            int j = 0;
            int m = flavors.length;
            while (j < m) {
                if (flavor[i].equals(flavors[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    public boolean importData(JComponent comp, Transferable t) {
        DataFlavor[] importFlavors = t.getTransferDataFlavors();
        int j = 0;
        while (j < importFlavors.length) {
            if (flavors[0].match(importFlavors[j])) {
                return this.importNDXStream(comp, t);
            }
            if (flavors[1].match(importFlavors[j])) {
                return this.importURL(comp, t);
            }
            ++j;
        }
        return false;
    }

    protected boolean importNDXStream(JComponent comp, Transferable t) {
        boolean added = false;
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)t.getTransferData(flavors[0]);
            StreamSource streamSource = new StreamSource(inputStream);
            HDXImage hdxImage = new HDXImage((Source)streamSource);
            this.imageDisplay.setHDXImage(hdxImage);
            added = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            inputStream.close();
        }
        catch (Exception e) {}
        return added;
    }

    protected boolean importFITSStream(JComponent comp, Transferable t) {
        System.out.println("No Support for FITS streams");
        return false;
    }

    protected boolean importURL(JComponent comp, Transferable t) {
        boolean added = false;
        try {
            URL url = (URL)t.getTransferData(flavors[1]);
            this.imageDisplay.setFilename(url.toString());
            added = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return added;
    }
}

