/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import org.w3c.dom.Element;
import uk.ac.starlink.sog.photom.BasePhotom;
import uk.ac.starlink.util.PrimitiveXMLEncodeDecode;

public class AnnulusPhotom
extends BasePhotom {
    private Double innerscale = new Double(1.5);
    private Double outerscale = new Double(2.5);

    public double getInnerscale() {
        return this.innerscale;
    }

    public void setInnerscale(double value) {
        if (Double.compare(this.innerscale, value) != 0) {
            this.innerscale = new Double(value);
            this.fireChanged();
        }
    }

    public double getOuterscale() {
        return this.outerscale;
    }

    public void setOuterscale(double value) {
        if (Double.compare(this.outerscale, value) != 0) {
            this.outerscale = new Double(value);
            this.fireChanged();
        }
    }

    public boolean sameValue(AnnulusPhotom comparison) {
        if (Double.compare(this.getOuterscale(), comparison.getOuterscale()) != 0) {
            return false;
        }
        if (Double.compare(this.getInnerscale(), comparison.getInnerscale()) != 0) {
            return false;
        }
        return super.sameValue(comparison);
    }

    public Object clone() {
        AnnulusPhotom clone = (AnnulusPhotom)super.clone();
        clone.setOuterscale(this.getOuterscale());
        clone.setInnerscale(this.getInnerscale());
        return clone;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(",outerscale[" + this.outerscale + "],");
        buffer.append("innerscale[" + this.innerscale + "],");
        return buffer.toString();
    }

    public static int getNumberValues() {
        return 2 + BasePhotom.getNumberValues();
    }

    public int getSpecificNumberValues() {
        return AnnulusPhotom.getNumberValues();
    }

    public Object getValue(int index) {
        int base = BasePhotom.getNumberValues();
        if (index < base) {
            return super.getValue(index);
        }
        if (index == base) {
            return this.innerscale;
        }
        if (index == base + 1) {
            return this.outerscale;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public static String getDescription(int index) {
        int base = BasePhotom.getNumberValues();
        if (index < base) {
            return BasePhotom.getDescription(index);
        }
        if (index == base) {
            return "innerscale";
        }
        if (index == base + 1) {
            return "outerscale";
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public String getSpecificDescription(int index) {
        return AnnulusPhotom.getDescription(index);
    }

    public String getTagName() {
        return "annulus-" + super.getTagName();
    }

    public void encode(Element rootElement) {
        PrimitiveXMLEncodeDecode.addChildElement((Element)rootElement, (String)"outerscale", (double)this.getOuterscale());
        PrimitiveXMLEncodeDecode.addChildElement((Element)rootElement, (String)"innerscale", (double)this.getInnerscale());
        super.encode(rootElement);
    }

    public void setFromString(String name, String value) {
        if (name.equals("outerscale")) {
            this.setOuterscale(PrimitiveXMLEncodeDecode.doubleFromString((String)value));
            return;
        }
        if (name.equals("innerscale")) {
            this.setInnerscale(PrimitiveXMLEncodeDecode.doubleFromString((String)value));
            return;
        }
        super.setFromString(name, value);
    }
}

