/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.sog.photom.AnnulusPhotom;
import uk.ac.starlink.sog.photom.PhotomList;
import uk.ac.starlink.sog.photom.PhotometryGlobals;

public class PhotomEncoderAndDecoder {
    private PhotomEncoderAndDecoder() {
    }

    public static void save(PhotomList list, File file) throws FileNotFoundException {
        PrintStream p = new PrintStream(new FileOutputStream(file));
        int i = 0;
        while (i < list.size()) {
            AnnulusPhotom bp = (AnnulusPhotom)list.get(i);
            p.print(bp.getIdent() + " ");
            p.print(bp.getXcoord() + " ");
            p.print(bp.getYcoord() + " ");
            p.print(bp.getMagnitude() + " ");
            p.print(bp.getMagnitudeError() + " ");
            p.print(bp.getSky() + " ");
            p.print(bp.getSignal() + " ");
            p.print(bp.getStatus() + " ");
            double sma = bp.getSemimajor();
            double smi = bp.getSemiminor();
            p.print(sma + " ");
            p.print(Math.sqrt(1.0 - smi * smi / (sma * sma)) + " ");
            p.print(bp.getAngle());
            p.print(" annulus circle");
            p.println();
            p.print("#ANN " + bp.getIdent() + " ");
            p.print(bp.getInnerscale() + " " + bp.getOuterscale());
            p.println();
            ++i;
        }
        p.close();
    }

    public static void read(File file, PhotomList list) throws FileNotFoundException, IOException {
        System.out.println("reading file: " + file);
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        LinkedHashMap hashMap = new LinkedHashMap();
        AnnulusPhotom ap = null;
        while ((line = in.readLine()) != null) {
            String[] words;
            if (line.length() == 0 || (words = line.split("[\\ ]+"))[0].equals("#")) continue;
            if (words[0].equals("#ANN")) {
                ap = PhotomEncoderAndDecoder.getPhotom(hashMap, words[1]);
                ap.setInnerscale(Double.parseDouble(words[2]));
                ap.setOuterscale(Double.parseDouble(words[3]));
                continue;
            }
            if (words[0].equals("#SKY")) continue;
            ap = PhotomEncoderAndDecoder.getPhotom(hashMap, words[0]);
            ap.setXcoord(Double.parseDouble(words[1]));
            ap.setYcoord(Double.parseDouble(words[2]));
            ap.setMagnitude(Double.parseDouble(words[3]));
            ap.setMagnitudeError(Double.parseDouble(words[4]));
            ap.setSky(Double.parseDouble(words[5]));
            ap.setSignal(Double.parseDouble(words[6]));
            ap.setStatus(words[7]);
            double semimajor = Double.parseDouble(words[8]);
            double eccen = Double.parseDouble(words[9]);
            ap.setSemimajor(semimajor);
            ap.setSemiminor(semimajor * Math.sqrt(1.0 - eccen * eccen));
            ap.setAngle(Double.parseDouble(words[10]));
        }
        list.add(hashMap.values());
        in.close();
    }

    public static AnnulusPhotom getPhotom(Map map, String ident) {
        AnnulusPhotom ap = (AnnulusPhotom)map.get(ident);
        if (ap == null) {
            ap = new AnnulusPhotom();
            ap.setIdent(Integer.parseInt(ident));
            map.put(ident, ap);
        }
        return ap;
    }

    public static String toApplicationString(PhotometryGlobals globals) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("skymag=" + globals.getZeroPoint());
        buffer.append(" centro=" + globals.getCentroid());
        return buffer.toString();
    }
}

