/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import org.w3c.dom.Element;
import uk.ac.starlink.sog.photom.PhotomEncoderAndDecoder;
import uk.ac.starlink.util.PrimitiveXMLEncodeDecode;

public class PhotometryGlobals
extends PrimitiveXMLEncodeDecode
implements Cloneable {
    private double zeroPoint;
    private boolean centroid;

    public PhotometryGlobals() {
        this.reset();
    }

    public void reset() {
        this.zeroPoint = 50.0;
        this.centroid = true;
        this.fireChanged();
    }

    public double getZeroPoint() {
        return this.zeroPoint;
    }

    public void setZeroPoint(double value) {
        if (Double.compare(this.zeroPoint, value) != 0) {
            this.zeroPoint = value;
            this.fireChanged();
        }
    }

    public boolean getCentroid() {
        return this.centroid;
    }

    public void setCentroid(boolean value) {
        if (this.centroid != value) {
            this.centroid = value;
            this.fireChanged();
        }
    }

    public boolean sameValue(PhotometryGlobals comparison) {
        if (Double.compare(this.zeroPoint, comparison.getZeroPoint()) != 0) {
            return false;
        }
        return this.centroid == comparison.getCentroid();
    }

    public Object clone() {
        try {
            PhotometryGlobals clone = (PhotometryGlobals)super.clone();
            clone.setZeroPoint(this.zeroPoint);
            clone.setCentroid(this.centroid);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone failed: " + e.getMessage());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("zeropoint[" + this.zeroPoint + "]");
        buffer.append(",centroid[" + this.centroid + "]");
        return buffer.toString();
    }

    public String toApplicationString() {
        return PhotomEncoderAndDecoder.toApplicationString(this);
    }

    public String getTagName() {
        return "photometry-globals";
    }

    public void encode(Element rootElement) {
        PrimitiveXMLEncodeDecode.addChildElement((Element)rootElement, (String)"zeropoint", (double)this.zeroPoint);
        PrimitiveXMLEncodeDecode.addChildElement((Element)rootElement, (String)"centroid", (boolean)this.centroid);
    }

    public void setFromString(String name, String value) {
        if (name.equals("zeropoint")) {
            this.setZeroPoint(PrimitiveXMLEncodeDecode.doubleFromString((String)value));
            return;
        }
        if (name.equals("centroid")) {
            this.setCentroid(PrimitiveXMLEncodeDecode.booleanFromString((String)value));
            return;
        }
    }
}

