/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.CombineArrayImpl;
import uk.ac.starlink.array.Combiner;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.NdxConsumer;
import uk.ac.starlink.ndtools.NewNdxParameter;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;

class Combine
implements Task {
    private String description;
    private Combiner icombi;
    private Combiner vcombi;
    private ExistingNdxParameter ndx1par;
    private ExistingNdxParameter ndx2par;
    private NewNdxParameter ndx3par;

    public Parameter[] getParameters() {
        return new Parameter[]{this.ndx1par, this.ndx2par, this.ndx3par};
    }

    public Combine(String description, Combiner icombi, Combiner vcombi) {
        this.description = description;
        this.icombi = icombi;
        this.vcombi = vcombi;
        this.ndx1par = new ExistingNdxParameter("ndx1");
        this.ndx1par.setPrompt("First input NDX");
        this.ndx1par.setPosition(1);
        this.ndx2par = new ExistingNdxParameter("ndx2");
        this.ndx2par.setPrompt("Second input NDX");
        this.ndx2par.setPosition(2);
        this.ndx3par = new NewNdxParameter("ndxout");
        this.ndx3par.setPrompt("Output NDX");
        this.ndx3par.setPosition(3);
    }

    public Executable createExecutable(Environment env) throws TaskException {
        return new CombineExecutable(this.ndx1par.ndxValue(env), this.ndx2par.ndxValue(env), this.ndx3par.ndxConsumerValue(env));
    }

    private class CombineExecutable
    implements Executable {
        final Ndx ndx1;
        final Ndx ndx2;
        final NdxConsumer ndxOut;

        public CombineExecutable(Ndx ndx1, Ndx ndx2, NdxConsumer ndxOut) {
            this.ndx1 = ndx1;
            this.ndx2 = ndx2;
            this.ndxOut = ndxOut;
        }

        public void execute() throws ExecutionException, IOException {
            BridgeNDArray var3;
            OrderedNDShape shape2;
            NDArray im1 = this.ndx1.getImage();
            NDArray im2 = this.ndx2.getImage();
            OrderedNDShape shape1 = im1.getShape();
            NDShape shape = shape1.intersection(shape2 = im2.getShape());
            if (shape == null) {
                throw new ExecutionException("No overlap between shapes " + shape1 + " and " + shape2);
            }
            Order order = shape1.getOrder();
            Type type = im1.getType();
            BadHandler bh = BadHandler.getHandler(type, type.defaultBadValue());
            Requirements req = new Requirements(AccessMode.READ).setType(type).setWindow(shape).setOrder(order);
            boolean hasVar = this.ndx1.hasVariance() && this.ndx2.hasVariance();
            im1 = NDArrays.toRequiredArray(im1, req);
            im2 = NDArrays.toRequiredArray(im2, req);
            BridgeNDArray im3 = new BridgeNDArray(new CombineArrayImpl(im1, im2, Combine.this.icombi, shape, type, bh));
            if (this.ndx1.hasVariance() && this.ndx2.hasVariance()) {
                NDArray var1 = NDArrays.toRequiredArray(this.ndx1.getVariance(), req);
                NDArray var2 = NDArrays.toRequiredArray(this.ndx2.getVariance(), req);
                var3 = new BridgeNDArray(new CombineArrayImpl(var1, var2, Combine.this.vcombi, shape, type, bh));
            } else {
                var3 = null;
            }
            DefaultMutableNdx ndx3 = new DefaultMutableNdx(im3);
            ndx3.setVariance(var3);
            ndx3.setTitle(Combine.this.description + " of " + (this.ndx1.hasTitle() ? this.ndx1.getTitle() : "<unnamed>") + " and " + (this.ndx2.hasTitle() ? this.ndx2.getTitle() : "<unnamed>"));
            this.ndxOut.consume(ndx3);
        }
    }
}

