/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;

class Diff
implements Task {
    private ExistingNdxParameter ndx1par = new ExistingNdxParameter("ndx1");
    private ExistingNdxParameter ndx2par;
    private IntegerParameter ndiffpar;

    public Diff() {
        this.ndx1par.setPrompt("First NDX");
        this.ndx1par.setPosition(1);
        this.ndx2par = new ExistingNdxParameter("ndx2");
        this.ndx2par.setPrompt("Second NDX");
        this.ndx2par.setPosition(2);
        this.ndiffpar = new IntegerParameter("ndiffs");
        this.ndiffpar.setPrompt("Number of pixel diffs displayed");
        this.ndiffpar.setPosition(3);
        this.ndiffpar.setDefault("4");
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.ndx1par, this.ndx2par, this.ndiffpar};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        return new Differ(this.ndx1par.ndxValue(env), this.ndx2par.ndxValue(env), this.ndiffpar.intValue(env), this.ndx1par.stringValue(env), this.ndx2par.stringValue(env), env.getOutputStream());
    }

    private List compareArrays(NDArray nda1, NDArray nda2, int ndiffs) throws IOException {
        ArrayList<String> diffs = new ArrayList<String>();
        boolean done = false;
        Type type1 = nda1.getType();
        Type type2 = nda2.getType();
        OrderedNDShape oshape1 = nda1.getShape();
        OrderedNDShape oshape2 = nda2.getShape();
        BadHandler bh1 = nda1.getBadHandler();
        BadHandler bh2 = nda2.getBadHandler();
        Type type = null;
        if (!type1.equals(type2)) {
            diffs.add("Types: " + type1 + " != " + type2);
            done = true;
        } else {
            type = type1;
        }
        OrderedNDShape oshape = null;
        if (!oshape1.equals(oshape2)) {
            diffs.add("Shapes: " + oshape1 + " != " + oshape2);
            done = true;
        } else {
            oshape = oshape1;
        }
        if (!bh1.equals(bh2)) {
            diffs.add("BadHandlers: " + bh1 + " != " + bh2);
        }
        if (!done) {
            long npix = oshape.getNumPixels();
            ChunkStepper cit = new ChunkStepper(npix);
            int size = cit.getSize();
            Object buf1 = type.newArray(size);
            Object buf2 = type.newArray(size);
            ArrayAccess acc1 = nda1.getAccess();
            ArrayAccess acc2 = nda2.getAccess();
            int npixdiff = 0;
            double maxdiff = 0.0;
            while (cit.hasNext()) {
                boolean same;
                long base = cit.getBase();
                size = cit.getSize();
                acc1.read(buf1, 0, size);
                acc2.read(buf2, 0, size);
                boolean bl = same = type == Type.BYTE && Arrays.equals((byte[])buf1, (byte[])buf2) || type == Type.SHORT && Arrays.equals((short[])buf1, (short[])buf2) || type == Type.INT && Arrays.equals((int[])buf1, (int[])buf2) || type == Type.FLOAT && Arrays.equals((float[])buf1, (float[])buf2) || type == Type.DOUBLE && Arrays.equals((double[])buf1, (double[])buf2);
                if (!same) {
                    int i = 0;
                    while (i < size) {
                        Number num1 = bh1.makeNumber(buf1, i);
                        Number num2 = bh2.makeNumber(buf2, i);
                        if (!(num1 == null && num2 == null || num1 != null && num1.equals(num2))) {
                            double diff;
                            if (npixdiff++ <= ndiffs) {
                                long[] pos = oshape.offsetToPosition(base + (long)i);
                                diffs.add("    " + NDShape.toString(pos) + ": " + num1 + " != " + num2);
                            }
                            if (num1 != null && num2 != null && (diff = Math.abs(num1.doubleValue() - num2.doubleValue())) > maxdiff) {
                                maxdiff = diff;
                            }
                        }
                        ++i;
                    }
                }
                cit.next();
            }
            acc1.close();
            acc2.close();
            if (npixdiff > ndiffs) {
                diffs.add("      ...");
            }
            if (npixdiff > 0) {
                diffs.add("  " + npixdiff + "/" + npix + " pixels differ");
                diffs.add("  Maximum discrepancy = " + maxdiff);
            }
        }
        return diffs;
    }

    private class Differ
    implements Executable {
        final Ndx ndx1;
        final Ndx ndx2;
        final int ndiffs;
        final String name1;
        final String name2;
        final PrintStream pstrm;

        public Differ(Ndx ndx1, Ndx ndx2, int ndiffs, String ndx1name, String ndx2name, PrintStream pstrm) {
            this.ndx1 = ndx1;
            this.ndx2 = ndx2;
            this.ndiffs = ndiffs;
            this.name1 = ndx1name;
            this.name2 = ndx2name;
            this.pstrm = pstrm;
        }

        public void execute() throws IOException {
            NDArray im2;
            NDArray im1;
            List idiffs;
            int badbits2;
            int badbits1;
            String title2;
            String title1 = this.ndx1.hasTitle() ? this.ndx1.getTitle() : null;
            String string = title2 = this.ndx2.hasTitle() ? this.ndx2.getTitle() : null;
            if (title1 != null && !title1.equals(title2) || title1 == null && title2 != null) {
                this.pstrm.println("Title: \"" + title1 + "\" != \"" + title2 + "\"");
            }
            if ((badbits1 = this.ndx1.getBadBits()) != (badbits2 = this.ndx2.getBadBits())) {
                this.pstrm.println("Badbits: " + badbits1 + " != " + badbits2);
            }
            if ((idiffs = Diff.this.compareArrays(im1 = this.ndx1.getImage(), im2 = this.ndx2.getImage(), this.ndiffs)).size() > 0) {
                this.pstrm.println("Image:");
                Iterator it = idiffs.iterator();
                while (it.hasNext()) {
                    this.pstrm.println("    " + (String)it.next());
                }
            }
            im1.close();
            im2.close();
            if (this.ndx1.hasVariance() && !this.ndx2.hasVariance()) {
                this.pstrm.println("Variance: present in " + this.name1 + " but not " + this.name2);
            } else if (!this.ndx1.hasVariance() && this.ndx2.hasVariance()) {
                this.pstrm.println("Variance: present in " + this.name2 + " but not " + this.name1);
            } else if (this.ndx1.hasVariance() && this.ndx2.hasVariance()) {
                NDArray var2;
                NDArray var1 = this.ndx1.getVariance();
                List vdiffs = Diff.this.compareArrays(var1, var2 = this.ndx2.getVariance(), this.ndiffs);
                if (vdiffs.size() > 0) {
                    this.pstrm.println("Variance:");
                    Iterator it = vdiffs.iterator();
                    while (it.hasNext()) {
                        this.pstrm.println("    " + (String)it.next());
                    }
                }
                var1.close();
                var2.close();
            }
        }
    }
}

