/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import java.io.PrintStream;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.StatsValues;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;

class Stats
implements Task {
    private ExistingNdxParameter inpar = new ExistingNdxParameter("in");

    public Stats() {
        this.inpar.setPrompt("Input NDX");
        this.inpar.setPosition(1);
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        return new Statter(this.inpar.ndxValue(env), env.getOutputStream());
    }

    private class Statter
    implements Executable {
        final Ndx ndx;
        final PrintStream pstrm;

        Statter(Ndx ndx, PrintStream pstrm) {
            this.ndx = ndx;
            this.pstrm = pstrm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute() throws IOException, ExecutionException {
            StatsValues answers;
            long npix;
            String title;
            block6: {
                NDArray nda = null;
                try {
                    title = this.ndx.hasTitle() ? this.ndx.getTitle() : null;
                    nda = Ndxs.getMaskedImage(this.ndx);
                    npix = nda.getShape().getNumPixels();
                    answers = new StatsValues(nda);
                    Object var7_5 = null;
                    if (nda == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    if (nda != null) {
                        nda.close();
                    }
                    throw throwable;
                }
                nda.close();
            }
            float sum = (float)answers.total;
            float mean = (float)answers.mean;
            float stdev = (float)Math.sqrt(answers.variance);
            Number minval = answers.minValue;
            Number maxval = answers.maxValue;
            String minpos = NDShape.toString(answers.minPosition);
            String maxpos = NDShape.toString(answers.maxPosition);
            long ngood = answers.numGood;
            long nbad = npix - ngood;
            float pcgood = (float)(100.0 * (double)ngood / (double)npix);
            float pcbad = (float)(100.0 * (double)nbad / (double)npix);
            this.pstrm.println("Title:   " + title);
            if (ngood > 0L) {
                this.pstrm.println("   Pixel sum              : " + sum);
                this.pstrm.println("   Pixel mean             : " + mean);
                this.pstrm.println("   Standard deviation     : " + stdev);
                this.pstrm.println("   Minimum pixel value    : " + minval);
                this.pstrm.println("      At pixel            : " + minpos);
                this.pstrm.println("   Maximum pixel value    : " + maxval);
                this.pstrm.println("      At pixel            : " + maxpos);
                this.pstrm.println("   Total number of pixels : " + npix);
                this.pstrm.println("   Number of pixels used  : " + ngood + " (" + pcgood + "%)");
                if (nbad > 0L) {
                    this.pstrm.println("   No. of pixels excluded : " + nbad + " (" + pcbad + "%)");
                }
            } else {
                this.pstrm.println("No good pixels");
            }
            this.pstrm.println();
        }
    }
}

