/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import uk.ac.starlink.astrogrid.AcrBranch;
import uk.ac.starlink.astrogrid.AcrConnector;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;

class AcrConnection
extends Connection {
    private final AcrBranch root_;
    private final XmlRpcClient client_;
    public static String ACR_FILE = ".astrogrid-desktop";
    public static int HTTP_CHUNK = 0x100000;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.astrogrid");

    public AcrConnection(AcrConnector connector) throws IOException {
        super((Connector)connector, new HashMap());
        URL url;
        try {
            url = AcrConnection.getServerURL();
        }
        catch (FileNotFoundException e) {
            String msg = "The ACR is does not appear to be running (no ~/" + ACR_FILE + ")\n" + "To enable MySpace access, start the Astrogrid " + "Desktop\n" + "(http://software.astrogrid.org/jnlp/" + "astrogrid-desktop/astrogrid-desktop.jnlp)";
            throw (IOException)new IOException(msg).initCause(e);
        }
        this.client_ = new XmlRpcClient(url);
        logger_.info("xml-rpc server for ACR: \"" + url + "\"");
        String homeUri = (String)this.execute("astrogrid.myspace.getHome", null);
        this.root_ = new AcrBranch(this, homeUri, homeUri, null);
    }

    public boolean isConnected() {
        return true;
    }

    public Branch getRoot() {
        return this.root_;
    }

    public void logOut() {
    }

    public Object execute(String cmd, Object[] args) throws IOException {
        Vector argv = args == null ? new Vector() : new Vector<Object>(Arrays.asList(args));
        logger_.info("xmlrpc: " + cmd + argv);
        try {
            Object result = this.client_.execute(cmd, argv);
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof Throwable) {
                Throwable err = (Throwable)result;
                String msg = err.getMessage();
                if (msg == null) {
                    msg = "ACR error";
                }
                throw (IOException)new IOException(msg).initCause(err);
            }
            if (result instanceof Collection) {
                return ((Collection)result).toArray();
            }
            return result;
        }
        catch (XmlRpcException e) {
            throw (IOException)new IOException("Error communicating with ACR").initCause(e);
        }
    }

    public OutputStream getOutputStream(String outUri) throws IOException {
        return this.getTempFileOutputStream(outUri);
    }

    private OutputStream getHttpOutputStream(String outUri) throws IOException {
        String outLoc = (String)this.execute("astrogrid.myspace.getWriteContentURL", new Object[]{outUri});
        URL url = new URL(outLoc);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setAllowUserInteraction(false);
        httpConn.setDoInput(false);
        httpConn.setDoOutput(true);
        httpConn.setUseCaches(false);
        httpConn.setRequestMethod("PUT");
        try {
            httpConn.getClass().getMethod("setChunkedStreamingMode", Integer.TYPE).invoke((Object)httpConn, new Integer(HTTP_CHUNK));
            logger_.config("Streaming with chunk size " + HTTP_CHUNK + "to remote URL " + url);
        }
        catch (Throwable err) {
            logger_.warning("Can't stream to output URL (requires J2SE1.5)");
        }
        httpConn.connect();
        return new FilterOutputStream(httpConn.getOutputStream()){

            public void close() throws IOException {
                this.flush();
                super.close();
            }
        };
    }

    private OutputStream getTempFileOutputStream(final String outUri) throws IOException {
        final File file = File.createTempFile("acr-temp", ".dat");
        file.deleteOnExit();
        final String fileURL = file.toURL().toString();
        FileOutputStream ostrm = new FileOutputStream(file){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                super.close();
                try {
                    AcrConnection.this.execute("astrogrid.myspace.copyURLToContent", new Object[]{fileURL, outUri});
                }
                finally {
                    if (file.delete()) {
                        logger_.info("Temporary file " + file + " deleted");
                    }
                }
            }
        };
        logger_.info("Writing MySpace-bound data to temp file " + file);
        return ostrm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static URL getServerURL() throws IOException {
        URL uRL;
        block6: {
            InputStream istrm = null;
            try {
                int c;
                File rvfile = new File(System.getProperty("user.home"), ACR_FILE);
                istrm = new BufferedInputStream(new FileInputStream(rvfile));
                StringBuffer sbuf = new StringBuffer();
                while ((c = istrm.read()) >= 0 && c != 10 && c != 13) {
                    void var3_3;
                    sbuf.append((char)var3_3);
                }
                uRL = new URL(sbuf.toString().trim() + "xmlrpc");
                Object var6_5 = null;
                if (istrm == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_6 = null;
                    if (istrm == null) break block7;
                    try {
                        istrm.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                istrm.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return uRL;
    }
}

