/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.JargonTreeCellEditor;
import edu.sdsc.grid.gui.JargonTreeCellRenderer;
import edu.sdsc.grid.gui.JargonTreeModel;
import edu.sdsc.grid.gui.TransferStatusPanel;
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class JargonGui
extends JTree
implements ActionListener {
    private JPopupMenu popup = null;
    private MouseListener popupListener;
    private GeneralFile copyBuffer = null;
    private GeneralFile[] roots;
    private MetaDataSelect[] selects;

    public JargonGui(GeneralFile generalFile) throws IOException {
        GeneralFile[] generalFileArray = new GeneralFile[]{generalFile};
        this.createJargonTree(generalFileArray, null);
    }

    public JargonGui(GeneralFile[] generalFileArray) throws IOException {
        this.createJargonTree(generalFileArray, null);
    }

    JargonGui(GeneralFile generalFile, MetaDataSelect[] metaDataSelectArray) throws IOException {
        GeneralFile[] generalFileArray = new GeneralFile[]{generalFile};
        this.createJargonTree(generalFileArray, metaDataSelectArray);
    }

    JargonGui(GeneralFile[] generalFileArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.createJargonTree(generalFileArray, metaDataSelectArray);
    }

    public GeneralFile[] getRoots() {
        return this.roots;
    }

    public MetaDataSelect[] getSelects() {
        return this.selects;
    }

    public GeneralFile getCopyBuffer() {
        return this.copyBuffer;
    }

    private void createJargonTree(GeneralFile[] generalFileArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.roots = generalFileArray;
        this.selects = metaDataSelectArray;
        this.setModel(new JargonTreeModel(generalFileArray, metaDataSelectArray));
        JargonTreeCellRenderer jargonTreeCellRenderer = new JargonTreeCellRenderer();
        this.setCellRenderer(jargonTreeCellRenderer);
        this.setEditable(true);
        this.setCellEditor(new JargonTreeCellEditor());
    }

    public void useDefaultPopupMenu(boolean bl) {
        if (!bl) {
            this.popup = null;
            this.removeMouseListener(this.popupListener);
            return;
        }
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Refresh");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        jMenuItem = new JMenuItem("Query");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Modify");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block12: {
            String string = actionEvent.getActionCommand();
            try {
                GeneralFile generalFile = (GeneralFile)this.getLastSelectedPathComponent();
                if (string.equals("Refresh")) {
                    TreePath treePath = this.getSelectionPath();
                    if (generalFile.isFile()) {
                        treePath = treePath.getParentPath();
                    }
                    this.setSelectionRow(0);
                    this.setModel(new JargonTreeModel(this.roots, this.selects));
                    this.expandPath(treePath);
                    break block12;
                }
                if (string.equals("Query")) {
                    if (generalFile == null) break block12;
                    break block12;
                }
                if (string.equals("Copy")) {
                    if (generalFile == null) break block12;
                    this.copyBuffer = generalFile;
                    break block12;
                }
                if (string.equals("Paste")) {
                    if (this.copyBuffer == null || generalFile == null) {
                        return;
                    }
                    TransferStatusPanel transferStatusPanel = null;
                    if (generalFile.isDirectory() && this.copyBuffer.isFile()) {
                        transferStatusPanel = new TransferStatusPanel(this.copyBuffer, FileFactory.newFile(generalFile, this.copyBuffer.getName()));
                        transferStatusPanel.setOverwrite(2);
                        JFrame jFrame = new JFrame();
                        jFrame.getContentPane().add(transferStatusPanel);
                        jFrame.pack();
                        jFrame.show();
                        transferStatusPanel.start();
                    } else {
                        transferStatusPanel = new TransferStatusPanel(this.copyBuffer, FileFactory.newFile(generalFile, this.copyBuffer.getName()));
                        transferStatusPanel.setOverwrite(2);
                        JFrame jFrame = new JFrame();
                        jFrame.getContentPane().add(transferStatusPanel);
                        jFrame.pack();
                        jFrame.show();
                        transferStatusPanel.start();
                    }
                } else if (string.equals("Delete") && generalFile != null) {
                    generalFile.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private JargonGui(String[] stringArray, MetaDataSelect[] metaDataSelectArray) throws URISyntaxException, IOException {
        Object[] objectArray;
        if (metaDataSelectArray == null) {
            objectArray = new String[]{"file comments", "size", "access constraint", "user name", "definable metadata for files"};
            metaDataSelectArray = MetaDataSet.newSelection((String[])objectArray);
        }
        if (stringArray.length < 1) {
            objectArray = new SRBFileSystem();
            GeneralFile[] generalFileArray = new GeneralFile[]{new LocalFile("c:/"), FileFactory.newFile((GeneralFileSystem)objectArray, "/"), FileFactory.newFile((GeneralFileSystem)objectArray, objectArray.getHomeDirectory())};
            this.createJargonTree(generalFileArray, metaDataSelectArray);
        } else {
            objectArray = new GeneralFile[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                objectArray[n] = FileFactory.newFile(new URI(stringArray[n]));
                ++n;
            }
            this.createJargonTree((GeneralFile[])objectArray, metaDataSelectArray);
        }
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame("JargonTree");
            JargonGui jargonGui = new JargonGui(stringArray, null);
            jargonGui.useDefaultPopupMenu(true);
            JScrollPane jScrollPane = new JScrollPane(jargonGui);
            jScrollPane.setPreferredSize(new Dimension(800, 600));
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.getContentPane().add((Component)jScrollPane, "North");
            jFrame.pack();
            jFrame.show();
            jFrame.validate();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println(((SRBException)throwable).getStandardMessage());
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (JargonGui.this.getLastSelectedPathComponent() == null) {
                    return;
                }
                JargonGui.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

