/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.BinaryDataFormat;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.Host;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public abstract class GeneralRandomAccessFile
implements DataOutput,
DataInput {
    public static final int SEEK_START = 0;
    public static final int SEEK_CURRENT = 1;
    public static final int SEEK_END = 2;
    protected int fd = -1;
    protected int rw;
    protected BinaryDataFormat fileFormat;
    protected boolean swapNeeded;
    protected boolean isClosed;
    protected GeneralFile file;

    public GeneralRandomAccessFile(GeneralFile generalFile, String string) throws IOException, SecurityException {
        int n = -1;
        this.file = generalFile;
        this.file.createNewFile();
        this.rwCheck(this.file, string);
        this.fileFormat = new BinaryDataFormat();
    }

    public void finalize() throws IOException {
        this.close();
    }

    protected void rwCheck(GeneralFile generalFile, String string) throws IllegalArgumentException, SecurityException {
        if ((string = string.toLowerCase()).equals("r")) {
            this.rw = 0;
        } else if (string.equals("rw")) {
            this.rw = 1;
        } else if (string.equals("rws")) {
            this.rw = 2;
        } else if (string.equals("rwd")) {
            this.rw = 3;
        } else {
            throw new IllegalArgumentException("Illegal mode \"" + string + "\" must be one of \"r\", \"rw\", \"rws\", or \"rwd\"");
        }
        if (!generalFile.canRead()) {
            throw new SecurityException("Wrong permissions to access this file.");
        }
        if (this.rw > 0 && !generalFile.canWrite()) {
            throw new SecurityException("Wrong permissions to access this file.");
        }
    }

    public int getFD() {
        if (this.fd != -1) {
            return this.fd;
        }
        throw new IllegalArgumentException("No file descriptor available.");
    }

    public GeneralFile getFile() {
        return this.file;
    }

    protected abstract void open(GeneralFile var1) throws IOException;

    public abstract int read() throws IOException;

    protected abstract int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public int skipBytes(int n) throws IOException {
        long l;
        if (n <= 0) {
            return 0;
        }
        long l2 = this.getFilePointer();
        long l3 = l2 + (long)n;
        if (l3 > (l = this.length())) {
            l3 = l;
        }
        this.seek(l3);
        return (int)(l3 - l2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray, 0, byArray.length);
    }

    protected abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public void write(String string) throws IOException {
        this.writeBytes(string.getBytes(), 0, string.length());
    }

    public abstract long getFilePointer() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public abstract void seek(long var1, int var3) throws IOException;

    public abstract long length() throws IOException;

    public abstract void setLength(long var1) throws IOException;

    public abstract void close() throws IOException;

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws EOFException, IOException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getShortSize());
        return this.fileFormat.shortValue(byArray);
    }

    public int readUnsignedShort() throws IOException, EOFException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getShortSize());
        return this.fileFormat.unsignedShortValue(byArray);
    }

    public char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public int readInt() throws EOFException, IOException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getIntSize());
        return this.fileFormat.intValue(byArray);
    }

    public long readUnsignedInt() throws IOException, EOFException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getIntSize());
        return this.fileFormat.unsignedIntValue(byArray);
    }

    public long readLong() throws EOFException, IOException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getLongSize());
        return this.fileFormat.longValue(byArray);
    }

    public long readUnsignedLong() throws IOException, EOFException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getLongSize());
        return this.fileFormat.unsignedLongValue(byArray);
    }

    public long readUnsignedLongLong() throws IOException, EOFException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getLongLongSize());
        return this.fileFormat.unsignedLongLongValue(byArray);
    }

    public long readLongLong() throws IOException, EOFException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getLongLongSize());
        return this.fileFormat.longLongValue(byArray);
    }

    public double readLongDouble() throws IOException, EOFException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getLongDoubleSize());
        return this.fileFormat.longDoubleValue(byArray);
    }

    public float readFloat() throws EOFException, IOException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getFloatSize());
        return this.fileFormat.floatValue(byArray);
    }

    public double readDouble() throws EOFException, IOException {
        byte[] byArray = new byte[64];
        this.readFully(byArray, 0, this.fileFormat.getDoubleSize());
        return this.fileFormat.doubleValue(byArray);
    }

    public String readLine() throws IOException {
        char c = (char)this.read();
        StringBuffer stringBuffer = new StringBuffer();
        while (c != '\n' && c != '\r' && c != '\uffff') {
            stringBuffer.append(c);
            c = (char)this.read();
        }
        if (c == '\r' && this.read() != 10) {
            this.seek(this.getFilePointer());
        } else if (c == '\uffffffff' && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeShort(int n) throws IOException {
        byte[] byArray = new byte[64];
        int n2 = this.fileFormat.encodeShort(n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeChar(int n) throws IOException {
        byte[] byArray = new byte[64];
        int n2 = this.fileFormat.encodeShort(n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeInt(int n) throws IOException {
        byte[] byArray = new byte[64];
        int n2 = this.fileFormat.encodeInt(n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeLong(long l) throws IOException {
        byte[] byArray = new byte[64];
        int n = this.fileFormat.encodeLong(l, byArray);
        this.write(byArray, 0, n);
    }

    public void writeLongLong(long l) throws IOException {
        byte[] byArray = new byte[64];
        int n = this.fileFormat.encodeLongLong(l, byArray);
        this.write(byArray, 0, n);
    }

    public void writeLongDouble(double d) throws IOException {
        byte[] byArray = new byte[64];
        int n = this.fileFormat.encodeLongDouble(d, byArray);
        this.write(byArray, 0, n);
    }

    public void writeFloat(float f) throws IOException {
        byte[] byArray = new byte[64];
        int n = this.fileFormat.encodeFloat(f, byArray);
        this.write(byArray, 0, n);
    }

    public void writeDouble(double d) throws IOException {
        byte[] byArray = new byte[64];
        int n = this.fileFormat.encodeDouble(d, byArray);
        this.write(byArray, 0, n);
    }

    public void writeBytes(String string) throws IOException {
        this.writeBytes(string.getBytes(), 0, string.length());
    }

    public void writeChars(String string) throws IOException {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < string.length()) {
            this.writeChar(cArray[n]);
            ++n;
        }
    }

    public void writeUTF(String string) throws IOException {
    }

    public void setBinaryDataFormat(BinaryDataFormat binaryDataFormat) {
        if (binaryDataFormat == null) {
            return;
        }
        this.fileFormat = binaryDataFormat;
        this.swapNeeded = this.fileFormat.isMBFByteOrder() != Host.isMBFByteOrder();
    }

    public BinaryDataFormat getBinaryDataFormat() {
        return this.fileFormat;
    }

    public void readBooleans(boolean[] blArray, int n) throws EOFException, IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = byArray[n2] != 0;
            ++n2;
        }
    }

    public void readDoubles(double[] dArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getDoubleSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.doubleValues(byArray, dArray, n);
    }

    public void readFloats(float[] fArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getFloatSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.floatValues(byArray, fArray, n);
    }

    public void readInts(int[] nArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getIntSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.intValues(byArray, nArray, n);
    }

    public void readLongs(long[] lArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getLongSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.longValues(byArray, lArray, n);
    }

    public void readLongDoubles(double[] dArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getLongDoubleSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.longDoubleValues(byArray, dArray, n);
    }

    public void readLongLongs(long[] lArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getLongLongSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.longLongValues(byArray, lArray, n);
    }

    public void readShorts(short[] sArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getShortSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.shortValues(byArray, sArray, n);
    }

    public void readUnsignedShorts(short[] sArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getShortSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.unsignedShortValues(byArray, sArray, n);
    }

    public void readUnsignedInts(int[] nArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getIntSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.unsignedIntValues(byArray, nArray, n);
    }

    public void readUnsignedLongs(long[] lArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getLongSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.unsignedLongValues(byArray, lArray, n);
    }

    public void readUnsignedLongLongs(long[] lArray, int n) throws EOFException, IOException {
        int n2 = n * this.fileFormat.getLongLongSize();
        byte[] byArray = new byte[n2];
        this.readFully(byArray, 0, n2);
        this.fileFormat.unsignedLongLongValues(byArray, lArray, n);
    }

    public void writeBooleans(boolean[] blArray, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = !blArray[n2] ? (byte)0 : 1;
            ++n2;
        }
        this.write(byArray, 0, n);
    }

    public void writeDoubles(double[] dArray, int n) throws IOException {
        int n2 = n * this.fileFormat.getDoubleSize();
        byte[] byArray = new byte[n2];
        this.fileFormat.encodeDoubles(dArray, n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeFloats(float[] fArray, int n) throws IOException {
        int n2 = n * this.fileFormat.getFloatSize();
        byte[] byArray = new byte[n2];
        this.fileFormat.encodeFloats(fArray, n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeInts(int[] nArray, int n) throws IOException {
        int n2 = n * this.fileFormat.getIntSize();
        byte[] byArray = new byte[n2];
        this.fileFormat.encodeInts(nArray, n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeLongs(long[] lArray, int n) throws IOException {
        int n2 = n * this.fileFormat.getLongSize();
        byte[] byArray = new byte[n2];
        this.fileFormat.encodeLongs(lArray, n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeShorts(short[] sArray, int n) throws IOException {
        int n2 = n * this.fileFormat.getShortSize();
        byte[] byArray = new byte[n2];
        this.fileFormat.encodeShorts(sArray, n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeLongLongs(long[] lArray, int n) throws IOException {
        int n2 = n * this.fileFormat.getLongLongSize();
        byte[] byArray = new byte[n2];
        this.fileFormat.encodeLongLongs(lArray, n, byArray);
        this.write(byArray, 0, n2);
    }

    public void writeLongDoubles(double[] dArray, int n) throws IOException {
        int n2 = n * this.fileFormat.getLongDoubleSize();
        byte[] byArray = new byte[n2];
        this.fileFormat.encodeLongDoubles(dArray, n, byArray);
        this.write(byArray, 0, n2);
    }
}

