/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.Protocol;

public final class MetaDataField
implements Comparable {
    public static final int INT = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int STRING = 3;
    public static final int DATE = 4;
    public static final int TABLE = 14;
    String fieldName;
    String description;
    int type;
    Protocol[] protocols = new Protocol[1];

    public MetaDataField(String string, String string2, int n, Protocol protocol) {
        this.fieldName = string;
        this.description = string2;
        this.type = n;
        this.protocols[0] = protocol;
    }

    public String getName() {
        return this.fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    Protocol[] getProtocols() {
        return this.protocols;
    }

    Protocol getProtocol(int n) {
        return this.protocols[n];
    }

    public boolean usesProtocol(Protocol protocol) {
        int n = 0;
        while (n < this.protocols.length) {
            if (this.protocols[n].equals(protocol)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void addProtocol(Protocol protocol) {
        Protocol[] protocolArray = this.protocols;
        this.protocols = new Protocol[protocolArray.length + 1];
        int n = 0;
        while (n < protocolArray.length) {
            this.protocols[n] = protocolArray[n];
            ++n;
        }
        this.protocols[protocolArray.length] = protocol;
    }

    public boolean equals(Object object) {
        MetaDataField metaDataField = null;
        if (object == null) {
            return false;
        }
        try {
            metaDataField = (MetaDataField)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.fieldName == metaDataField.getName() && this.description == metaDataField.getDescription() && this.type == metaDataField.getType();
    }

    public String toString() {
        return this.fieldName;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }
}

