/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;

public class SRBFile
extends RemoteFile {
    public static final int MDAS_CATALOG = 0;
    public static final int LDAP_CATALOG = 1;
    public static final int FILE_CATALOG = 2;
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    static final int OPR_COPY = 0;
    static final int BUFFER_MAX_SIZE = 2000000;
    static final int BULK_LOAD_BUFFER_SIZE = 0x800000;
    static final int MAX_REGISTRATION_THREADS = 4;
    static final int MAX_REGISTRATION_FILES = 300;
    static final int LIST_CHECKSUM = 16;
    static final int COMPUTE_CHECKSUM = 128;
    static final int FORCE_CHECKSUM = 32;
    static String ZONE_AUTHORITY = "http://www.sdsc.edu/srb/cgi-bin/zoneList.cgi?zone=";
    protected SRBFileSystem srbFileSystem;
    int catalogType = 0;
    String resource;
    String dataType = "generic";
    int continuationIndex = -1;
    boolean deleteOnExit = false;
    static Vector uriFileSystems = new Vector();
    String originalFilePath;
    private int replicaNumber = -1;
    public boolean completeDirectoryList = true;
    IOException bulkLoadException = null;
    private volatile boolean loading1 = false;
    private volatile int transfer = 0;
    int activeRegistrationThread = 0;
    int filesReadyToRegister = 0;

    public SRBFile(SRBFileSystem sRBFileSystem, String string) throws NullPointerException {
        this(sRBFileSystem, "", string);
        this.originalFilePath = string;
    }

    public SRBFile(SRBFileSystem sRBFileSystem, String string, String string2) throws NullPointerException, IllegalArgumentException {
        super(sRBFileSystem, string, string2);
        this.makePathCanonical(string);
        this.resource = sRBFileSystem.getDefaultStorageResource();
        this.originalFilePath = string != null ? (!string.equals("") ? string + PATH_SEPARATOR + string2 : string2) : string2;
    }

    public SRBFile(SRBFile sRBFile, String string) throws NullPointerException {
        this((SRBFileSystem)sRBFile.getFileSystem(), sRBFile.getPath(), string);
    }

    public SRBFile(URI uRI) throws NullPointerException, IOException {
        super(uRI);
        Object[] objectArray;
        Object object;
        MetaDataRecordList[] metaDataRecordListArray;
        Object object2;
        if (!uRI.getScheme().equals("srb")) {
            throw new IllegalArgumentException();
        }
        String string = uRI.getHost();
        int n = uRI.getPort();
        String string2 = uRI.getPath();
        String string3 = uRI.getUserInfo();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Object var10_10 = null;
        int n2 = -1;
        if (string3 == null || string3 == "") {
            string4 = "public";
            string5 = "npaci";
            string6 = "CANDO";
            string7 = "/home/public.npaci/";
        } else {
            n2 = string3.indexOf(".");
            if (n2 < 0) {
                throw new MalformedURLException();
            }
            string4 = string3.substring(0, n2);
            if (n2 < 0) {
                throw new MalformedURLException();
            }
            if ((n2 = (string3 = string3.substring(n2 + 1)).indexOf(":")) > 0) {
                string5 = string3.substring(0, n2);
                string6 = string3.substring(n2 + 1);
            } else {
                string5 = string3;
            }
            string7 = "/home/" + string4 + "." + string5;
        }
        n2 = string.indexOf(".");
        if (n2 < 0) {
            object2 = new URL(ZONE_AUTHORITY + string);
            metaDataRecordListArray = ((URL)object2).openConnection().getInputStream();
            int n3 = -1;
            object = null;
            objectArray = new byte[1000];
            metaDataRecordListArray.read((byte[])objectArray);
            object = new String((byte[])objectArray);
            metaDataRecordListArray.read((byte[])objectArray);
            object = (String)object + new String((byte[])objectArray);
            n2 = ((String)object).indexOf("ns1:server");
            n3 = ((String)object).indexOf("/ns1:server", n2 + 11);
            if (n2 < 0 || n3 < 0) {
                throw new ConnectException("Invalid zone name.");
            }
            string = ((String)object).substring(n2 + 11, n3 - 1);
            n2 = ((String)object).indexOf("ns1:port");
            if ((object = ((String)object).substring(n2 + 9, (n3 = ((String)object).indexOf("/ns1:port", n2 + 9)) - 1)) != null && ((String)object).length() > 0) {
                n = Integer.parseInt((String)object);
            }
        }
        if (n < 0) {
            n = 5544;
        }
        if (string2 == null || string2 == "") {
            this.setFileName(PATH_SEPARATOR);
        } else {
            this.setFileName(string2);
        }
        object2 = new SRBAccount(string, n, string4, string6, string7, string5, "");
        this.setFileSystem(new SRBFileSystem((SRBAccount)object2));
        metaDataRecordListArray = null;
        if (!this.srbFileSystem.getVersion().equals("SRB2.0.0&D") && !this.srbFileSystem.getVersion().equals("SRB1.1.8&C")) {
            metaDataRecordListArray = this.query("zone name");
            if (metaDataRecordListArray == null) {
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 10, string4), MetaDataSet.newCondition("user domain", 0, string5)};
                object = new MetaDataSelect[]{MetaDataSet.newSelection("zone name")};
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, (MetaDataSelect[])object);
            }
            String string8 = metaDataRecordListArray[0].getValue("zone name").toString();
            this.srbFileSystem.setProxyMcatZone(string8);
            this.srbFileSystem.setMcatZone(string8);
            metaDataRecordListArray = this.query("resource name");
            if (metaDataRecordListArray == null) {
                object = new MetaDataCondition[]{MetaDataSet.newCondition("resource access privilege", 10, "%write%"), MetaDataSet.newCondition("user name used for rsrc access", 0, string4), MetaDataSet.newCondition("user domn used for rsrc access", 0, string5), MetaDataSet.newCondition("user zone used for rsrc access", 0, string8)};
                objectArray = new MetaDataSelect[]{MetaDataSet.newSelection("resource name")};
                metaDataRecordListArray = this.srbFileSystem.query((MetaDataCondition[])object, (MetaDataSelect[])objectArray);
            }
        } else {
            metaDataRecordListArray = this.query("resource name");
            if (metaDataRecordListArray == null) {
                throw new FileNotFoundException("Unknown resource");
            }
        }
        this.srbFileSystem.setDefaultStorageResource(metaDataRecordListArray[0].getValue("resource name").toString());
        this.originalFilePath = uRI.getPath();
        SRBFileSystem sRBFileSystem = null;
        int n4 = 0;
        while (n4 < uriFileSystems.size()) {
            sRBFileSystem = (SRBFileSystem)uriFileSystems.get(n4);
            if (this.srbFileSystem.equals(sRBFileSystem)) {
                this.srbFileSystem = sRBFileSystem;
                return;
            }
            if (!sRBFileSystem.isConnected()) {
                uriFileSystems.remove(n4);
            }
            ++n4;
        }
        uriFileSystems.add(this.srbFileSystem);
    }

    protected void finalize() throws Throwable {
        if (this.deleteOnExit) {
            this.delete();
        }
        super.finalize();
        if (this.resource != null) {
            this.resource = null;
        }
        if (this.dataType != null) {
            this.dataType = null;
        }
    }

    protected void setFileName(String string) {
        int n;
        String string2 = System.getProperty("file.separator");
        if (string == null) {
            throw new NullPointerException("The file name cannot be null");
        }
        if (!string2.equals(PATH_SEPARATOR)) {
            n = string.lastIndexOf(string2);
            while (n >= 0 && string.substring(n + 1).length() > 0) {
                string = string.substring(0, n) + PATH_SEPARATOR + string.substring(n + 1);
                n = string.lastIndexOf(string2);
            }
        }
        this.fileName = string;
        if (this.fileName.length() > 1) {
            n = this.fileName.lastIndexOf(PATH_SEPARATOR);
            while (n == this.fileName.length() - 1 && n >= 0) {
                this.fileName = this.fileName.substring(0, n);
                n = this.fileName.lastIndexOf(PATH_SEPARATOR);
            }
            if (n >= 0 && this.fileName.substring(n + 1).length() > 0) {
                this.setDirectory(this.fileName.substring(0, n + 1));
                this.fileName = this.fileName.substring(n + 1);
            }
        }
    }

    protected void setDirectory(String string) {
        if (this.directory == null) {
            this.directory = new Vector();
        }
        if (string == null) {
            return;
        }
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n >= 0 && string.substring(n + 1).length() > 0) {
            string = string.substring(0, n) + PATH_SEPARATOR + string.substring(n + 1);
            n = string.lastIndexOf(string2);
        }
        while (this.directory.size() > 0 && string.startsWith(PATH_SEPARATOR)) {
            string = string.substring(1);
        }
        n = string.indexOf(PATH_SEPARATOR);
        if (n >= 0) {
            do {
                this.directory.add(string.substring(0, n));
                while ((n = (string = string.substring(n + 1)).indexOf(PATH_SEPARATOR)) == 0) {
                }
            } while (n >= 0);
        }
        if (!string.equals("") && string != null) {
            this.directory.add(string);
        }
    }

    void makePathCanonical(String string) {
        int n = 0;
        boolean bl = false;
        String string2 = null;
        if (string == null) {
            string = "";
        }
        if (this.fileName.equals(PATH_SEPARATOR) && string == "") {
            return;
        }
        if (this.fileName.equals("") && string.equals("")) {
            String string3 = this.srbFileSystem.getHomeDirectory();
            int n2 = string3.lastIndexOf(PATH_SEPARATOR);
            this.setDirectory(string3.substring(0, n2));
            this.setFileName(string3.substring(n2 + 1));
            return;
        }
        if (string.startsWith(PATH_SEPARATOR)) {
            bl = true;
        }
        if (this.directory.size() > 0 && this.directory.get(0).toString().length() == 0) {
            bl = true;
        }
        if (!bl) {
            String string4 = this.srbFileSystem.getHomeDirectory();
            int n3 = string4.indexOf(PATH_SEPARATOR);
            if (n3 >= 0) {
                do {
                    this.directory.add(n, string4.substring(0, n3));
                    string4 = string4.substring(n3 + 1);
                    n3 = string4.indexOf(PATH_SEPARATOR);
                    ++n;
                } while (n3 > 0);
            }
            if (!string4.equals("") && string4 != null) {
                this.directory.add(n, string4);
            }
        }
        n = 0;
        while (n < this.directory.size()) {
            string2 = this.directory.get(n).toString();
            if (string2.equals(".")) {
                this.directory.remove(n);
                --n;
            } else if (string2.equals("..") && n >= 2) {
                this.directory.remove(n);
                this.directory.remove(n - 1);
                if (--n > 0) {
                    --n;
                }
            } else if (string2.equals("..")) {
                this.directory.remove(n);
                --n;
            } else if (string2.startsWith(PATH_SEPARATOR)) {
                while ((string2 = string2.substring(1)).startsWith(PATH_SEPARATOR)) {
                }
                this.directory.remove(n);
                this.directory.add(n, string2);
            }
            ++n;
        }
        if (this.fileName.equals(".")) {
            this.fileName = this.directory.get(this.directory.size() - 1).toString();
            this.directory.remove(this.directory.size() - 1);
        } else if (this.fileName.equals("..")) {
            if (this.directory.size() > 1) {
                this.fileName = this.directory.get(this.directory.size() - 2).toString();
                this.directory.remove(this.directory.size() - 1);
                this.directory.remove(this.directory.size() - 1);
            } else {
                this.fileName = PATH_SEPARATOR;
                this.directory.remove(this.directory.size() - 1);
            }
        }
        this.getReplicaNumber();
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = generalFileSystem;
        this.srbFileSystem = (SRBFileSystem)this.fileSystem;
    }

    public void setResource(String string) throws IOException, NullPointerException, IllegalArgumentException {
        if (string != null) {
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("resource name", 0, string)};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("resource name")};
            MetaDataRecordList[] metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray);
            if (metaDataRecordListArray == null) {
                throw new IllegalArgumentException("Resource not found");
            }
            this.resource = string;
            if (this.isFile()) {
                this.srbFileSystem.srbObjMove(this.catalogType, this.fileName, this.getParent(), this.resource, "");
            }
        } else {
            throw new NullPointerException();
        }
    }

    public void setDataType(String string) throws IOException {
        if (string == null) {
            string = "generic";
        }
        if (this.isFile()) {
            if (this.getReplicaNumber() >= 0) {
                this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, string, null, 5);
            } else {
                this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), null, null, string, null, 5);
            }
        }
        this.dataType = string;
    }

    public void setReplicaNumber(int n) {
        if (n >= 0) {
            this.fileName = this.getName() + "&COPY=" + n;
            this.replicaNumber = n;
        } else {
            this.fileName = this.getName();
            this.replicaNumber = -1;
        }
    }

    public int getReplicaNumber() {
        if (this.replicaNumber >= 0) {
            return this.replicaNumber;
        }
        int n = this.fileName.indexOf("&COPY=");
        if (n >= 0) {
            this.replicaNumber = new Integer(this.fileName.substring(n + 6));
            return this.replicaNumber;
        }
        return -1;
    }

    public String getResource() throws IOException {
        if (this.isDirectory()) {
            return null;
        }
        MetaDataRecordList[] metaDataRecordListArray = this.query("physical resource name");
        if (metaDataRecordListArray != null) {
            this.resource = metaDataRecordListArray[0].getValue("physical resource name").toString();
            return this.resource;
        }
        return null;
    }

    public String getDataType() throws IOException {
        if (this.isDirectory()) {
            return this.dataType;
        }
        MetaDataRecordList[] metaDataRecordListArray = this.query("file type name");
        if (metaDataRecordListArray == null) {
            return null;
        }
        return metaDataRecordListArray[0].getValue("file type name").toString();
    }

    public int getCatalogType() {
        return this.catalogType;
    }

    public final String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public final char getPathSeparatorChar() {
        return '/';
    }

    public GeneralFileSystem getFileSystem() throws NullPointerException {
        if (this.srbFileSystem != null) {
            return this.srbFileSystem;
        }
        throw new NullPointerException("fileSystem is null.");
    }

    public MetaDataRecordList[] query(String string) throws IOException {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection(string)};
        return this.query(metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(String[] stringArray) throws IOException {
        return this.query(MetaDataSet.newSelection(stringArray), SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect metaDataSelect) throws IOException {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{metaDataSelect};
        return this.query(metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        MetaDataCondition[] metaDataConditionArray = null;
        String string = null;
        int n2 = 0;
        String string2 = null;
        if (this.isDirectory()) {
            metaDataConditionArray = new MetaDataCondition[1];
            string = "directory name";
            n2 = 0;
            string2 = this.getAbsolutePath();
            metaDataConditionArray[0] = MetaDataSet.newCondition(string, n2, string2);
        } else {
            metaDataConditionArray = new MetaDataCondition[3];
            string = "directory name";
            n2 = 0;
            string2 = this.getParent();
            metaDataConditionArray[0] = MetaDataSet.newCondition(string, n2, string2);
            string = "file name";
            string2 = this.getName();
            metaDataConditionArray[1] = MetaDataSet.newCondition(string, n2, string2);
            if (this.getReplicaNumber() >= 0) {
                string = "file replication enum";
                string2 = "" + this.replicaNumber;
                metaDataConditionArray[2] = MetaDataSet.newCondition(string, n2, string2);
            }
        }
        return this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, n);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataConditionArray, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        MetaDataCondition[] metaDataConditionArray2 = null;
        String string = null;
        int n2 = 0;
        String string2 = null;
        if (this.isDirectory()) {
            metaDataConditionArray2 = new MetaDataCondition[metaDataConditionArray.length + 1];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, metaDataConditionArray.length);
            string = "directory name";
            n2 = 0;
            string2 = this.getAbsolutePath();
            metaDataConditionArray2[metaDataConditionArray.length] = MetaDataSet.newCondition(string, n2, string2);
        } else {
            metaDataConditionArray2 = new MetaDataCondition[metaDataConditionArray.length + 3];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, metaDataConditionArray.length);
            string = "directory name";
            n2 = 0;
            string2 = this.getParent();
            metaDataConditionArray2[metaDataConditionArray.length] = MetaDataSet.newCondition(string, n2, string2);
            string = "file name";
            string2 = this.fileName;
            metaDataConditionArray2[metaDataConditionArray.length + 1] = MetaDataSet.newCondition(string, n2, string2);
            if (this.getReplicaNumber() >= 0) {
                string = "file replication enum";
                string2 = "" + this.replicaNumber;
                metaDataConditionArray2[2] = MetaDataSet.newCondition(string, n2, string2);
            }
        }
        return this.srbFileSystem.query(metaDataConditionArray2, metaDataSelectArray, n);
    }

    public void modifyMetaData(MetaDataRecordList metaDataRecordList) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.isFile();
        String string4 = null;
        if (this.getReplicaNumber() < 0 && bl3) {
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("path name"), MetaDataSet.newSelection("resource name")};
            MetaDataRecordList[] metaDataRecordListArray = this.query(metaDataSelectArray);
            if (metaDataRecordListArray != null) {
                string4 = metaDataRecordListArray[0].getValue("path name").toString();
                this.resource = metaDataRecordListArray[0].getValue("resource name").toString();
            } else {
                throw new FileNotFoundException("Vault path/resource not found.");
            }
        }
        int n = -1;
        boolean bl4 = false;
        int n2 = 0;
        while (n2 < metaDataRecordList.getFieldCount()) {
            int n3;
            int n4;
            int n5;
            MetaDataTable metaDataTable;
            bl4 = metaDataRecordList.getValue(n2) == null;
            if (metaDataRecordList.getFieldName(n2) == "file comments") {
                if (bl4) {
                    n = 12;
                } else {
                    n = 13;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "size") {
                n = 4;
                string = metaDataRecordList.getStringValue(n2);
                bl = true;
            } else if (metaDataRecordList.getFieldName(n2) == "file type name") {
                n = 5;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "directory name") {
                n = 6;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "offset") {
                n = 35;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "is dirty") {
                n = 36;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file replication enum") {
                n = 132;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file lock num") {
                n = 85;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file checksum") {
                n = 137;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file hide") {
                n = 138;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file auditflag") {
                n = 139;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file pin val") {
                n = 140;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file expiry date") {
                n = 141;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file expire date 2") {
                n = 142;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file is compressed") {
                n = 143;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file is encrypted") {
                n = 144;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file name") {
                n = 29;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file annotation timestamp") {
                if (bl4) {
                    n = 39;
                } else {
                    n = 40;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "file annotation") {
                n = 41;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "owner") {
                n = 15;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "path name") {
                n = 126;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "modification date") {
                n = 42;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file last access timestamp") {
                n = 76;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "file class name") {
                if (bl4) {
                    n = 43;
                } else {
                    n = 44;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "index name for file") {
                if (bl4) {
                    n = 45;
                } else {
                    n = 46;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "index name for datatype") {
                if (bl4) {
                    n = 47;
                } else {
                    n = 48;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "index name for directory") {
                if (bl4) {
                    n = 49;
                } else {
                    n = 50;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "method name for file") {
                if (bl4) {
                    n = 51;
                } else {
                    n = 52;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "method name for datatype") {
                if (bl4) {
                    n = 53;
                } else {
                    n = 54;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "method name for directory") {
                if (bl4) {
                    n = 55;
                } else {
                    n = 56;
                    string = metaDataRecordList.getStringValue(n2);
                }
            } else if (metaDataRecordList.getFieldName(n2) == "definable metadata for files") {
                metaDataTable = metaDataRecordList.getTableValue(n2);
                string2 = "|";
                n5 = 0;
                while (n5 < metaDataTable.getRowCount()) {
                    string = "";
                    n4 = metaDataTable.getColumnCount();
                    n3 = 0;
                    while (n3 < n4) {
                        string = n3 == n4 - 1 ? string + metaDataTable.getStringValue(n5, n3) : string + metaDataTable.getStringValue(n5, n3) + string2;
                        ++n3;
                    }
                    if (string4 == null) {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, string, string2, 147);
                    } else {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, string4, string, string2, 147);
                    }
                    ++n5;
                }
            } else if (metaDataRecordList.getFieldName(n2) == "definable metadata for directories") {
                metaDataTable = metaDataRecordList.getTableValue(n2);
                string2 = "|";
                n5 = 0;
                while (n5 < metaDataTable.getRowCount()) {
                    string = "";
                    n4 = metaDataTable.getColumnCount();
                    n3 = 0;
                    while (n3 < n4) {
                        string = n3 == n4 - 1 ? string + metaDataTable.getStringValue(n5, n3) : string + metaDataTable.getStringValue(n5, n3) + string2;
                        ++n3;
                    }
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), string, string2, string3, 148);
                    ++n5;
                }
            } else if (metaDataRecordList.getFieldName(n2) == "directory annotation") {
                n = 95;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "container for directory") {
                n = 146;
                string = metaDataRecordList.getStringValue(n2);
            } else if (metaDataRecordList.getFieldName(n2) == "guid") {
                if (bl4) {
                    n = 169;
                } else {
                    if (string4 == null) {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, string, string2, 169);
                    } else {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, string4, string, string2, 169);
                    }
                    n = 168;
                    string = metaDataRecordList.getStringValue(n2);
                    string2 = "1";
                }
            }
            if (n >= 0) {
                if (bl3) {
                    if (!bl2) {
                        if (string4 == null) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), null, null, string, string2, n);
                        } else {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, this.getName(), this.getParent(), this.resource, string4, string, string2, n);
                        }
                    }
                } else if (!bl) {
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), string, string2, string3, n);
                }
            }
            ++n2;
        }
    }

    public String toString() {
        return new String("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath());
    }

    public void copyTo(GeneralFile generalFile) throws IOException {
        this.copyTo(generalFile, false);
    }

    public void copyTo(GeneralFile generalFile, boolean bl) throws IOException {
        this.copyTo(generalFile, bl, true);
    }

    public void copyTo(GeneralFile generalFile, boolean bl, boolean bl2) throws IOException {
        if (generalFile == null) {
            throw new NullPointerException();
        }
        FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath()).getParentFile().mkdirs();
        if (this.srbFileSystem.getVersion().startsWith("SRB1.")) {
            super.copyTo(generalFile, bl);
            return;
        }
        if (this.isDirectory()) {
            if (generalFile instanceof LocalFile && !this.srbFileSystem.getVersion().startsWith("SRB2") && bl2) {
                this.bulkUnload((LocalFile)generalFile);
            } else {
                GeneralFile[] generalFileArray = this.listFiles();
                generalFile.mkdir();
                if (generalFileArray != null) {
                    int n = 0;
                    while (n < generalFileArray.length) {
                        generalFileArray[n].copyTo(FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath(), generalFileArray[n].getName()), bl);
                        ++n;
                    }
                }
            }
        } else if (this.isFile()) {
            if (!bl && generalFile.exists()) {
                super.copyTo(generalFile, bl);
                return;
            }
            if (generalFile instanceof LocalFile) {
                this.srbFileSystem.srbObjGet(this.fileName, this.getParent(), this.length(), generalFile, bl);
            } else if (generalFile instanceof SRBFile) {
                if (bl) {
                    generalFile.delete();
                }
                SRBRandomAccessFile sRBRandomAccessFile = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, this.getAbsolutePath()), "r");
                SRBRandomAccessFile sRBRandomAccessFile2 = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, ((SRBFile)generalFile).getAbsolutePath()), "rw");
                this.srbFileSystem.srbObjProxyOpr(0, sRBRandomAccessFile.getFD(), sRBRandomAccessFile2.getFD(), 0, 0, null, null, null, null, null, null, null);
                sRBRandomAccessFile.close();
                sRBRandomAccessFile2.close();
            } else {
                super.copyTo(generalFile, bl);
            }
        } else {
            throw new FileNotFoundException("Source File is not valid");
        }
    }

    public void copyFrom(GeneralFile generalFile) throws IOException {
        this.copyFrom(generalFile, false);
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        this.copyFrom(generalFile, false, true);
    }

    public void copyFrom(GeneralFile generalFile, boolean bl, boolean bl2) throws IOException {
        if (generalFile == null) {
            throw new NullPointerException();
        }
        this.getParentFile().mkdirs();
        if (this.srbFileSystem.getVersion().startsWith("SRB1.")) {
            super.copyFrom(generalFile, bl);
            return;
        }
        if (generalFile.isDirectory()) {
            if (generalFile instanceof LocalFile && this.srbFileSystem.getVersionNumber() >= 3.0f && bl2) {
                LocalFile[] localFileArray = null;
                localFileArray = this.isDirectory() ? new LocalFile[]{(LocalFile)generalFile} : (LocalFile[])generalFile.listFiles();
                this.bulkLoad(localFileArray);
            } else {
                GeneralFile[] generalFileArray = generalFile.listFiles();
                this.mkdir();
                if (generalFileArray != null) {
                    int n = 0;
                    while (n < generalFileArray.length) {
                        FileFactory.newFile(this, generalFileArray[n].getName()).copyFrom(generalFileArray[n], bl);
                        ++n;
                    }
                }
            }
        } else if (generalFile.isFile()) {
            if (!bl && this.exists()) {
                super.copyFrom(generalFile, bl);
                return;
            }
            if (generalFile instanceof LocalFile) {
                long l;
                if (bl) {
                    this.delete();
                }
                if ((l = this.srbFileSystem.srbObjPut(this.getName(), this.getParent(), this.resource, null, null, generalFile.getAbsolutePath(), generalFile.length())) == -99999999L) {
                    super.copyFrom(generalFile, bl);
                }
            } else if (generalFile instanceof SRBFile) {
                if (bl) {
                    this.delete();
                }
                SRBRandomAccessFile sRBRandomAccessFile = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, ((SRBFile)generalFile).getAbsolutePath()), "r");
                SRBRandomAccessFile sRBRandomAccessFile2 = new SRBRandomAccessFile(new SRBFile(this.srbFileSystem, this.getAbsolutePath()), "rw");
                this.srbFileSystem.srbObjProxyOpr(0, sRBRandomAccessFile.getFD(), sRBRandomAccessFile2.getFD(), 0, 0, null, null, null, null, null, null, null);
                sRBRandomAccessFile.close();
                sRBRandomAccessFile2.close();
            } else {
                super.copyFrom(generalFile, bl);
            }
        } else {
            throw new FileNotFoundException("Source File is not valid");
        }
    }

    public void copyFromLocal(String string) throws IOException {
        this.copyFrom(new LocalFile(string));
    }

    public void copyFromLocal(LocalFile localFile) throws IOException {
        this.copyFrom(localFile);
    }

    public void copyToLocal(String string) throws IOException {
        this.copyTo(new LocalFile(string));
    }

    public void copyToLocal(LocalFile localFile) throws IOException {
        this.copyTo(localFile);
    }

    public void copyToRemote(RemoteFile remoteFile) throws IOException {
        this.copyTo(remoteFile);
    }

    public long fileCopyStatus() {
        return this.srbFileSystem.fileCopyStatus();
    }

    public long[] getStat() throws IOException {
        long[] lArray = null;
        if (!this.exists()) {
            return null;
        }
        lArray = this.isDirectory() ? this.srbFileSystem.srbObjStat(0, this.getAbsolutePath(), 3) : this.srbFileSystem.srbObjStat(0, this.getAbsolutePath(), 0);
        if (lArray != null) {
            return lArray;
        }
        throw new IOException("Unable to obtain file stat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void bulkLoad(LocalFile[] localFileArray) throws IOException {
        long l = -1L;
        long l2 = 0L;
        byte[] byArray = new byte[0x800000];
        byte[] byArray2 = new byte[0x800000];
        GeneralFile[] generalFileArray = new SRBFile[4];
        GeneralRandomAccessFile[] generalRandomAccessFileArray = new GeneralRandomAccessFile[4];
        Thread thread = null;
        LoadThread loadThread = null;
        this.mkdir();
        int n = 0;
        while (n < 4) {
            generalFileArray[n] = SRBFile.createTempFile("BLoad", ".tmp", this);
            generalRandomAccessFileArray[n] = FileFactory.newRandomAccessFile(generalFileArray[n], "rw");
            ++n;
        }
        RegistrationThread[] registrationThreadArray = new RegistrationThread[4];
        Thread[] threadArray = new Thread[4];
        int n2 = 0;
        while (n2 < 4) {
            registrationThreadArray[n2] = new RegistrationThread(((GeneralFile)generalFileArray[n2]).getAbsolutePath(), this);
            ++n2;
        }
        threadArray[0] = new Thread(registrationThreadArray[0]);
        loadThread = new LoadThread(generalRandomAccessFileArray, byArray, byArray2, this);
        thread = new Thread(loadThread);
        thread.start();
        int n3 = 0;
        while (n3 < localFileArray.length) {
            this.loadBuffer(localFileArray[n3], loadThread, thread, generalFileArray, threadArray, registrationThreadArray, null);
            ++n3;
        }
        SRBFile sRBFile = this;
        synchronized (sRBFile) {
            while (loadThread.buffer1Length != 0 || loadThread.buffer2Length != 0) {
                try {
                    thread.interrupt();
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        loadThread.keepLoading = false;
        try {
            if (thread.isAlive()) {
                thread.join();
            }
            int n4 = 0;
            while (n4 < 4) {
                generalRandomAccessFileArray[n4].close();
                if (registrationThreadArray[n4] != null) {
                    registrationThreadArray[n4].register();
                }
                ((SRBFile)generalFileArray[n4]).delete(true);
                ++n4;
            }
            int n5 = 0;
            while (n5 < 4) {
                if (threadArray[n5] != null && threadArray[n5].isAlive()) {
                    threadArray[n5].join();
                }
                ++n5;
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadBuffer(GeneralFile var1_1, LoadThread var2_2, Thread var3_3, GeneralFile[] var4_4, Thread[] var5_5, RegistrationThread[] var6_6, String var7_7) throws IOException {
        block44: {
            if (var1_1 == null) {
                return;
            }
            if (this.bulkLoadException != null) {
                throw this.bulkLoadException;
            }
            if (!var1_1.isDirectory()) break block44;
            var7_7 = var7_7 == null || var7_7.equals("") != false ? var1_1.getName() : var7_7 + "/" + var1_1.getName();
            var8_8 = var1_1.listFiles();
            if (var8_8 == null) {
                return;
            }
            var9_10 = 0;
            if (true) ** GOTO lbl25
        }
        var8_9 = null;
        try {
            var8_9 = FileFactory.newRandomAccessFile(var1_1, "r");
        }
        catch (SecurityException var9_11) {
            return;
        }
        var9_12 = var1_1.length();
        var11_13 = 0;
        if (true) ** GOTO lbl118
        do {
            this.loadBuffer(var8_8[var9_10], var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
            ++var9_10;
lbl25:
            // 2 sources

        } while (var9_10 < var8_8.length);
        return;
        do {
            block47: {
                block45: {
                    block46: {
                        var12_14 = this;
                        synchronized (var12_14) {
                            while (this.loading1 && this.transfer == 1 || !this.loading1 && this.transfer == 2) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException var13_16) {
                                    // empty catch block
                                }
                            }
                            if (!this.loading1) break block45;
                        }
                        if (var9_12 + (long)var2_2.buffer1Length < 0x800000L) {
                            var11_13 = var8_9.read(var2_2.buffer1, 0, (int)var9_12);
                            var9_12 -= (long)var11_13;
                            var2_2.buffer1Length += var11_13;
                            continue;
                        }
                        if (var2_2.buffer1Length >= 0x800000) break block46;
                        var11_13 = var8_9.read(var2_2.buffer1, 0, 0x800000 - var2_2.buffer1Length);
                        var2_2.buffer1Length += var11_13;
                        var9_12 -= (long)var11_13;
                        var13_15 = this;
                        synchronized (var13_15) {
                            if (true) ** GOTO lbl77
                        }
                    }
                    var13_15 = this;
                    synchronized (var13_15) {
                        if (true) ** GOTO lbl89
                    }
                }
                if (var9_12 + (long)var2_2.buffer2Length < 0x800000L) {
                    var11_13 = var8_9.read(var2_2.buffer2, 0, (int)var9_12);
                    var2_2.buffer2Length += var11_13;
                    var9_12 -= (long)var11_13;
                    continue;
                }
                if (var2_2.buffer2Length >= 0x800000) break block47;
                var11_13 = var8_9.read(var2_2.buffer2, 0, 0x800000 - var2_2.buffer2Length);
                var2_2.buffer2Length += var11_13;
                var9_12 -= (long)var11_13;
                var13_15 = this;
                synchronized (var13_15) {
                    if (true) ** GOTO lbl101
                }
            }
            var13_15 = this;
            synchronized (var13_15) {
                if (true) ** GOTO lbl113
            }
            {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var14_19) {
                        // empty catch block
                    }
lbl77:
                    // 3 sources

                } while (this.transfer == 2);
                if (var9_12 >= 0x800000L) continue;
            }
            var11_13 = var8_9.read(var2_2.buffer2, 0, (int)var9_12);
            var2_2.buffer2Length += var11_13;
            var9_12 -= (long)var11_13;
            continue;
            {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var14_20) {
                        // empty catch block
                    }
lbl89:
                    // 3 sources

                } while (this.transfer == 2);
                if (var9_12 >= 0x800000L) continue;
            }
            var11_13 = var8_9.read(var2_2.buffer2, 0, (int)var9_12);
            var2_2.buffer2Length += var11_13;
            var9_12 -= (long)var11_13;
            continue;
            {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var14_21) {
                        // empty catch block
                    }
lbl101:
                    // 3 sources

                } while (this.transfer == 1);
                if (var9_12 >= 0x800000L) continue;
            }
            var11_13 = var8_9.read(var2_2.buffer1, 0, (int)var9_12);
            var2_2.buffer1Length += var11_13;
            var9_12 -= (long)var11_13;
            continue;
            {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var14_22) {
                        // empty catch block
                    }
lbl113:
                    // 3 sources

                } while (this.transfer == 1);
                if (var9_12 >= 0x800000L) continue;
            }
            var11_13 = var8_9.read(var2_2.buffer1, 0, (int)var9_12);
            var2_2.buffer1Length += var11_13;
            var9_12 -= (long)var11_13;
lbl118:
            // 11 sources

        } while (var9_12 > 0L);
        var8_9.close();
        ++this.filesReadyToRegister;
        if (var7_7 == null) {
            var6_6[this.activeRegistrationThread].addFile(var1_1, "");
        } else {
            var6_6[this.activeRegistrationThread].addFile(var1_1, var7_7);
        }
        if (this.filesReadyToRegister % 300 != 0) return;
        var12_14 = this;
        synchronized (var12_14) {
            while (var2_2.buffer1Length != 0 && var2_2.buffer2Length != 0) {
                try {
                    var3_3.interrupt();
                    this.wait();
                }
                catch (InterruptedException var13_17) {
                    // empty catch block
                }
            }
            ** if (var5_5[this.activeRegistrationThread] != null) goto lbl-1000
        }
lbl-1000:
        // 1 sources

        {
            var5_5[this.activeRegistrationThread] = new Thread(var6_6[this.activeRegistrationThread]);
            ** GOTO lbl142
        }
lbl-1000:
        // 2 sources

        {
            while (var5_5[this.activeRegistrationThread].isAlive()) {
            }
            var5_5[this.activeRegistrationThread] = new Thread(var6_6[this.activeRegistrationThread]);
        }
lbl142:
        // 2 sources

        var6_6[this.activeRegistrationThread].setBloadFilePath(var4_4[this.activeRegistrationThread].getAbsolutePath());
        var5_5[this.activeRegistrationThread].start();
        var4_4[this.activeRegistrationThread] = SRBFile.createTempFile("BLoad", ".tmp", var4_4[this.activeRegistrationThread].getParentFile());
        var2_2.restartRandomAccessFile(this.activeRegistrationThread, var4_4[this.activeRegistrationThread]);
        ++this.activeRegistrationThread;
        if (this.activeRegistrationThread < 4) return;
        this.activeRegistrationThread = 0;
    }

    void bulkUnload(LocalFile localFile) throws IOException {
        int n = 0;
        if (this.exists()) {
            if (localFile.exists()) {
                localFile = new LocalFile(localFile, this.getName());
            } else {
                localFile.mkdir();
            }
            this.srbFileSystem.srbBulkUnload(this.catalogType, n, this.getAbsolutePath(), localFile.getAbsolutePath());
        }
    }

    public void changePermissions(String string, String string2, String string3) throws IOException {
        int n = -1;
        if (string == null) {
            string = "";
        }
        string = (string = string.toLowerCase()).equals("n") ? "" : (string.equals("r") || string.equals("read") ? "read" : (string.equals("w") || string.equals("write") ? "write" : (string.equals("rw") ? "all" : (string.equals("all") || string.equals("ownership") ? "all" : (string.equals("t") || string.equals("annotate") ? "annotate" : "")))));
        if (this.isDirectory()) {
            n = string == "" ? 28 : 27;
            this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), string2, string3, string, n);
        } else {
            n = string == "" ? 9 : 8;
            this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", string2 + "@" + string3, string, n);
        }
    }

    public void replicate(String string) throws IOException {
        if (this.isDirectory()) {
            String[] stringArray = this.list();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith(PATH_SEPARATOR)) {
                    new SRBFile(this.srbFileSystem, stringArray[n]).replicate(string);
                } else {
                    new SRBFile(this.srbFileSystem, this.getAbsolutePath() + PATH_SEPARATOR + stringArray[n]).replicate(string);
                }
                ++n;
            }
        } else {
            this.srbFileSystem.srbObjReplicate(this.catalogType, this.fileName, this.getParent(), string, null);
        }
    }

    public void backup(String string) throws IOException {
        if (this.isDirectory()) {
            String[] stringArray = this.list();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith(PATH_SEPARATOR)) {
                    new SRBFile(this.srbFileSystem, stringArray[n]).backup(string);
                } else {
                    new SRBFile(this.srbFileSystem, this.getAbsolutePath() + PATH_SEPARATOR + stringArray[n]).backup(string);
                }
                ++n;
            }
        } else {
            this.srbFileSystem.srbBackupData(this.catalogType, this.fileName, this.getParent(), string, 0);
        }
    }

    public String checksum() throws IOException {
        if (this.isFile()) {
            String string = this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 16, null);
            if (string.equals("\u0000\u0000\u0000\u00000\u0000\u0000\u0000")) {
                return this.checksum(false);
            }
            return string;
        }
        return null;
    }

    public String checksum(boolean bl) throws IOException {
        if (this.isFile()) {
            if (bl) {
                return this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 32, null);
            }
            return this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 128, null);
        }
        return null;
    }

    public void register(String string, long l) throws IOException {
        if (l < 0L) {
            l = 0L;
        }
        this.srbFileSystem.srbRegisterDataset(this.catalogType, this.getName(), this.dataType, this.resource, this.getParent(), string, l);
    }

    public InputStream executeProxyCommand(String string, String string2) throws IOException {
        return this.srbFileSystem.executeProxyCommand(string, string2, null, this.getPath(), -1);
    }

    public void link(SRBFile sRBFile) throws IOException {
        if (this.isDirectory()) {
            GeneralFile[] generalFileArray = this.listFiles();
            sRBFile.mkdir();
            int n = 0;
            while (n < generalFileArray.length) {
                SRBFile sRBFile2 = new SRBFile(sRBFile, generalFileArray[n].getName());
                ((SRBFile)generalFileArray[n]).link(sRBFile2);
                ++n;
            }
        } else {
            this.srbFileSystem.srbModifyDataset(0, this.fileName, this.getParent(), "", "", sRBFile.getName(), sRBFile.getParent(), 83);
        }
    }

    public boolean canRead() {
        block8: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string = null;
            String string2 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                MetaDataSelect[] metaDataSelectArray;
                if (this.isDirectory()) {
                    MetaDataSelect[] metaDataSelectArray2;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    int n2 = 0;
                    while (n2 < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n2].getValue("directory access constraint") != null && ((string = metaDataRecordListArray[n2].getValue("directory access constraint").toString()).equals("all") || string.equals("read"))) {
                            return true;
                        }
                        ++n2;
                    }
                    break block8;
                }
                if (!this.isFile()) break block8;
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                if (metaDataRecordListArray == null) {
                    return false;
                }
                string = metaDataRecordListArray[0].getValue("access constraint").toString();
                if (string.equals("all") || string.equals("read")) {
                    return true;
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    boolean canRead(String string) {
        block9: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string2 = null;
            String string3 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                if (string.equals("isDir")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    int n2 = 0;
                    while (n2 < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n2].getValue("directory access constraint") != null && ((string2 = metaDataRecordListArray[n2].getValue("directory access constraint").toString()).equals("all") || string2.equals("read"))) {
                            return true;
                        }
                        ++n2;
                    }
                    break block9;
                }
                if (string.equals("isFile")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    string2 = metaDataRecordListArray[0].getValue("access constraint").toString();
                    if (string2.equals("all") || string2.equals("read")) {
                        return true;
                    }
                    break block9;
                }
                return this.canRead();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public boolean canWrite() {
        block8: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string = null;
            String string2 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                MetaDataSelect[] metaDataSelectArray;
                if (this.isDirectory()) {
                    MetaDataSelect[] metaDataSelectArray2;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    int n2 = 0;
                    while (n2 < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n2].getValue("directory access constraint") != null && ((string = metaDataRecordListArray[n2].getValue("directory access constraint").toString()).equals("all") || string.equals("write"))) {
                            return true;
                        }
                        ++n2;
                    }
                    break block8;
                }
                if (!this.isFile()) break block8;
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                if (metaDataRecordListArray == null) {
                    return false;
                }
                string = metaDataRecordListArray[0].getValue("access constraint").toString();
                if (string.equals("all") || string.equals("write")) {
                    return true;
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    boolean canWrite(String string) {
        block9: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string2 = null;
            String string3 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                if (string.equals("isDir")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    int n2 = 0;
                    while (n2 < metaDataRecordListArray.length) {
                        if (metaDataRecordListArray[n2].getValue("directory access constraint") != null && ((string2 = metaDataRecordListArray[n2].getValue("directory access constraint").toString()).equals("all") || string2.equals("write"))) {
                            return true;
                        }
                        ++n2;
                    }
                    break block9;
                }
                if (string.equals("isFile")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    string2 = metaDataRecordListArray[0].getValue("access constraint").toString();
                    if (string2.equals("all") || string2.equals("write")) {
                        return true;
                    }
                    break block9;
                }
                return this.canWrite();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public int compareTo(GeneralFile generalFile) {
        return generalFile.getAbsolutePath().compareTo(this.getAbsolutePath());
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.compareTo((SRBFile)object);
    }

    public boolean createNewFile() throws IOException {
        block3: {
            try {
                if (!this.isFile()) {
                    this.getParentFile().mkdirs();
                    int n = this.srbFileSystem.srbObjCreate(this.catalogType, this.getName(), this.dataType, this.resource, this.getParent(), null, -1L);
                    this.srbFileSystem.srbObjClose(n);
                    return true;
                }
            }
            catch (SRBException sRBException) {
                if (sRBException.getType() == -3210) break block3;
                throw sRBException;
            }
        }
        return false;
    }

    public static GeneralFile createTempFile(String string, String string2) throws IOException, IllegalArgumentException {
        return SRBFile.createTempFile(string, string2, null);
    }

    public static GeneralFile createTempFile(String string, String string2, GeneralFile generalFile) throws IOException, IllegalArgumentException {
        Object object;
        String string3 = "";
        int n = 0;
        while (n < 8) {
            string3 = string3 + (char)(65.0 + Math.random() * 25.0);
            ++n;
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        if (generalFile == null) {
            object = new SRBFileSystem();
            generalFile = new SRBFile((SRBFileSystem)object, ((GeneralFileSystem)object).getHomeDirectory(), "temp");
            generalFile.mkdir();
        }
        if (((SRBFile)(object = new SRBFile((SRBFile)generalFile, string + string3 + string2))).createNewFile()) {
            return object;
        }
        throw new IOException("The temp file already exists.");
    }

    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean bl) {
        try {
            String string = this.srbFileSystem.getVersion();
            if (!(bl || string.equals("SRB1.1.8&C") || string.equals("SRB2.0.0&D") || string.equals("SRB-3.0.0&E"))) {
                if (this.isDirectory()) {
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), "", "", "", 176);
                    return true;
                }
                if (this.isFile() && this.getReplicaNumber() < 0) {
                    this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", "", "", 174);
                    return true;
                }
                this.srbFileSystem.srbObjUnlink(this.fileName, this.getParent());
                return true;
            }
            if (this.isFile()) {
                this.srbFileSystem.srbObjUnlink(this.fileName, this.getParent());
                return true;
            }
            if (this.isDirectory()) {
                this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), "", "", "", 31);
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    public void deleteOnExit() {
        this.deleteOnExit = true;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            SRBFile sRBFile = (SRBFile)object;
            return this.getAbsolutePath().equals(sRBFile.getAbsolutePath());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean exists() {
        try {
            MetaDataRecordList[] metaDataRecordListArray = null;
            int n = 0;
            MetaDataCondition[] metaDataConditionArray = null;
            if (this.getReplicaNumber() >= 0) {
                metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                metaDataConditionArray[1] = MetaDataSet.newCondition("file replication enum", n, this.replicaNumber);
            } else {
                metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
            }
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                return true;
            }
            metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getAbsolutePath())};
            metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public GeneralFile getAbsoluteFile() {
        return new SRBFile(this.srbFileSystem, this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            int n2 = 1;
            while (n2 < n) {
                string = string + this.getPathSeparator() + this.directory.get(n2);
                ++n2;
            }
            return string + this.getPathSeparator() + this.getName();
        }
        return this.getName();
    }

    public GeneralFile getCanonicalFile() throws IOException {
        return new SRBFile(this.srbFileSystem, this.getCanonicalPath());
    }

    public String getCanonicalPath() throws IOException {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            int n2 = 1;
            while (n2 < n) {
                string = string + this.getPathSeparator() + this.directory.get(n2);
                ++n2;
            }
            return string + this.getPathSeparator() + this.fileName;
        }
        return this.fileName;
    }

    public String getName() {
        int n = this.fileName.indexOf("&COPY=");
        if (n >= 0) {
            return this.fileName.substring(0, n);
        }
        return this.fileName;
    }

    public String getParent() {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            int n2 = 1;
            while (n2 < n) {
                string = string + this.getPathSeparator() + this.directory.get(n2);
                ++n2;
            }
            return string;
        }
        return null;
    }

    public GeneralFile getParentFile() {
        return new SRBFile(this.srbFileSystem, this.getParent());
    }

    public String getPath() {
        return this.originalFilePath;
    }

    public int hashCode() {
        return this.getAbsolutePath().toLowerCase().hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isDirectory() {
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getAbsolutePath())};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory name")};
        try {
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public boolean isFile() {
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getParent()), MetaDataSet.newCondition("file name", 0, this.getName())};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        try {
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        long[] lArray;
        long l = 0L;
        try {
            lArray = this.getStat();
        }
        catch (IOException iOException) {
            return 0L;
        }
        if (lArray != null) {
            l = lArray[10] * 1000L;
        }
        return l;
    }

    public long length() {
        long[] lArray;
        long l = 0L;
        try {
            lArray = this.getStat();
        }
        catch (IOException iOException) {
            return 0L;
        }
        if (lArray != null) {
            l = lArray[0];
        }
        return l;
    }

    public String[] list() {
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[1];
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataRecordList[] metaDataRecordListArray2 = null;
        MetaDataRecordList[] metaDataRecordListArray3 = null;
        Vector<String> vector = null;
        String string = null;
        try {
            string = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            metaDataConditionArray[0] = MetaDataSet.newCondition("directory name", 0, string);
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
            }
            metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
            metaDataConditionArray[0] = MetaDataSet.newCondition("parent directory name", 0, string);
            metaDataRecordListArray2 = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                metaDataRecordListArray2 = MetaDataRecordList.getAllResults(metaDataRecordListArray2);
            }
            if (metaDataRecordListArray2 != null) {
                String string2 = null;
                String string3 = null;
                int n = 0;
                while (n < metaDataRecordListArray2.length) {
                    string2 = metaDataRecordListArray2[n].getStringValue(0);
                    string3 = string2.substring(string2.lastIndexOf(PATH_SEPARATOR) + 1);
                    metaDataRecordListArray2[n].setValue(0, string3);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (metaDataRecordListArray != null && metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = new SRBMetaDataRecordList[metaDataRecordListArray.length + metaDataRecordListArray2.length];
            System.arraycopy(metaDataRecordListArray, 0, metaDataRecordListArray3, 0, metaDataRecordListArray.length);
            System.arraycopy(metaDataRecordListArray2, 0, metaDataRecordListArray3, metaDataRecordListArray.length, metaDataRecordListArray2.length);
        } else if (metaDataRecordListArray != null) {
            metaDataRecordListArray3 = metaDataRecordListArray;
        } else if (metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = metaDataRecordListArray2;
        } else {
            return new String[0];
        }
        vector = new Vector<String>();
        int n = 0;
        while (n < metaDataRecordListArray3.length) {
            if (metaDataRecordListArray3[n].getStringValue(0) != null) {
                vector.add(metaDataRecordListArray3[n].getStringValue(0));
            }
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public String[] list(MetaDataCondition[] metaDataConditionArray) {
        if (metaDataConditionArray == null) {
            return this.list();
        }
        MetaDataCondition[] metaDataConditionArray2 = null;
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataRecordList[] metaDataRecordListArray2 = null;
        MetaDataRecordList[] metaDataRecordListArray3 = null;
        Vector<String> vector = null;
        String string = null;
        try {
            string = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            metaDataConditionArray2 = MetaDataSet.mergeConditions(MetaDataSet.newCondition("directory name", 0, string), metaDataConditionArray);
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray2, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
            }
            metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
            metaDataConditionArray2 = MetaDataSet.mergeConditions(MetaDataSet.newCondition("parent directory name", 0, string), (MetaDataCondition)null);
            metaDataRecordListArray2 = this.srbFileSystem.query(metaDataConditionArray2, metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
            if (this.completeDirectoryList) {
                metaDataRecordListArray2 = MetaDataRecordList.getAllResults(metaDataRecordListArray2);
            }
            if (metaDataRecordListArray2 != null) {
                String string2 = null;
                String string3 = null;
                int n = 0;
                while (n < metaDataRecordListArray2.length) {
                    string2 = metaDataRecordListArray2[n].getStringValue(0);
                    string3 = string2.substring(string2.lastIndexOf(PATH_SEPARATOR) + 1);
                    metaDataRecordListArray2[n].setValue(0, string3);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (metaDataRecordListArray != null && metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = new SRBMetaDataRecordList[metaDataRecordListArray.length + metaDataRecordListArray2.length];
            System.arraycopy(metaDataRecordListArray, 0, metaDataRecordListArray3, 0, metaDataRecordListArray.length);
            System.arraycopy(metaDataRecordListArray2, 0, metaDataRecordListArray3, metaDataRecordListArray.length, metaDataRecordListArray2.length);
        } else if (metaDataRecordListArray != null) {
            metaDataRecordListArray3 = metaDataRecordListArray;
        } else if (metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = metaDataRecordListArray2;
        } else {
            return new String[0];
        }
        vector = new Vector<String>();
        int n = 0;
        while (n < metaDataRecordListArray3.length) {
            if (metaDataRecordListArray3[n].getStringValue(0) != null) {
                vector.add(metaDataRecordListArray3[n].getStringValue(0));
            }
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public static GeneralFile[] listRoots() {
        GeneralFile[] generalFileArray = new GeneralFile[1];
        try {
            generalFileArray[0] = new SRBFile(new SRBFileSystem(), PATH_SEPARATOR);
        }
        catch (IOException iOException) {}
        return generalFileArray;
    }

    public boolean mkdir() {
        try {
            if (!this.isDirectory()) {
                this.srbFileSystem.srbCreateCollect(this.catalogType, this.getParent(), this.getName());
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public boolean mkdirs() {
        if (!this.isDirectory()) {
            int n = this.directory.size();
            SRBFile sRBFile = new SRBFile(this.srbFileSystem, this.directory.get(0).toString());
            int n2 = 0;
            while (n2 < n) {
                if (!sRBFile.exists()) {
                    sRBFile.mkdir();
                    sRBFile = new SRBFile(sRBFile, this.directory.get(n2).toString());
                }
                ++n2;
            }
            this.mkdir();
            return true;
        }
        return false;
    }

    public boolean renameTo(GeneralFile generalFile) throws IllegalArgumentException {
        if (generalFile instanceof SRBFile) {
            try {
                if (this.isFile()) {
                    if (this.getParent().equals(generalFile.getParent())) {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", generalFile.getName(), "", 29);
                    } else if (this.getName().equals(generalFile.getName())) {
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", generalFile.getParent(), "", 6);
                    } else {
                        String string = generalFile.getName() + (long)Math.random();
                        this.srbFileSystem.srbModifyDataset(this.catalogType, this.fileName, this.getParent(), "", "", string, "", 29);
                        try {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, string, this.getParent(), "", "", generalFile.getParent(), "", 6);
                        }
                        catch (IOException iOException) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, string, this.getParent(), "", "", this.fileName, "", 29);
                        }
                        try {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, string, generalFile.getParent(), "", "", generalFile.getName(), "", 29);
                        }
                        catch (IOException iOException) {
                            this.srbFileSystem.srbModifyDataset(this.catalogType, string, generalFile.getParent(), "", "", this.getParent(), "", 6);
                            this.srbFileSystem.srbModifyDataset(this.catalogType, string, this.getParent(), "", "", this.fileName, "", 29);
                        }
                    }
                    this.directory = new Vector();
                    this.setFileName(generalFile.getAbsolutePath());
                    return true;
                }
                if (this.isDirectory()) {
                    this.srbFileSystem.srbModifyCollect(this.catalogType, this.getAbsolutePath(), generalFile.getAbsolutePath(), null, null, 30);
                    this.directory = new Vector();
                    this.setFileName(generalFile.getAbsolutePath());
                    return true;
                }
                if (!this.exists()) {
                    this.directory = new Vector();
                    this.setFileName(generalFile.getAbsolutePath());
                    return true;
                }
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.copyTo(generalFile, false);
                this.delete();
                this.directory = new Vector();
                this.setFileName(generalFile.getAbsolutePath());
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public boolean setLastModified(long l) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    public URI toURI() {
        URI uRI;
        block3: {
            uRI = null;
            try {
                if (this.isDirectory()) {
                    uRI = new URI("srb", this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName(), this.srbFileSystem.getHost(), this.srbFileSystem.getPort(), this.getAbsolutePath() + PATH_SEPARATOR, "", "");
                    break block3;
                }
                uRI = new URI("srb", this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName(), this.srbFileSystem.getHost(), this.srbFileSystem.getPort(), this.getAbsolutePath(), "", "");
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return uRI;
    }

    public URL toURL() throws MalformedURLException {
        URL uRL = null;
        uRL = this.isDirectory() ? new URL("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath() + PATH_SEPARATOR) : new URL("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath());
        return uRL;
    }

    class RegistrationThread
    implements Runnable {
        String bloadFilePath;
        Object mainThread;
        Vector files = new Vector();
        Vector paths = new Vector();

        RegistrationThread(String string, Object object) throws IOException {
            this.bloadFilePath = string;
            this.mainThread = object;
        }

        void setBloadFilePath(String string) {
            this.bloadFilePath = string;
        }

        void addFile(GeneralFile generalFile, String string) {
            this.files.add(generalFile);
            this.paths.add(string);
        }

        public void run() {
            try {
                this.register();
            }
            catch (IOException iOException) {
                SRBFile.this.bulkLoadException = iOException;
            }
        }

        SRBMetaDataRecordList[] getFileRegistry(int n) throws IOException {
            SRBMetaDataRecordList sRBMetaDataRecordList = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray = new SRBMetaDataRecordList[n];
            GeneralFile generalFile = null;
            Object var5_5 = null;
            Object var6_6 = null;
            Object var7_7 = null;
            String string = null;
            long l = 0L;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                generalFile = (GeneralFile)this.files.get(n3);
                n2 = (int)((long)n2 + l);
                l = generalFile.length();
                string = (String)this.paths.get(n3);
                string = string == null || string.equals("") ? SRBFile.this.getAbsolutePath() : SRBFile.this.getAbsolutePath() + SRBFile.PATH_SEPARATOR + string;
                sRBMetaDataRecordList = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file name"), generalFile.getName());
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("directory name"), string);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("size"), l);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("offset"), n2);
                sRBMetaDataRecordListArray[n3] = sRBMetaDataRecordList;
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                try {
                    this.files.remove(0);
                    this.paths.remove(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n4;
            }
            return sRBMetaDataRecordListArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register() throws IOException {
            int n = this.files.size();
            if (n > 0) {
                SRBFile.this.srbFileSystem.srbBulkLoad(SRBFile.this.catalogType, this.bloadFilePath, this.getFileRegistry(n));
            }
            Object object = this.mainThread;
            synchronized (object) {
                this.mainThread.notify();
            }
        }
    }

    class LoadThread
    implements Runnable {
        GeneralRandomAccessFile[] out;
        byte[] buffer1;
        byte[] buffer2;
        boolean writeBuffer1 = false;
        boolean writeBuffer2 = false;
        int buffer1Length = 0;
        int buffer2Length = 0;
        boolean keepLoading = true;
        Object mainThread;

        LoadThread(GeneralRandomAccessFile[] generalRandomAccessFileArray, byte[] byArray, byte[] byArray2, Object object) {
            this.out = generalRandomAccessFileArray;
            this.buffer1 = byArray;
            this.buffer2 = byArray2;
            this.mainThread = object;
        }

        public void run() {
            try {
                while (this.keepLoading) {
                    this.sendBuffer();
                }
            }
            catch (IOException iOException) {
                SRBFile.this.bulkLoadException = iOException;
            }
        }

        void restartRandomAccessFile(int n, GeneralFile generalFile) throws IOException {
            this.out[n] = FileFactory.newRandomAccessFile(generalFile, "rw");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendBuffer() throws IOException {
            if (this.buffer1Length == 0 && this.buffer2Length == 0) {
                return;
            }
            Object object = this.mainThread;
            synchronized (object) {
                SRBFile.this.loading1 = !SRBFile.this.loading1;
                if (SRBFile.this.loading1) {
                    SRBFile.this.transfer = 1;
                } else {
                    SRBFile.this.transfer = 2;
                }
            }
            if (!SRBFile.this.loading1) {
                this.out[SRBFile.this.activeRegistrationThread].write(this.buffer1, 0, this.buffer1Length);
                this.buffer1Length = 0;
            } else {
                this.out[SRBFile.this.activeRegistrationThread].write(this.buffer2, 0, this.buffer2Length);
                this.buffer2Length = 0;
            }
            Object object2 = this.mainThread;
            synchronized (object2) {
                SRBFile.this.transfer = 0;
                this.mainThread.notify();
            }
        }
    }
}

