/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteRandomAccessFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SRBRandomAccessFile
extends RemoteRandomAccessFile {
    static final int O_RDONLY = 0;
    static final int O_WRONLY = 1;
    static final int O_RDWR = 2;
    static final int O_APPEND = 1024;
    static final int O_SYNC = 4096;
    static final int O_DSYNC = 4096;
    long filePointer = 0L;
    SRBFileSystem fileSystem;

    public SRBRandomAccessFile(SRBFileSystem sRBFileSystem, String string, String string2) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        this(new SRBFile(sRBFileSystem, string), string2);
    }

    public SRBRandomAccessFile(SRBFile sRBFile, String string) throws IllegalArgumentException, FileNotFoundException, SecurityException, IOException {
        super(sRBFile, string);
        this.swapNeeded = false;
        this.open(sRBFile);
        this.setFileSystem(sRBFile.getFileSystem());
    }

    protected void rwCheck(GeneralFile generalFile, String string) throws IllegalArgumentException, SecurityException {
        if ((string = string.toLowerCase()).equals("r")) {
            this.rw = 0;
        } else if (string.equals("rw")) {
            this.rw = 1;
        } else if (string.equals("rws")) {
            this.rw = 2;
        } else if (string.equals("rwd")) {
            this.rw = 3;
        } else {
            throw new IllegalArgumentException("Illegal mode \"" + string + "\" must be one of \"r\", \"rw\", \"rws\", or \"rwd\"");
        }
        if (!((SRBFile)generalFile).canRead("isFile")) {
            throw new SecurityException("Wrong permissions to access this file.");
        }
        if (this.rw > 0 && !((SRBFile)generalFile).canWrite("isFile")) {
            throw new SecurityException("Wrong permissions to access this file.");
        }
    }

    protected void open(GeneralFile generalFile) throws FileNotFoundException, SecurityException, IOException {
        if (this.rw == 0) {
            this.fd = ((SRBFileSystem)generalFile.getFileSystem()).srbObjOpen(generalFile.getName(), 0, generalFile.getParent());
        } else if (this.rw == 1) {
            this.fd = ((SRBFileSystem)generalFile.getFileSystem()).srbObjOpen(generalFile.getName(), 2, generalFile.getParent());
        } else if (this.rw == 2) {
            this.fd = ((SRBFileSystem)generalFile.getFileSystem()).srbObjOpen(generalFile.getName(), 4096, generalFile.getParent());
        } else if (this.rw == 3) {
            this.fd = ((SRBFileSystem)generalFile.getFileSystem()).srbObjOpen(generalFile.getName(), 4096, generalFile.getParent());
        }
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException, ClassCastException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = (SRBFileSystem)generalFileSystem;
    }

    public GeneralFileSystem getFileSystem() {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException();
    }

    public int read() throws IOException {
        byte[] byArray = this.fileSystem.srbObjRead(this.fd, 1);
        if (byArray != null) {
            this.filePointer += (long)byArray.length;
            return byArray[0];
        }
        return -1;
    }

    protected int readBytes(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = null;
        byArray2 = this.fileSystem.srbObjRead(this.fd, n2);
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            this.filePointer += (long)byArray2.length;
            return byArray2.length;
        }
        return 0;
    }

    protected void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.filePointer += (long)this.fileSystem.srbObjWrite(this.fd, byArray2, n2);
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.fileSystem.srbObjSeek(this.fd, l, 0);
        this.filePointer = l;
    }

    public void seek(long l, int n) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.fileSystem.srbObjSeek(this.fd, l, n);
        this.filePointer = l;
    }

    public long length() throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.file.getParent()), MetaDataSet.newCondition("file name", 0, this.file.getName())};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("size")};
        try {
            metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                return Long.parseLong(metaDataRecordListArray[0].getValue("size").toString());
            }
        }
        catch (IOException iOException) {}
        return 0L;
    }

    public void setLength(long l) throws IOException {
        long l2 = this.length();
        if (l > l2) {
            this.seek(l - 1L);
            this.write(0);
        } else if (l < l2) {
            throw new UnsupportedOperationException();
        }
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.srbObjClose(this.fd);
            this.fileSystem = null;
        }
        if (this.fileFormat != null) {
            this.fileFormat = null;
        }
    }

    public String toString() {
        switch (this.rw) {
            case 0: {
                return this.file.getParent() + "/" + this.file.getName() + " : r";
            }
            case 1: {
                return this.file.getParent() + "/" + this.file.getName() + " : rw";
            }
            case 2: {
                return this.file.getParent() + "/" + this.file.getName() + " : rws";
            }
            case 3: {
                return this.file.getParent() + "/" + this.file.getName() + " : rwd";
            }
        }
        return this.file.getParent() + "/" + this.file.getName();
    }
}

