/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;
import uk.ac.starlink.util.Base64InputStream;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.RowStepper;

class BinaryRowStepper
implements RowStepper {
    final PushbackInputStream pstrm;
    final DataInputStream datain;
    final Decoder[] decoders;
    final int ncol;
    boolean closed;

    public BinaryRowStepper(Decoder[] decoders, InputStream istrm, String encoding) throws IOException {
        if ("gzip".equals(encoding)) {
            istrm = new GZIPInputStream(istrm);
        } else if ("base64".equals(encoding)) {
            istrm = new Base64InputStream(istrm);
        }
        this.pstrm = new PushbackInputStream(istrm);
        this.datain = new DataInputStream(this.pstrm);
        this.decoders = decoders;
        this.ncol = decoders.length;
    }

    public BinaryRowStepper(Decoder[] decoders, InputStream istrm) throws IOException {
        this(decoders, istrm, null);
    }

    public Object[] nextRow() throws IOException {
        if (this.closed) {
            return null;
        }
        int b = this.pstrm.read();
        if (b < 0) {
            this.closed = true;
            this.pstrm.close();
            return null;
        }
        this.pstrm.unread(b);
        Object[] row = new Object[this.ncol];
        int icol = 0;
        while (icol < this.ncol) {
            row[icol] = this.decoders[icol].decodeStream(this.datain);
            ++icol;
        }
        return row;
    }
}

