/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.ValuesElement;

public class FieldElement
extends VOElement {
    private final boolean strict_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");
    static final long ASSUMED_ARRAYSIZE = -2L;

    FieldElement(Element base, VODocument doc) {
        super(base, doc);
        this.strict_ = doc.isStrict();
    }

    public long[] getArraysize() {
        int sliceSize = 1;
        String as = this.hasAttribute("datatype") ? this.getAttribute("arraysize") : "*";
        String string = as = as == null ? null : as.trim();
        if (as != null && as.length() > 0) {
            String[] dimtxt = as.split("x");
            int ndim = dimtxt.length;
            long[] arraysize = new long[ndim];
            int i = 0;
            while (i < ndim) {
                if (i == ndim - 1 && dimtxt[i].trim().endsWith("*")) {
                    arraysize[i] = -1L;
                } else {
                    long dim;
                    try {
                        dim = Long.parseLong(dimtxt[i]);
                    }
                    catch (NumberFormatException e) {
                        dim = 1L;
                        logger_.warning("Bad arraysize element " + dimtxt[i] + " - assuming 1");
                    }
                    if (dim <= 0L) {
                        dim = 1L;
                        logger_.warning("Bad arraysize element " + dimtxt[i] + " - assuming 1");
                    }
                    arraysize[i] = dim;
                    sliceSize = (int)((long)sliceSize * arraysize[i]);
                }
                ++i;
            }
            return arraysize;
        }
        return new long[0];
    }

    public String getNull() {
        String blank = null;
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof ValuesElement) {
                ValuesElement vals = (ValuesElement)child;
                if (blank == null || "legal".equals(vals.getType())) {
                    blank = vals.getNull();
                }
            }
            child = child.getNextSibling();
        }
        return blank;
    }

    public String getDatatype() {
        if (this.hasAttribute("datatype")) {
            return this.getAttribute("datatype");
        }
        logger_.warning("Missing datatype attribute for " + this.getHandle() + " - assume char(*)");
        return "char";
    }

    public String getUnit() {
        return this.hasAttribute("unit") ? this.getAttribute("unit") : null;
    }

    public String getUcd() {
        return this.hasAttribute("ucd") ? this.getAttribute("ucd") : null;
    }

    public int getIndexInTable(TableElement table) {
        FieldElement[] fields = table.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ValuesElement getLegalValues() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof ValuesElement && "legal".equals(((ValuesElement)child).getType())) {
                return (ValuesElement)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public ValuesElement getActualValues() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof ValuesElement && "actual".equals(((ValuesElement)child).getType())) {
                return (ValuesElement)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public String toString() {
        String str = this.getHandle();
        StringBuffer sbuf = new StringBuffer(str);
        if (this.hasAttribute("datatype")) {
            sbuf.append(' ').append(this.getAttribute("datatype"));
        }
        if (this.hasAttribute("arraysize")) {
            sbuf.append(" (").append(this.getAttribute("arraysize")).append(")");
        }
        if (this.hasAttribute("units")) {
            sbuf.append(" / " + this.getAttribute("units"));
        }
        return sbuf.toString();
    }

    Decoder getDecoder() {
        String datatype = this.getDatatype();
        long[] arraysize = this.getArraysize();
        String nul = this.getNull();
        if (("char".equals(datatype) || "unicodeChar".equals(datatype)) && arraysize.length == 0) {
            if (this.strict_) {
                logger_.info(this.getHandle() + " - unspecified arraysize implies single" + " character for " + datatype + " datatype (strict)");
            } else {
                arraysize = new long[]{-2L};
                logger_.warning(this.getHandle() + " - assuming unspecified arraysize='*' for " + datatype + " datatype (non-strict)");
            }
        }
        return Decoder.makeDecoder(datatype, arraysize, nul);
    }
}

