/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedDataInputStream;
import org.xml.sax.SAXException;
import uk.ac.starlink.fits.BintableStarTable;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class FitsPlusTableBuilder
implements TableBuilder {
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$votable$FitsPlusTableBuilder;

    public String getFormatName() {
        return "FITS-plus";
    }

    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        if (datsrc.getPosition() != null) {
            throw new TableFormatException("Can't locate numbered HDU");
        }
        if (!FitsPlusTableBuilder.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS-plus file");
        }
        ArrayDataInput strm = FitsConstants.getInputStreamStart((DataSource)datsrc);
        try {
            long[] pos = new long[1];
            TableElement tabel = this.readMetadata(strm, pos);
            StarTable starTable = FitsTableBuilder.attemptReadTable((ArrayDataInput)strm, (boolean)wantRandom, (DataSource)datsrc, (long[])pos);
            if (starTable == null) {
                throw new TableFormatException("No BINTABLE HDU found");
            }
            tabel.setData(new TableBodies.StarTableTabularData(starTable));
            VOStarTable startab = new VOStarTable(tabel);
            return startab;
        }
        catch (FitsException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
        catch (NullPointerException e) {
            throw new TableFormatException("Table not quite in fits-plus format", e);
        }
    }

    public void streamStarTable(InputStream in, final TableSink sink, String pos) throws IOException {
        if (pos != null && pos.trim().length() > 0) {
            throw new TableFormatException("Can't locate numbered HDU");
        }
        BufferedDataInputStream strm = new BufferedDataInputStream(in);
        try {
            try {
                TableElement tabel = this.readMetadata(strm, new long[1]);
                final VOStarTable voMeta = new VOStarTable(tabel);
                TableSink wsink = new TableSink(){

                    public void acceptMetadata(StarTable fitsMeta) throws TableFormatException {
                        sink.acceptMetadata(voMeta);
                    }

                    public void acceptRow(Object[] row) throws IOException {
                        sink.acceptRow(row);
                    }

                    public void endRows() throws IOException {
                        sink.endRows();
                    }
                };
                Header hdr = new Header();
                FitsConstants.readHeader((Header)hdr, (ArrayDataInput)strm);
                BintableStarTable.streamStarTable((Header)hdr, (DataInput)strm, (TableSink)wsink);
            }
            catch (FitsException e) {
                throw new TableFormatException(e.getMessage(), e);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            strm.close();
            throw throwable;
        }
        strm.close();
    }

    private TableElement readMetadata(ArrayDataInput strm, long[] pos) throws IOException {
        byte[] headBuf = new byte[2880];
        strm.readFully(headBuf);
        if (!FitsPlusTableBuilder.isMagic(headBuf)) {
            throw new TableFormatException("Primary header not FITS-plus");
        }
        try {
            Header hdr = new Header();
            BufferedDataInputStream hstrm = new BufferedDataInputStream(new ByteArrayInputStream(headBuf));
            int headsize = FitsConstants.readHeader((Header)hdr, (ArrayDataInput)hstrm);
            int datasize = (int)FitsConstants.getDataSize((Header)hdr);
            pos[0] = headsize + datasize;
            if (!$assertionsDisabled && headsize != 2880) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hdr.getIntValue("NAXIS") != 1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hdr.getIntValue("BITPIX") != 8) {
                throw new AssertionError();
            }
            int nbyte = hdr.getIntValue("NAXIS1");
            byte[] vobuf = new byte[nbyte];
            strm.readFully(vobuf);
            int pad = datasize - nbyte;
            IOUtils.skipBytes(strm, pad);
            VOElementFactory vofact = new VOElementFactory();
            DOMSource domsrc = vofact.transformToDOM(new StreamSource(new ByteArrayInputStream(vobuf)), false);
            VODocument doc = (VODocument)domsrc.getNode();
            VOElement topel = (VOElement)doc.getDocumentElement();
            VOElement resel = topel.getChildByName("RESOURCE");
            if (resel == null) {
                throw new TableFormatException("Embedded VOTable document has no RESOURCE element");
            }
            TableElement tabel = (TableElement)resel.getChildByName("TABLE");
            if (tabel == null) {
                throw new TableFormatException("Embedded VOTable document has no TABLE element");
            }
            if (tabel.getChildByName("DATA") != null) {
                throw new TableFormatException("Embedded VOTable document has unexpected DATA element");
            }
            return tabel;
        }
        catch (FitsException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
    }

    public boolean canImport(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("fits");
    }

    public static boolean isMagic(byte[] buffer) {
        int ntest = 5;
        HeaderCard[] cards = new HeaderCard[5];
        int pos = 0;
        boolean ncard = false;
        boolean ok = true;
        int il = 0;
        while (ok && il < 5) {
            if (buffer.length > pos + 80) {
                char[] cbuf = new char[80];
                int ic = 0;
                while (ic < 80) {
                    cbuf[ic] = (char)(buffer[pos++] & 0xFF);
                    ++ic;
                }
                try {
                    HeaderCard card = new HeaderCard(new String(cbuf));
                    ok = ok && FitsPlusTableBuilder.cardOK(il, card);
                }
                catch (FitsException e) {
                    ok = false;
                }
            }
            ++il;
        }
        return ok;
    }

    private static boolean cardOK(int icard, HeaderCard card) throws FitsException {
        String key = card.getKey();
        String value = card.getValue();
        switch (icard) {
            case 0: {
                return "SIMPLE".equals(key) && "T".equals(value);
            }
            case 1: {
                return "BITPIX".equals(key) && "8".equals(value);
            }
            case 2: {
                return "NAXIS".equals(key) && "1".equals(value);
            }
            case 3: {
                return "NAXIS1".equals(key);
            }
            case 4: {
                return "VOTMETA".equals(key);
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$votable$FitsPlusTableBuilder == null ? (class$uk$ac$starlink$votable$FitsPlusTableBuilder = FitsPlusTableBuilder.class$("uk.ac.starlink.votable.FitsPlusTableBuilder")) : class$uk$ac$starlink$votable$FitsPlusTableBuilder).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.votable");
    }
}

