/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.FitsPlusTableBuilder;
import uk.ac.starlink.votable.VOSerializer;

public class FitsPlusTableWriter
extends FitsTableWriter {
    private static String XML_ENCODING;
    private static Logger logger;
    private String formatName_ = "fits-plus";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$votable$FitsPlusTableWriter;

    public String getFormatName() {
        return this.formatName_;
    }

    public boolean looksLikeFile(String location) {
        String exten;
        int dotPos = location.lastIndexOf(46);
        return dotPos > 0 && (exten = location.substring(dotPos + 1).toLowerCase()).startsWith("fit");
    }

    protected void writePrimary(StarTable table, DataOutputStream strm) throws IOException {
        Exception thrown = null;
        try {
            this.writeVOTablePrimary(table, strm);
            return;
        }
        catch (IOException e) {
            thrown = e;
        }
        catch (FitsException e) {
            thrown = e;
        }
        if (thrown != null) {
            logger.log(Level.WARNING, "Failed to write VOTable metadata to primary HDU", thrown);
        }
        super.writePrimary(table, strm);
    }

    private void writeVOTablePrimary(StarTable table, DataOutputStream strm) throws IOException, FitsException {
        long nrow;
        VOSerializer voser = VOSerializer.makeSerializer(DataFormat.FITS, table);
        StringWriter textWriter = new StringWriter();
        BufferedWriter writer = new BufferedWriter(textWriter);
        writer.write("<?xml version='1.0' encoding='" + XML_ENCODING + "'?>");
        writer.newLine();
        writer.write("<VOTABLE version='1.1'>");
        writer.newLine();
        writer.write("<!--");
        writer.newLine();
        writer.write(" !  VOTable written by " + VOSerializer.formatText(((Object)((Object)this)).getClass().getName()));
        writer.newLine();
        writer.write(" !  Describes BINTABLE extension in following HDU");
        writer.newLine();
        writer.write(" !-->");
        writer.newLine();
        writer.write("<RESOURCE>");
        writer.newLine();
        voser.writeDescription(writer);
        voser.writeParams(writer);
        writer.write("<TABLE");
        String tname = table.getName();
        if (tname != null && tname.trim().length() > 0) {
            writer.write(VOSerializer.formatAttribute("name", tname.trim()));
        }
        if ((nrow = table.getRowCount()) > 0L) {
            writer.write(VOSerializer.formatAttribute("nrows", Long.toString(nrow)));
        }
        writer.write(">");
        writer.newLine();
        voser.writeFields(writer);
        writer.write("<!-- Dummy VOTable - no DATA element -->");
        writer.newLine();
        writer.write("</TABLE>");
        writer.newLine();
        writer.write("</RESOURCE>");
        writer.newLine();
        writer.write("</VOTABLE>");
        writer.flush();
        byte[] textBytes = textWriter.getBuffer().toString().getBytes(XML_ENCODING);
        int nbyte = textBytes.length;
        Header hdr = new Header();
        hdr.addValue("SIMPLE", true, "Standard FITS format");
        hdr.addValue("BITPIX", 8L, "Character data");
        hdr.addValue("NAXIS", 1L, "Text string");
        hdr.addValue("NAXIS1", nbyte, "Number of characters");
        hdr.addValue("VOTMETA", true, "Table metadata in VOTABLE format");
        hdr.addValue("EXTEND", true, "There are standard extensions");
        String[] comments = new String[]{" ", "This header consists of bytes which comprise a VOTABLE document.", "The VOTable describes the metadata of the table contained", "in the following BINTABLE extension.", "The BINTABLE extension can be used on its own as a perfectly", "good table, but the information from this HDU may provide some", "useful additional metadata."};
        int i = 0;
        while (i < comments.length) {
            hdr.insertComment(comments[i]);
            ++i;
        }
        hdr.insertCommentStyle("END", "");
        if (!$assertionsDisabled && !FitsPlusTableWriter.headerOK(hdr)) {
            throw new AssertionError();
        }
        FitsConstants.writeHeader((DataOutput)strm, (Header)hdr);
        strm.write(textBytes);
        int partial = textBytes.length % 2880;
        if (partial > 0) {
            int pad = 2880 - partial;
            strm.write(new byte[pad]);
        }
    }

    public static StarTableWriter[] getStarTableWriters() {
        FitsPlusTableWriter w1 = new FitsPlusTableWriter();
        FitsPlusTableWriter w2 = new FitsPlusTableWriter();
        w1.formatName_ = "fits";
        return new StarTableWriter[]{w1, w2};
    }

    private static boolean headerOK(Header hdr) {
        boolean ok = true;
        ByteArrayOutputStream bstrm = new ByteArrayOutputStream();
        Cursor it = hdr.iterator();
        while (it.hasNext()) {
            String card = ((HeaderCard)it.next()).toString();
            ok = ok && card.length() == 80;
            int i = 0;
            while (i < card.length()) {
                bstrm.write((byte)card.charAt(i));
                ++i;
            }
        }
        return ok && FitsPlusTableBuilder.isMagic(bstrm.toByteArray());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$votable$FitsPlusTableWriter == null ? (class$uk$ac$starlink$votable$FitsPlusTableWriter = FitsPlusTableWriter.class$("uk.ac.starlink.votable.FitsPlusTableWriter")) : class$uk$ac$starlink$votable$FitsPlusTableWriter).desiredAssertionStatus();
        XML_ENCODING = "UTF-8";
        logger = Logger.getLogger("uk.ac.starlink.table.formats");
    }
}

