/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.util.Base64OutputStream;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.Encoder;

public abstract class VOSerializer {
    final StarTable table;
    private final DataFormat format;
    static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;

    private VOSerializer(StarTable table, DataFormat format) {
        this.table = table;
        this.format = format;
    }

    public DataFormat getFormat() {
        return this.format;
    }

    public StarTable getTable() {
        return this.table;
    }

    public abstract void writeFields(BufferedWriter var1) throws IOException;

    public abstract void writeInlineDataElement(BufferedWriter var1) throws IOException;

    public abstract void writeHrefDataElement(BufferedWriter var1, String var2, DataOutput var3) throws IOException;

    public void writeInlineTableElement(BufferedWriter writer) throws IOException {
        this.writePreDataXML(writer);
        this.writeInlineDataElement(writer);
        this.writePostDataXML(writer);
    }

    public void writeHrefTableElement(BufferedWriter xmlwriter, String href, DataOutput streamout) throws IOException {
        this.writePreDataXML(xmlwriter);
        this.writeHrefDataElement(xmlwriter, href, streamout);
        this.writePostDataXML(xmlwriter);
    }

    public void writeParams(BufferedWriter writer) throws IOException {
        Iterator it = this.table.getParameters().iterator();
        while (it.hasNext()) {
            DescribedValue param = (DescribedValue)it.next();
            ValueInfo pinfo = param.getInfo();
            if (pinfo.getName().equalsIgnoreCase("description")) continue;
            Encoder encoder = Encoder.getEncoder(pinfo);
            if (encoder != null) {
                String valtext = encoder.encodeAsText(param.getValue());
                String content = encoder.getFieldContent();
                writer.write("<PARAM");
                writer.write(VOSerializer.formatAttributes(encoder.getFieldAttributes()));
                writer.write(VOSerializer.formatAttribute("value", valtext));
                if (content.length() > 0) {
                    writer.write(">");
                    writer.newLine();
                    writer.write(content);
                    writer.newLine();
                    writer.write("</PARAM>");
                } else {
                    writer.write("/>");
                }
                writer.newLine();
                continue;
            }
            if (param.getValue() instanceof URL) {
                writer.write("<LINK" + VOSerializer.formatAttribute("title", pinfo.getName()) + VOSerializer.formatAttribute("href", param.getValue().toString()) + ">");
                writer.newLine();
                continue;
            }
            Object value = param.getValue();
            writer.write("<INFO");
            writer.write(VOSerializer.formatAttribute("name", pinfo.getName()));
            if (value != null) {
                writer.write(VOSerializer.formatAttribute("value", value.toString()));
            }
            writer.write("/>");
            writer.newLine();
        }
    }

    public void writeDescription(BufferedWriter writer) throws IOException {
        String description = null;
        Iterator it = this.table.getParameters().iterator();
        while (it.hasNext()) {
            Object value;
            DescribedValue dval = (DescribedValue)it.next();
            if (!dval.getInfo().getName().equalsIgnoreCase("description") || !((value = dval.getValue()) instanceof String) || ((String)value).trim().length() <= 0) continue;
            description = (String)value;
            break;
        }
        if (description != null) {
            writer.write("<DESCRIPTION>");
            writer.newLine();
            writer.write(VOSerializer.formatText(description.trim()));
            writer.newLine();
            writer.write("</DESCRIPTION>");
            writer.newLine();
        }
    }

    void writePreDataXML(BufferedWriter writer) throws IOException {
        long nrow;
        writer.write("<TABLE");
        String tname = this.table.getName();
        if (tname != null && tname.trim().length() > 0) {
            writer.write(VOSerializer.formatAttribute("name", tname.trim()));
        }
        if ((nrow = this.table.getRowCount()) > 0L) {
            writer.write(VOSerializer.formatAttribute("nrows", Long.toString(nrow)));
        }
        writer.write(">");
        writer.newLine();
        this.writeDescription(writer);
        this.writeParams(writer);
        this.writeFields(writer);
    }

    void writePostDataXML(BufferedWriter writer) throws IOException {
        writer.write("</TABLE>");
        writer.newLine();
    }

    public static String formatAttribute(String name, String value) {
        return ' ' + name + '=' + '\"' + value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;") + '\"';
    }

    public static String formatText(String text) {
        int leng = text.length();
        StringBuffer sbuf = new StringBuffer(leng);
        int i = 0;
        while (i < leng) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sbuf.append("&lt;");
                    break;
                }
                case '>': {
                    sbuf.append("&gt;");
                    break;
                }
                case '&': {
                    sbuf.append("&amp;");
                    break;
                }
                default: {
                    sbuf.append(c);
                }
            }
            ++i;
        }
        return sbuf.toString();
    }

    private static String formatAttributes(Map atts) {
        StringBuffer sbuf = new StringBuffer();
        Iterator it = new TreeSet(atts.keySet()).iterator();
        while (it.hasNext()) {
            String attname = (String)it.next();
            String attval = (String)atts.get(attname);
            sbuf.append(VOSerializer.formatAttribute(attname, attval));
        }
        return sbuf.toString();
    }

    private static void writeFieldElement(BufferedWriter writer, String content, Map attributes) throws IOException {
        writer.write("<FIELD" + VOSerializer.formatAttributes(attributes));
        if (content != null && content.length() > 0) {
            writer.write(62);
            writer.newLine();
            writer.write(content);
            writer.newLine();
            writer.write("</FIELD>");
        } else {
            writer.write("/>");
        }
        writer.newLine();
    }

    public static VOSerializer makeSerializer(DataFormat dataFormat, StarTable table) throws IOException {
        ValueInfo badKey = Tables.NULL_VALUE_INFO;
        int ncol = table.getColumnCount();
        final ColumnInfo[] colInfos = new ColumnInfo[ncol];
        int modified = 0;
        int icol = 0;
        while (icol < ncol) {
            Number badValue;
            ColumnInfo cinfo = new ColumnInfo(table.getColumnInfo(icol));
            Class clazz = cinfo.getContentClass();
            if (cinfo.isNullable() && (class$java$lang$Number == null ? VOSerializer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz) && cinfo.getAuxDatum(badKey) == null && (badValue = clazz == (class$java$lang$Byte == null ? VOSerializer.class$("java.lang.Byte") : class$java$lang$Byte) || clazz == (class$java$lang$Short == null ? VOSerializer.class$("java.lang.Short") : class$java$lang$Short) ? (Number)new Short(Short.MIN_VALUE) : (Number)(clazz == (class$java$lang$Integer == null ? VOSerializer.class$("java.lang.Integer") : class$java$lang$Integer) ? (Number)new Integer(Integer.MIN_VALUE) : (Number)(clazz == (class$java$lang$Long == null ? VOSerializer.class$("java.lang.Long") : class$java$lang$Long) ? new Long(Long.MIN_VALUE) : null))) != null) {
                ++modified;
                cinfo.getAuxData().add(new DescribedValue(badKey, badValue));
            }
            colInfos[icol] = cinfo;
            ++icol;
        }
        if (modified > 0) {
            table = new WrapperStarTable(table){

                public ColumnInfo getColumnInfo(int icol) {
                    return colInfos[icol];
                }
            };
        }
        if (dataFormat == DataFormat.TABLEDATA) {
            return new TabledataVOSerializer(table);
        }
        if (dataFormat == DataFormat.FITS) {
            return new FITSVOSerializer(table);
        }
        if (dataFormat == DataFormat.BINARY) {
            return new BinaryVOSerializer(table);
        }
        throw new AssertionError((Object)("No such format " + dataFormat.toString()));
    }

    private static Encoder[] getEncoders(StarTable table) {
        int ncol = table.getColumnCount();
        Encoder[] encoders = new Encoder[ncol];
        int icol = 0;
        while (icol < ncol) {
            ColumnInfo info = table.getColumnInfo(icol);
            encoders[icol] = Encoder.getEncoder(info);
            if (encoders[icol] == null) {
                logger.warning("Can't serialize column " + info + " of type " + info.getContentClass().getName());
            }
            ++icol;
        }
        return encoders;
    }

    private static void outputFields(Encoder[] encoders, StarTable table, BufferedWriter writer) throws IOException {
        int ncol = encoders.length;
        int icol = 0;
        while (icol < ncol) {
            Encoder encoder = encoders[icol];
            if (encoder != null) {
                String content = encoder.getFieldContent();
                Map atts = encoder.getFieldAttributes();
                VOSerializer.writeFieldElement(writer, content, atts);
            } else {
                writer.write("<!-- Omitted column " + table.getColumnInfo(icol) + " -->");
                writer.newLine();
            }
            ++icol;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WriterOutputStream
    extends OutputStream {
        Writer writer;
        static final int BUFLENG = 10240;
        char[] mainBuf = new char[10240];

        WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        public void close() throws IOException {
            this.writer.close();
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            char[] buf = len <= 10240 ? this.mainBuf : new char[len];
            int i = 0;
            while (i < len) {
                buf[i] = (char)b[off++];
                ++i;
            }
            this.writer.write(buf, 0, len);
        }

        public void write(int b) throws IOException {
            this.writer.write(b);
        }
    }

    private static class FITSVOSerializer
    extends StreamableVOSerializer {
        private final FitsTableSerializer fitser;

        FITSVOSerializer(StarTable table) throws IOException {
            super(table, DataFormat.FITS, "FITS");
            this.fitser = new FitsTableSerializer(table);
        }

        public void writeFields(BufferedWriter writer) throws IOException {
            int ncol = this.table.getColumnCount();
            int icol = 0;
            while (icol < ncol) {
                char tform = this.fitser.getFormatChar(icol);
                int[] dims = this.fitser.getDimensions(icol);
                if (dims != null) {
                    String datatype;
                    Encoder encoder = Encoder.getEncoder(this.table.getColumnInfo(icol));
                    String content = encoder.getFieldContent();
                    Map atts = encoder.getFieldAttributes();
                    switch (tform) {
                        case 'L': {
                            datatype = "boolean";
                            break;
                        }
                        case 'X': {
                            datatype = "bit";
                            break;
                        }
                        case 'B': {
                            datatype = "unsignedByte";
                            break;
                        }
                        case 'I': {
                            datatype = "short";
                            break;
                        }
                        case 'J': {
                            datatype = "int";
                            break;
                        }
                        case 'K': {
                            datatype = "long";
                            break;
                        }
                        case 'A': {
                            datatype = "char";
                            break;
                        }
                        case 'E': {
                            datatype = "float";
                            break;
                        }
                        case 'D': {
                            datatype = "double";
                            break;
                        }
                        case 'C': {
                            datatype = "floatComplex";
                            break;
                        }
                        case 'M': {
                            datatype = "doubleComplex";
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown format letter " + tform));
                        }
                    }
                    atts.put("datatype", datatype);
                    if (dims.length == 0) {
                        if (!"1".equals(atts.get("arraysize"))) {
                            atts.remove("arraysize");
                        }
                    } else {
                        StringBuffer arraysize = new StringBuffer();
                        int i = 0;
                        while (i < dims.length) {
                            if (i > 0) {
                                arraysize.append('x');
                            }
                            arraysize.append(dims[i]);
                            ++i;
                        }
                        atts.put("arraysize", arraysize.toString());
                    }
                    VOSerializer.writeFieldElement(writer, content, atts);
                } else {
                    writer.write("<!-- Omitted column " + this.table.getColumnInfo(icol) + " -->");
                    writer.newLine();
                }
                ++icol;
            }
        }

        public void streamData(DataOutput out) throws IOException {
            FitsConstants.writeEmptyPrimary((DataOutput)out);
            this.fitser.writeHeader(out);
            this.fitser.writeData(out);
        }
    }

    private static class BinaryVOSerializer
    extends StreamableVOSerializer {
        private final Encoder[] encoders;

        BinaryVOSerializer(StarTable table) {
            super(table, DataFormat.BINARY, "BINARY");
            this.encoders = VOSerializer.getEncoders(table);
        }

        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.table, writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamData(DataOutput out) throws IOException {
            int ncol = this.encoders.length;
            RowSequence rseq = this.table.getRowSequence();
            try {
                while (rseq.next()) {
                    Object[] row = rseq.getRow();
                    int icol = 0;
                    while (icol < ncol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder != null) {
                            encoder.encodeToStream(row[icol], out);
                        }
                        ++icol;
                    }
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                rseq.close();
                throw throwable;
            }
            rseq.close();
        }
    }

    static abstract class StreamableVOSerializer
    extends VOSerializer {
        private final String tagname;

        private StreamableVOSerializer(StarTable table, DataFormat format, String tagname) {
            super(table, format);
            this.tagname = tagname;
        }

        public abstract void streamData(DataOutput var1) throws IOException;

        public void writeInlineDataElement(BufferedWriter writer) throws IOException {
            writer.write("<DATA>");
            writer.newLine();
            writer.write("<" + this.tagname + ">");
            writer.newLine();
            writer.write("<STREAM encoding='base64'>");
            writer.newLine();
            Base64OutputStream b64out = new Base64OutputStream(new WriterOutputStream(writer), 16);
            DataOutputStream dataout = new DataOutputStream(b64out);
            this.streamData(dataout);
            dataout.flush();
            b64out.endBase64();
            writer.write("</STREAM>");
            writer.newLine();
            writer.write("</" + this.tagname + ">");
            writer.newLine();
            writer.write("</DATA>");
            writer.newLine();
        }

        public void writeHrefDataElement(BufferedWriter xmlwriter, String href, DataOutput streamout) throws IOException {
            xmlwriter.write("<DATA>");
            xmlwriter.newLine();
            xmlwriter.write('<' + this.tagname + '>');
            xmlwriter.newLine();
            xmlwriter.write("<STREAM" + VOSerializer.formatAttribute("href", href) + "/>");
            xmlwriter.newLine();
            xmlwriter.write("</" + this.tagname + ">");
            xmlwriter.newLine();
            xmlwriter.write("</DATA>");
            xmlwriter.newLine();
            this.streamData(streamout);
        }
    }

    private static class TabledataVOSerializer
    extends VOSerializer {
        private final Encoder[] encoders;

        TabledataVOSerializer(StarTable table) {
            super(table, DataFormat.TABLEDATA);
            this.encoders = VOSerializer.getEncoders(table);
        }

        public void writeFields(BufferedWriter writer) throws IOException {
            VOSerializer.outputFields(this.encoders, this.table, writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeInlineDataElement(BufferedWriter writer) throws IOException {
            writer.write("<DATA>");
            writer.newLine();
            writer.write("<TABLEDATA>");
            writer.newLine();
            int ncol = this.encoders.length;
            RowSequence rseq = this.table.getRowSequence();
            try {
                while (rseq.next()) {
                    writer.write("  <TR>");
                    writer.newLine();
                    Object[] rowdata = rseq.getRow();
                    int icol = 0;
                    while (icol < ncol) {
                        Encoder encoder = this.encoders[icol];
                        if (encoder != null) {
                            String text = encoder.encodeAsText(rowdata[icol]);
                            writer.write("    <TD>");
                            writer.write(VOSerializer.formatText(text));
                            writer.write("</TD>");
                            writer.newLine();
                        }
                        ++icol;
                    }
                    writer.write("  </TR>");
                    writer.newLine();
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                rseq.close();
                throw throwable;
            }
            rseq.close();
            writer.write("</TABLEDATA>");
            writer.newLine();
            writer.write("</DATA>");
            writer.newLine();
            writer.flush();
        }

        public void writeHrefDataElement(BufferedWriter writer, String href, DataOutput streamout) {
            throw new UnsupportedOperationException("TABLEDATA only supports inline output");
        }
    }
}

