/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ReaderRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.URLValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.LinkElement;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.RowStepper;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TabularData;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;

public class VOStarTable
extends AbstractStarTable {
    private TableElement votable;
    private TabularData tdata;
    private ColumnInfo[] colinfos;
    private boolean doneParams;
    private static final ValueInfo ucdInfo = new DefaultValueInfo("UCD", class$java$lang$String == null ? (class$java$lang$String = VOStarTable.class$("java.lang.String")) : class$java$lang$String, "Table UCD");
    public static final ValueInfo ID_INFO = new DefaultValueInfo("VOTable ID", class$java$lang$String == null ? (class$java$lang$String = VOStarTable.class$("java.lang.String")) : class$java$lang$String, "VOTable ID attribute");
    public static final ValueInfo UTYPE_INFO = new DefaultValueInfo("utype", class$java$lang$String == null ? (class$java$lang$String = VOStarTable.class$("java.lang.String")) : class$java$lang$String, "Usage-specific type (ties value to an external data model)");
    public static final ValueInfo WIDTH_INFO = new DefaultValueInfo("VOTable width", class$java$lang$Integer == null ? (class$java$lang$Integer = VOStarTable.class$("java.lang.Integer")) : class$java$lang$Integer, "VOTable width attribute");
    public static final ValueInfo PRECISION_INFO = new DefaultValueInfo("VOTable precision", class$java$lang$String == null ? (class$java$lang$String = VOStarTable.class$("java.lang.String")) : class$java$lang$String, "VOTable precision attribute");
    public static final ValueInfo TYPE_INFO = new DefaultValueInfo("Type", class$java$lang$String == null ? (class$java$lang$String = VOStarTable.class$("java.lang.String")) : class$java$lang$String, "VOTable type attribute");
    private static final ValueInfo datatypeInfo = new DefaultValueInfo("Datatype", class$java$lang$String == null ? (class$java$lang$String = VOStarTable.class$("java.lang.String")) : class$java$lang$String, "VOTable data type name");
    private static final ValueInfo nullInfo = Tables.NULL_VALUE_INFO;
    private static final List auxDataInfos = Arrays.asList(ID_INFO, datatypeInfo, nullInfo, UTYPE_INFO, WIDTH_INFO, PRECISION_INFO, TYPE_INFO);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;

    public VOStarTable(TableElement votable) throws IOException {
        this(votable, votable.getData());
    }

    VOStarTable(TableElement votable, TabularData tdata) {
        this.votable = votable;
        this.tdata = tdata;
        this.setName(VOStarTable.calculateName(votable));
    }

    public int getColumnCount() {
        return this.tdata.getColumnCount();
    }

    public long getRowCount() {
        return this.votable.getNrows();
    }

    public boolean isRandom() {
        return this.tdata.isRandom();
    }

    public ColumnInfo getColumnInfo(int icol) {
        if (this.colinfos == null) {
            FieldElement[] fields = this.votable.getFields();
            int ncol = fields.length;
            this.colinfos = new ColumnInfo[ncol];
            int i = 0;
            while (i < ncol) {
                String blankstr;
                FieldElement field = fields[i];
                ColumnInfo cinfo = new ColumnInfo(VOStarTable.getValueInfo(field));
                List auxdata = cinfo.getAuxData();
                if (field.hasAttribute("ID")) {
                    String id = field.getAttribute("ID");
                    auxdata.add(new DescribedValue(ID_INFO, id));
                }
                if (field.hasAttribute("datatype")) {
                    String datatype = field.getAttribute("datatype");
                    auxdata.add(new DescribedValue(datatypeInfo, datatype));
                }
                if ((blankstr = field.getNull()) != null) {
                    Object blank = blankstr;
                    try {
                        Class clazz = cinfo.getContentClass();
                        if (clazz == (class$java$lang$Byte == null ? VOStarTable.class$("java.lang.Byte") : class$java$lang$Byte)) {
                            blank = Byte.valueOf(blankstr);
                        } else if (clazz == (class$java$lang$Short == null ? VOStarTable.class$("java.lang.Short") : class$java$lang$Short)) {
                            blank = Short.valueOf(blankstr);
                        } else if (clazz == (class$java$lang$Integer == null ? VOStarTable.class$("java.lang.Integer") : class$java$lang$Integer)) {
                            blank = Integer.valueOf(blankstr);
                        } else if (clazz == (class$java$lang$Long == null ? VOStarTable.class$("java.lang.Long") : class$java$lang$Long)) {
                            blank = Long.valueOf(blankstr);
                        }
                    }
                    catch (NumberFormatException e) {
                        blank = blankstr;
                    }
                    auxdata.add(new DescribedValue(nullInfo, blank));
                }
                if (field.hasAttribute("width")) {
                    String width = field.getAttribute("width");
                    try {
                        int wv = Integer.parseInt(width);
                        auxdata.add(new DescribedValue(WIDTH_INFO, new Integer(wv)));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (field.hasAttribute("precision")) {
                    String precision = field.getAttribute("precision");
                    auxdata.add(new DescribedValue(PRECISION_INFO, precision));
                }
                if (field.hasAttribute("type")) {
                    String type = field.getAttribute("type");
                    auxdata.add(new DescribedValue(TYPE_INFO, type));
                }
                if (field.hasAttribute("utype")) {
                    String utype = field.getAttribute("utype");
                    auxdata.add(new DescribedValue(UTYPE_INFO, utype));
                }
                VOElement[] links = field.getChildrenByName("LINK");
                int j = 0;
                while (j < links.length) {
                    auxdata.add(VOStarTable.getDescribedValue((LinkElement)links[j]));
                    ++j;
                }
                this.colinfos[i] = cinfo;
                ++i;
            }
        }
        return this.colinfos[icol];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getParameters() {
        if (!this.doneParams) {
            int i;
            VOElement parent;
            DescribedValue dval;
            ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
            String description = this.votable.getDescription();
            if (description != null) {
                DefaultValueInfo descInfo = new DefaultValueInfo("Description", class$java$lang$String == null ? (class$java$lang$String = VOStarTable.class$("java.lang.String")) : class$java$lang$String);
                params.add(new DescribedValue(descInfo, description));
            }
            if (this.votable.hasAttribute("ucd")) {
                dval = new DescribedValue(ucdInfo, this.votable.getAttribute("ucd"));
                params.add(dval);
            }
            if (this.votable.hasAttribute("utype")) {
                dval = new DescribedValue(UTYPE_INFO, this.votable.getAttribute("utype"));
                params.add(dval);
            }
            if ((parent = this.votable.getParent()) != null && parent.getTagName().equals("RESOURCE")) {
                VOElement[] paramels = parent.getChildrenByName("PARAM");
                i = 0;
                while (i < paramels.length) {
                    ParamElement pel = (ParamElement)paramels[i];
                    DescribedValue dval2 = new DescribedValue(VOStarTable.getValueInfo(pel), pel.getObject());
                    params.add(dval2);
                    ++i;
                }
                VOElement[] linkels = parent.getChildrenByName("LINK");
                int i2 = 0;
                while (i2 < linkels.length) {
                    params.add(VOStarTable.getDescribedValue((LinkElement)linkels[i2]));
                    ++i2;
                }
                VOElement[] infoels = parent.getChildrenByName("INFO");
                int i3 = 0;
                while (i3 < infoels.length) {
                    VOElement iel = infoels[i3];
                    String content = DOMUtils.getTextContent(iel);
                    String descrip = content != null && content.trim().length() > 0 ? content : null;
                    DefaultValueInfo info = new DefaultValueInfo(iel.getHandle(), class$java$lang$String == null ? VOStarTable.class$("java.lang.String") : class$java$lang$String, descrip);
                    DescribedValue dval3 = new DescribedValue(info, iel.getAttribute("value"));
                    params.add(dval3);
                    ++i3;
                }
            }
            ParamElement[] pels = this.votable.getParams();
            i = 0;
            while (i < pels.length) {
                params.add(new DescribedValue(VOStarTable.getValueInfo(pels[i]), pels[i].getObject()));
                ++i;
            }
            VOStarTable vOStarTable = this;
            synchronized (vOStarTable) {
                if (!this.doneParams) {
                    super.getParameters().addAll(params);
                    this.doneParams = true;
                }
            }
        }
        return super.getParameters();
    }

    public List getColumnAuxDataInfos() {
        return auxDataInfos;
    }

    public RowSequence getRowSequence() throws IOException {
        final RowStepper rstep = this.tdata.getRowStepper();
        return new ReaderRowSequence(){

            protected Object[] readRow() throws IOException {
                return rstep.nextRow();
            }
        };
    }

    public Object[] getRow(long lrow) throws IOException {
        if (this.isRandom()) {
            return this.tdata.getRow(lrow);
        }
        throw new UnsupportedOperationException();
    }

    public Object getCell(long lrow, int icol) throws IOException {
        if (this.isRandom()) {
            return this.tdata.getCell(lrow, icol);
        }
        throw new UnsupportedOperationException();
    }

    private static String calculateName(TableElement table) {
        if (table.getName() != null) {
            return table.getName();
        }
        String sysid = ((VODocument)table.getOwnerDocument()).getSystemId();
        if (sysid != null) {
            int sindex = sysid.lastIndexOf(47);
            if (sindex < 0 || sindex == sysid.length() - 1) {
                sindex = sysid.lastIndexOf(92);
            }
            if (sindex > 0 && sindex < sysid.length() - 1) {
                sysid = sysid.substring(sindex + 1);
            }
        }
        Element top = table.getOwnerDocument().getDocumentElement();
        NodeList tables = top.getElementsByTagName("TABLE");
        int index = 0;
        int ntab = tables.getLength();
        if (ntab > 1) {
            int i = 0;
            while (i < ntab) {
                if (tables.item(i) == table) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
        }
        if (index == 0) {
            return sysid == null ? "votable" : sysid;
        }
        return (sysid == null ? "" : sysid) + "#" + index;
    }

    public static ValueInfo getValueInfo(FieldElement field) {
        Decoder decoder = field.getDecoder();
        Class clazz = decoder.getContentClass();
        String name = field.getHandle();
        long[] shapel = decoder.getDecodedShape();
        DefaultValueInfo info = new DefaultValueInfo(name, clazz);
        info.setDescription(field.getDescription());
        info.setUnitString(field.getUnit());
        info.setUCD(field.getUcd());
        info.setShape(shapel == null || shapel.length == 0 ? null : Decoder.longsToInts(shapel));
        info.setElementSize(decoder.getElementSize());
        return info;
    }

    static DescribedValue getDescribedValue(LinkElement link) {
        try {
            URL url = link.getHref();
            URLValueInfo vinfo = new URLValueInfo(link.getHandle(), link.getDescription());
            return new DescribedValue(vinfo, url);
        }
        catch (MalformedURLException e) {
            String href = link.getAttribute("href");
            DefaultValueInfo vinfo = new DefaultValueInfo(link.getHandle(), class$java$lang$String == null ? (class$java$lang$String = VOStarTable.class$("java.lang.String")) : class$java$lang$String, link.getDescription());
            return new DescribedValue(vinfo, href);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

