/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TableStreamer;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class VOTableBuilder
implements TableBuilder {
    private boolean strict_;
    private static Pattern htmlPattern = Pattern.compile("<x?html", 2);

    public VOTableBuilder() {
        this(VOElementFactory.isStrictByDefault());
    }

    public VOTableBuilder(boolean strict) {
        this.strict_ = strict;
    }

    public String getFormatName() {
        return "VOTable";
    }

    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws TableFormatException, IOException {
        NodeList tables;
        int ntab;
        VOElement voEl;
        String sintro = new String(datsrc.getIntro());
        if (htmlPattern.matcher(sintro).lookingAt()) {
            throw new TableFormatException("Data looks like HTML");
        }
        try {
            voEl = new VOElementFactory(storagePolicy).makeVOElement(datsrc);
        }
        catch (SAXException e) {
            throw new TableFormatException("XML parse error (" + e.getMessage() + ")", e);
        }
        catch (IOException e) {
            throw e;
        }
        int itab = 0;
        String pos = datsrc.getPosition();
        if (pos != null) {
            try {
                itab = Integer.parseInt(pos);
            }
            catch (NumberFormatException e) {
                throw new TableFormatException("Expecting integer for position in " + datsrc + "(" + e + ")");
            }
            if (itab < 0) {
                throw new TableFormatException("Expecting integer >= 0 for position in " + datsrc + "(got " + itab + ")");
            }
        }
        if ((ntab = (tables = voEl.getElementsByTagName("TABLE")).getLength()) == 0) {
            throw new TableFormatException("Document contains no TABLE elements");
        }
        if (itab >= ntab) {
            throw new IOException("VOTable document contained only " + ntab + " tables");
        }
        TableElement tableEl = (TableElement)tables.item(itab);
        VOStarTable st = new VOStarTable(tableEl);
        if (st.getColumnCount() == 0) {
            throw new TableFormatException("TABLE contains no columns");
        }
        return st;
    }

    public boolean canImport(DataFlavor flavor) {
        String pri = flavor.getPrimaryType();
        String sub = flavor.getSubType();
        return pri.equals("text") && sub.equals("xml") || pri.equals("application") && sub.equals("xml") || pri.equals("application") && sub.equals("x-votable+xml");
    }

    public void streamStarTable(InputStream istrm, TableSink sink, String index) throws IOException {
        int itable = index != null && index.matches("[0-9]+") ? Integer.parseInt(index) : 0;
        try {
            TableStreamer.streamStarTable(new InputSource(istrm), sink, itable, this.strict_);
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }
}

