/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;
import uk.ac.starlink.connect.Leaf;
import uk.ac.starlink.connect.Node;
import uk.ac.starlink.connect.NodeComparator;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;

public class BranchDataNode
extends DefaultDataNode {
    private Branch branch_;
    private Connection connection_;
    private Icon icon_;
    private String tla_;
    private String type_;
    private String path_;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$BranchDataNode;

    public BranchDataNode(Branch branch) {
        this.branch_ = branch;
        String name = branch.getName();
        if ((name == null || name.length() == 0) && branch.getParent() == null) {
            name = "/";
        }
        this.setName(name);
        this.setLabel(name);
        this.setIconID((short)106);
    }

    public void setConnection(Connection connection) {
        this.connection_ = connection;
        Connector connector = connection.getConnector();
        if (connector != null) {
            if (this.branch_.getParent() == null) {
                this.icon_ = connector.getIcon();
            }
            this.tla_ = connector.getName().toUpperCase();
            if (this.tla_.length() > 3) {
                this.tla_ = this.tla_.substring(0, 3);
            }
            this.type_ = connector.getName() + " branch";
        }
        if (this.branch_.getParent() == null) {
            this.setName(connection.toString());
        }
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        Node[] children = this.branch_.getChildren();
        Arrays.sort(children, NodeComparator.getInstance());
        final Iterator<Node> it = Arrays.asList(children).iterator();
        return new Iterator(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                Node node = (Node)it.next();
                if (node instanceof Leaf) {
                    try {
                        return BranchDataNode.this.makeChild(((Leaf)node).getDataSource());
                    }
                    catch (IOException e) {
                        return BranchDataNode.this.makeErrorChild(e);
                    }
                }
                if (!$assertionsDisabled && !(node instanceof Branch)) {
                    throw new AssertionError();
                }
                DataNode dataNode = BranchDataNode.this.makeChild(node);
                if (dataNode instanceof BranchDataNode && BranchDataNode.this.connection_ != null) {
                    ((BranchDataNode)dataNode).setConnection(BranchDataNode.this.connection_);
                }
                return dataNode;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$datanode$nodes$BranchDataNode == null ? (class$uk$ac$starlink$datanode$nodes$BranchDataNode = BranchDataNode.class$("uk.ac.starlink.datanode.nodes.BranchDataNode")) : class$uk$ac$starlink$datanode$nodes$BranchDataNode).desiredAssertionStatus();
            }
        };
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public Object getParentObject() {
        return this.branch_.getParent();
    }

    public String getPathSeparator() {
        return "/";
    }

    public String getPathElement() {
        return this.path_ == null ? super.getPathElement() : this.path_;
    }

    public Icon getIcon() {
        return this.icon_ == null ? super.getIcon() : this.icon_;
    }

    public String getNodeTLA() {
        return this.tla_ == null ? "BRA" : this.tla_;
    }

    public String getNodeType() {
        return this.type_ == null ? "Remote branch" : this.type_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

