/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import javax.swing.JComponent;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.ExceptionComponentMaker;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;

public class CompressedDataNode
extends DefaultDataNode {
    private final DataSource datsrc;
    private final Compression compress;
    private final String name;

    public CompressedDataNode(DataSource datsrc) throws NoSuchDataException {
        this.datsrc = datsrc;
        try {
            this.compress = datsrc.getCompression();
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
        if (this.compress == Compression.NONE) {
            throw new NoSuchDataException("Data source uses no known compression format");
        }
        this.name = datsrc.getName();
        this.setLabel(this.name);
        this.setIconID((short)134);
        this.registerDataObject(DataType.DATA_SOURCE, datsrc);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "(" + this.compress + ")";
    }

    public String getNodeTLA() {
        return "CMP";
    }

    public String getNodeType() {
        return "Compressed data";
    }

    public String getPathElement() {
        return this.name;
    }

    public void configureDetail(DetailViewer dv) {
        dv.addKeyedItem("Compression format", this.compress);
        long rawLeng = this.datsrc.getRawLength();
        long cookLeng = this.datsrc.getLength();
        if (rawLeng >= 0L) {
            dv.addKeyedItem("Compressed size", rawLeng);
        }
        if (cookLeng >= 0L) {
            dv.addKeyedItem("Decompressed size", cookLeng);
        }
        try {
            byte[] intro = this.datsrc.getIntro();
            if (intro.length > 0 && NodeUtil.isASCII(intro)) {
                dv.addPane("Text view", new ComponentMaker(){

                    public JComponent getComponent() throws IOException {
                        return new TextViewer(CompressedDataNode.this.datsrc.getInputStream());
                    }
                });
            }
        }
        catch (IOException e) {
            dv.addPane("Error reading text", new ExceptionComponentMaker(e));
        }
    }
}

