/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.XMLDataNode;
import uk.ac.starlink.datanode.nodes.XMLDocument;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.util.SourceReader;

public class DocumentDataNode
extends DefaultDataNode {
    private final XMLDocument xdoc_;
    private final String systemId_;
    private final String publicId_;
    private final String topLocalName_;
    private final String topNamespaceURI_;
    private final Attributes topAttributes_;
    private List parseLog_;
    private DOMSource docsrc_;
    private Exception parseError_;
    private boolean doingParse_;
    private final Object parseLock_ = new Object();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$DocumentDataNode;

    public DocumentDataNode(XMLDocument xdoc) {
        this.xdoc_ = xdoc;
        this.systemId_ = xdoc.getSystemId();
        this.publicId_ = xdoc.getPublicId();
        this.topLocalName_ = xdoc.getTopLocalName();
        this.topNamespaceURI_ = xdoc.getTopNamespaceURI();
        this.topAttributes_ = xdoc.getTopAttributes();
        this.setName(xdoc.getName());
        this.setIconID((short)120);
        this.registerDataObject(DataType.DATA_SOURCE, xdoc.getDataSource());
    }

    public DocumentDataNode(Source xsrc) throws NoSuchDataException {
        Element topEl;
        this.xdoc_ = null;
        if (xsrc instanceof DOMSource) {
            this.docsrc_ = (DOMSource)xsrc;
        } else {
            try {
                this.docsrc_ = new DOMSource(new SourceReader().getDOM(xsrc));
                this.docsrc_.setSystemId(xsrc.getSystemId());
            }
            catch (TransformerException e) {
                throw new NoSuchDataException("Parse failed", e);
            }
        }
        this.systemId_ = this.docsrc_.getSystemId();
        this.publicId_ = null;
        Node topNode = this.docsrc_.getNode();
        if (topNode instanceof Document) {
            topEl = ((Document)topNode).getDocumentElement();
        } else if (topNode instanceof Element) {
            topEl = (Element)topNode;
        } else {
            throw new NoSuchDataException("Strange node " + topNode);
        }
        this.topLocalName_ = topEl.getLocalName();
        this.topNamespaceURI_ = topEl.getNamespaceURI();
        this.topAttributes_ = new AttributesImpl();
        Node node = topEl.getFirstChild();
        while (node != null) {
            if (node instanceof Attr) {
                Attr att = (Attr)node;
                ((AttributesImpl)this.topAttributes_).addAttribute(att.getNamespaceURI(), att.getLocalName(), att.getName(), "CDATA", att.getValue());
            }
            node = node.getNextSibling();
        }
    }

    public boolean allowsChildren() {
        return true;
    }

    public String getNodeTLA() {
        return "DOC";
    }

    public String getNodeType() {
        return "XML document";
    }

    public String getPathSeparator() {
        return "#";
    }

    protected void checkTopElement(String localName, String namespaceURI) throws NoSuchDataException {
        boolean gotBlank;
        this.checkTopLocalName(localName);
        boolean reqBlank = namespaceURI == null || namespaceURI.trim().length() == 0;
        boolean bl = gotBlank = this.topNamespaceURI_ == null || this.topNamespaceURI_.trim().length() == 0;
        if (!(reqBlank && gotBlank || namespaceURI.equals(this.topNamespaceURI_))) {
            throw new NoSuchDataException("Namespace is " + this.topNamespaceURI_ + " not " + namespaceURI);
        }
    }

    protected void checkTopLocalName(String localName) throws NoSuchDataException {
        if (!localName.equals(this.topLocalName_)) {
            throw new NoSuchDataException("Document type is " + this.topLocalName_ + " not " + localName);
        }
    }

    protected Iterator getChildIterator(final Node parentNode) {
        return new Iterator(){
            private Node next;
            private String systemId;
            {
                this.next = XMLDataNode.firstUsefulSibling(parentNode.getFirstChild());
                this.systemId = DocumentDataNode.this.xdoc_.getSystemId();
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Node nod = this.next;
                this.next = XMLDataNode.firstUsefulSibling(this.next.getNextSibling());
                try {
                    DOMSource xsrc = new DOMSource(nod, this.systemId);
                    return DocumentDataNode.this.makeChild(xsrc);
                }
                catch (Exception e) {
                    return DocumentDataNode.this.makeErrorChild(e);
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getChildIterator() {
        try {
            DOMSource dsrc = this.getDocument();
            Document doc = (Document)dsrc.getNode();
            return this.getChildIterator(doc);
        }
        catch (IOException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
        catch (SAXException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
    }

    public void configureDetail(DetailViewer dv) {
        if (this.systemId_ != null && this.systemId_.trim().length() > 0) {
            dv.addKeyedItem("System ID", this.systemId_);
        }
        if (this.publicId_ != null && this.publicId_.trim().length() > 0) {
            dv.addKeyedItem("Public ID", this.publicId_);
        }
        dv.addSeparator();
        if (this.topNamespaceURI_ == null || this.topNamespaceURI_.trim().length() == 0) {
            dv.addKeyedItem("Document Type", this.topLocalName_);
        } else {
            dv.addKeyedItem("Document Type", this.topLocalName_);
            dv.addKeyedItem("Root Namespace", this.topNamespaceURI_);
        }
        if (this.topAttributes_ != null && this.topAttributes_.getLength() > 0) {
            dv.addSubHead("Top element attributes");
            int natt = this.topAttributes_.getLength();
            int i = 0;
            while (i < natt) {
                String attName = this.topAttributes_.getQName(i);
                if (attName == null) {
                    attName = this.topAttributes_.getLocalName(i);
                }
                dv.addKeyedItem(attName, this.topAttributes_.getValue(i));
                ++i;
            }
        }
        dv.addPane("XML Text", new ComponentMaker(){

            public JComponent getComponent() {
                try {
                    return new TextViewer(DocumentDataNode.this.getDocument());
                }
                catch (IOException e) {
                    return new TextViewer(e);
                }
                catch (SAXException e) {
                    return new TextViewer(e);
                }
            }
        });
        if (this.xdoc_ != null) {
            dv.addPane("Parse results", new ComponentMaker(){

                public JComponent getComponent() {
                    JTextArea parseDoc = new JTextArea();
                    new Thread(this, "Document parser", parseDoc){
                        private final /* synthetic */ JTextArea val$parseDoc;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$parseDoc = val$parseDoc;
                            super(x0);
                        }

                        public void run() {
                            try {
                                DocumentDataNode.access$200(3.access$100(this.this$1));
                            }
                            catch (SAXException e) {
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            Iterator<E> it = DocumentDataNode.access$300(3.access$100(this.this$1)).iterator();
                            if (it.hasNext()) {
                                while (it.hasNext()) {
                                    this.val$parseDoc.append(it.next() + "\n");
                                }
                            } else {
                                this.val$parseDoc.append("Parse successful");
                            }
                        }
                    }.start();
                    return parseDoc;
                }

                static /* synthetic */ DocumentDataNode access$100(3 x0) {
                    return x0.DocumentDataNode.this;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DOMSource getDocument() throws IOException, SAXException {
        Object object = this.parseLock_;
        synchronized (object) {
            while (this.doingParse_) {
                try {
                    this.parseLock_.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException("Interrupted?").initCause(e);
                }
            }
            if (this.parseError_ != null) {
                if (this.parseError_ instanceof IOException) {
                    throw (IOException)this.parseError_;
                }
                if (this.parseError_ instanceof SAXException) {
                    throw (SAXException)this.parseError_;
                }
                throw new SAXException(this.parseError_);
            }
            if (this.docsrc_ == null) {
                if (!$assertionsDisabled && this.xdoc_ == null) {
                    throw new AssertionError();
                }
                this.doParse();
            }
            if (!$assertionsDisabled && this.docsrc_ == null) {
                throw new AssertionError();
            }
            return this.docsrc_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParse() throws SAXException, IOException {
        Object object = this.parseLock_;
        synchronized (object) {
            this.doingParse_ = true;
            this.parseLog_ = new ArrayList();
            ErrorHandler ehandler = new ErrorHandler(){

                public void error(SAXParseException e) {
                    DocumentDataNode.this.parseLog_.add(e.toString());
                }

                public void warning(SAXParseException e) {
                    DocumentDataNode.this.parseLog_.add(e.toString());
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    DocumentDataNode.this.parseError_ = e;
                    DocumentDataNode.this.parseLog_.add(e.toString());
                    throw e;
                }
            };
            try {
                this.docsrc_ = this.xdoc_.parseToDOM(true, ehandler);
            }
            catch (IOException e) {
                this.parseError_ = e;
                throw e;
            }
            catch (SAXException e) {
                this.parseError_ = e;
                throw e;
            }
            this.doingParse_ = false;
            this.parseLock_.notifyAll();
        }
    }

    static /* synthetic */ void access$200(DocumentDataNode x0) throws SAXException, IOException {
        x0.doParse();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$datanode$nodes$DocumentDataNode == null ? (class$uk$ac$starlink$datanode$nodes$DocumentDataNode = DocumentDataNode.class$("uk.ac.starlink.datanode.nodes.DocumentDataNode")) : class$uk$ac$starlink$datanode$nodes$DocumentDataNode).desiredAssertionStatus();
    }
}

