/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import javax.swing.JComponent;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.SkyFrame;
import uk.ac.starlink.ast.SpecFrame;
import uk.ac.starlink.ast.xml.XAstWriter;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.viewers.AstTextShower;
import uk.ac.starlink.datanode.viewers.TextViewer;

public class FrameDataNode
extends DefaultDataNode {
    private Frame frame;
    private String description;
    private String name;
    private boolean sky;
    private boolean spec;

    public FrameDataNode(Frame frame) throws NoSuchDataException {
        this.frame = frame;
        this.name = frame.getDomain().trim();
        if (this.name.equals("")) {
            this.name = "(no domain)";
        }
        this.setLabel(this.name);
        this.sky = frame instanceof SkyFrame;
        this.spec = frame instanceof SpecFrame;
        this.description = "(" + frame.getNaxes() + " axes) \"" + frame.getTitle() + "\"";
        short iconid = this.sky ? (short)114 : (this.spec ? (short)142 : 113);
        this.setIconID(iconid);
    }

    public String getNodeTLA() {
        return this.sky ? "SKY" : "FRM";
    }

    public String getNodeType() {
        return this.sky ? "AST Sky coordinate frame" : "AST coordinate frame";
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void configureDetail(DetailViewer dv) {
        int naxes = this.frame.getNaxes();
        this.addItem(dv, "Naxes");
        this.addItem(dv, "Domain");
        this.addItem(dv, "Title");
        if (this.sky) {
            this.addItem(dv, "Epoch");
            this.addItem(dv, "Equinox");
            this.addItem(dv, "Projection");
            this.addItem(dv, "System");
        }
        int i = 1;
        while (i <= naxes) {
            dv.addSubHead("Axis " + i);
            this.addAxisItem(dv, "Label", i);
            this.addAxisItem(dv, "Symbol", i);
            this.addAxisItem(dv, "Unit", i);
            this.addAxisItem(dv, "Digits", i);
            this.addAxisItem(dv, "Direction", i);
            this.addAxisItem(dv, "Format", i);
            ++i;
        }
        dv.addPane("Text view", new ComponentMaker(){

            public JComponent getComponent() {
                return new AstTextShower((AstObject)FrameDataNode.this.frame);
            }
        });
        dv.addPane("XML view", new ComponentMaker(){

            public JComponent getComponent() throws TransformerException {
                Element el = new XAstWriter().makeElement((AstObject)FrameDataNode.this.frame);
                return new TextViewer(new DOMSource(el));
            }
        });
    }

    private void addItem(DetailViewer dv, String attrib) {
        dv.addKeyedItem(attrib, this.frame.getC(attrib));
    }

    private void addAxisItem(DetailViewer dv, String attrib, int axis) {
        String att = attrib + "(" + axis + ")";
        dv.addKeyedItem(attrib, this.frame.getC(att));
    }
}

