/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.XMLDataNode;
import uk.ac.starlink.datanode.nodes.XMLDocument;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.hdx.HdxContainer;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFactory;
import uk.ac.starlink.hdx.HdxResourceType;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.util.URLUtils;

public class HDXDataNode
extends DefaultDataNode {
    private final HdxContainer hdx;
    private URI baseUri;
    private String systemId;
    private String name;
    private Element hdxel;
    static /* synthetic */ Class class$uk$ac$starlink$ndx$BridgeNdx;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$HDXDataNode;

    public HDXDataNode(Source xsrc) throws NoSuchDataException {
        Element el;
        block14: {
            try {
                Node node = new SourceReader().getDOM(xsrc);
                if (node instanceof Element) {
                    el = (Element)node;
                    break block14;
                }
                if (node instanceof Document) {
                    el = ((Document)node).getDocumentElement();
                    break block14;
                }
                throw new NoSuchDataException("XML Source is not an element");
            }
            catch (TransformerException e) {
                throw new NoSuchDataException(e);
            }
        }
        this.systemId = xsrc.getSystemId();
        if (this.systemId != null) {
            try {
                URL url = URLUtils.makeURL(this.systemId);
                this.baseUri = new URI(url.toString());
            }
            catch (URISyntaxException e) {
                this.baseUri = null;
            }
        }
        try {
            this.hdx = HdxFactory.getInstance().newHdxContainer(el, this.baseUri);
        }
        catch (HdxException e) {
            throw new NoSuchDataException(e);
        }
        catch (AssertionError e) {
            throw new NoSuchDataException((Throwable)((Object)e));
        }
        if (this.hdx == null) {
            throw new NoSuchDataException("No unique HDX in source");
        }
        this.hdxel = this.hdx.getDOM(this.baseUri);
        Object title = this.hdx.get(HdxResourceType.TITLE);
        if (this.name == null && title != null) {
            this.name = title.toString();
        }
        if (this.name == null && this.baseUri != null) {
            this.name = this.baseUri.toString().replaceFirst("#.*$", "").replaceFirst("^.*/", "");
        }
        if (this.name == null) {
            this.name = el.getTagName();
        }
        this.setLabel(this.name);
        this.setIconID((short)131);
    }

    public HDXDataNode(String loc) throws NoSuchDataException {
        URL url = URLUtils.makeURL(loc);
        this.systemId = loc;
        try {
            this.hdx = HdxFactory.getInstance().newHdxContainer(url);
        }
        catch (HdxException e) {
            throw new NoSuchDataException(e);
        }
        if (this.hdx == null) {
            throw new NoSuchDataException("No handler for " + loc);
        }
        try {
            this.baseUri = new URI(loc);
        }
        catch (URISyntaxException e) {
            this.baseUri = null;
        }
        this.hdxel = this.hdx.getDOM(this.baseUri);
        Object title = this.hdx.get(HdxResourceType.TITLE);
        if (this.name == null && title != null) {
            this.name = title.toString();
        }
        if (this.name == null) {
            this.name = loc.replaceFirst("#.*$", "").replaceFirst("^.*/", "");
        }
        this.setLabel(this.name);
    }

    public HDXDataNode(File file) throws NoSuchDataException {
        this(file.toString());
    }

    public HDXDataNode(XMLDocument xdoc) throws NoSuchDataException {
        this(xdoc.constructDOM(false));
    }

    public String getName() {
        return this.name;
    }

    public String getNodeTLA() {
        return "HDX";
    }

    public String getNodeType() {
        return "HDX container";
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        return new Iterator(){
            Node next;
            {
                this.next = XMLDataNode.firstUsefulSibling(HDXDataNode.this.hdxel.getFirstChild());
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Node nod = this.next;
                this.next = XMLDataNode.firstUsefulSibling(this.next.getNextSibling());
                try {
                    DOMSource xsrc = new DOMSource(nod, HDXDataNode.this.systemId);
                    return HDXDataNode.this.makeChild(xsrc);
                }
                catch (Exception e) {
                    return HDXDataNode.this.makeErrorChild(e);
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public DataNodeFactory getChildMaker() {
        DataNodeFactory dfact = new DataNodeFactory(super.getChildMaker());
        dfact.removeNodeClass(class$uk$ac$starlink$datanode$nodes$HDXDataNode == null ? (class$uk$ac$starlink$datanode$nodes$HDXDataNode = HDXDataNode.class$("uk.ac.starlink.datanode.nodes.HDXDataNode")) : class$uk$ac$starlink$datanode$nodes$HDXDataNode);
        return dfact;
    }

    public void configureDetail(DetailViewer dv) {
        if (this.baseUri != null) {
            dv.addKeyedItem("Base URI", this.baseUri);
        }
        dv.addPane("XML view", new ComponentMaker(){

            public JComponent getComponent() {
                return new TextViewer(new DOMSource(HDXDataNode.this.hdxel));
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        (class$uk$ac$starlink$ndx$BridgeNdx == null ? (class$uk$ac$starlink$ndx$BridgeNdx = HDXDataNode.class$("uk.ac.starlink.ndx.BridgeNdx")) : class$uk$ac$starlink$ndx$BridgeNdx).getName();
    }
}

