/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetamapGroup {
    private final List knownKeys;
    private final Map[] metamaps;
    private Comparator keyComparator;
    private List ordering = new ArrayList();

    public MetamapGroup(int nitem) {
        this.knownKeys = Collections.synchronizedList(new ArrayList());
        this.metamaps = new Map[nitem];
        int i = 0;
        while (i < nitem) {
            this.metamaps[i] = Collections.synchronizedMap(new HashMap());
            ++i;
        }
    }

    public void addEntry(int item, String key, Object value) {
        if (value != null && value.toString().length() > 0) {
            if (!this.knownKeys.contains(key)) {
                this.knownKeys.add(key);
            }
            this.metamaps[item].put(key, value);
        }
    }

    public Object getEntry(int item, String key) {
        return this.metamaps[item].get(key);
    }

    public boolean hasEntry(int item, String key) {
        return this.metamaps[item].containsKey(key);
    }

    public void setKeyOrder(List ordering) {
        this.ordering = new ArrayList(ordering);
        final ArrayList order = new ArrayList(ordering);
        Collections.reverse(order);
        this.keyComparator = new Comparator(){

            public int compare(Object key1, Object key2) {
                return order.indexOf(key2) - order.indexOf(key1);
            }
        };
    }

    public List getKeyOrder() {
        return this.ordering;
    }

    public List getKnownKeys() {
        if (this.keyComparator != null) {
            Collections.sort(this.knownKeys, this.keyComparator);
        }
        return new ArrayList(this.knownKeys);
    }

    public Map[] getMetamaps() {
        return this.metamaps;
    }

    public int getNumMaps() {
        return this.metamaps.length;
    }
}

