/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.net.URL;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrayFactory;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;

public class NDArrayDataNode
extends DefaultDataNode {
    private NDArray nda;
    private Ndx ndx;
    private String name;

    public NDArrayDataNode(NDArray nda) {
        this.nda = nda;
        URL url = nda.getURL();
        this.name = url == null ? "NDArray" : url.getFile();
        this.setLabel(this.name);
        this.setIconID(IconFactory.getArrayIconID(nda.getShape().getNumDims()));
    }

    public NDArrayDataNode(String loc) throws NoSuchDataException {
        this(NDArrayDataNode.getNda(loc));
    }

    public String getDescription() {
        return NDShape.toString((NDShape)this.nda.getShape()) + "  <" + this.nda.getType() + ">";
    }

    public String getPathElement() {
        return this.getLabel();
    }

    public String getPathSeparator() {
        return ".";
    }

    public String getNodeTLA() {
        return "NDA";
    }

    public String getNodeType() {
        return "N-Dimensional Array";
    }

    public void configureDetail(DetailViewer dv) {
        dv.addKeyedItem("URL", this.nda.getURL());
        OrderedNDShape oshape = this.nda.getShape();
        int ndim = oshape.getNumDims();
        dv.addSeparator();
        dv.addKeyedItem("Dimensionality", ndim);
        dv.addKeyedItem("Origin", NDShape.toString((long[])oshape.getOrigin()));
        dv.addKeyedItem("Dimensions", NDShape.toString((long[])oshape.getDims()));
        dv.addKeyedItem("Pixel bounds", NDArrayDataNode.boundsString((NDShape)oshape));
        dv.addKeyedItem("Ordering", oshape.getOrder());
        dv.addSeparator();
        dv.addKeyedItem("Type", this.nda.getType());
        Number bh = this.nda.getBadHandler().getBadValue();
        if (bh != null) {
            dv.addKeyedItem("Bad value", bh);
        }
    }

    public static String boundsString(NDShape shape) {
        long[] lbnd = shape.getOrigin();
        long[] ubnd = shape.getUpperBounds();
        int ndim = shape.getNumDims();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ndim) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(lbnd[i]).append(':').append(ubnd[i]);
            ++i;
        }
        return sb.toString();
    }

    public boolean hasDataObject(DataType dtype) {
        if (dtype == DataType.NDX) {
            return true;
        }
        return super.hasDataObject(dtype);
    }

    public Object getDataObject(DataType dtype) throws DataObjectException {
        if (dtype == DataType.NDX) {
            return this.getNdx();
        }
        return super.getDataObject(dtype);
    }

    private Ndx getNdx() {
        if (this.ndx == null) {
            this.ndx = new DefaultMutableNdx(this.nda);
        }
        return this.ndx;
    }

    private static NDArray getNda(String loc) throws NoSuchDataException {
        NDArray nda;
        try {
            nda = new NDArrayFactory().makeNDArray(loc, AccessMode.READ);
        }
        catch (IOException e) {
            throw new NoSuchDataException(e.getMessage());
        }
        if (nda == null) {
            throw new NoSuchDataException("Not a recognised NDArray");
        }
        return nda;
    }
}

