/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.media.jai.util.CaselessStringKey;
import uk.ac.starlink.ast.AstPackage;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.hds.HDSPackage;

public class NodeUtil {
    private static Boolean hasAST_;
    private static Boolean hasHDS_;
    private static Boolean hasJAI_;
    private static Boolean hasGUI_;
    private static Logger logger;

    public static boolean isASCII(byte[] buf) {
        int leng = buf.length;
        boolean hasUnprintables = false;
        int i = 0;
        while (i < leng && !hasUnprintables) {
            byte bval = buf[i];
            boolean isctl = false;
            switch (bval) {
                case -93: 
                case -87: 
                case 9: 
                case 10: 
                case 12: 
                case 13: {
                    isctl = true;
                    break;
                }
            }
            if (bval > 126 || bval < 32 && !isctl) {
                hasUnprintables = true;
            }
            ++i;
        }
        return !hasUnprintables;
    }

    public static boolean hasHDS() {
        if (hasHDS_ == null) {
            hasHDS_ = HDSPackage.isAvailable();
        }
        return hasHDS_;
    }

    public static boolean hasAST() {
        if (hasAST_ == null) {
            hasAST_ = AstPackage.isAvailable();
        }
        return hasAST_;
    }

    public static boolean hasJAI() {
        block2: {
            if (hasJAI_ != null) break block2;
            try {
                new CaselessStringKey("dummy");
                hasJAI_ = Boolean.TRUE;
            }
            catch (NoClassDefFoundError e) {
                hasJAI_ = Boolean.FALSE;
                logger.warning("JAI extension not present - no image display");
            }
        }
        return hasJAI_;
    }

    public static boolean hasGUI() {
        if (hasGUI_ != null) {
            return hasGUI_;
        }
        class XLoader
        extends ClassLoader {
            XLoader() {
            }

            public boolean isClassLoaded(String name) {
                return this.findLoadedClass(name) != null;
            }
        }
        return new XLoader().isClassLoaded("javax.swing.JFrame");
    }

    public static void setGUI(boolean hasGUI) {
        hasGUI_ = hasGUI;
    }

    public static String getNodePath(DataNode node) {
        List pathList = NodeUtil.accumulatePath(node, new ArrayList());
        if (pathList != null) {
            StringBuffer pathBuf = new StringBuffer();
            Collections.reverse(pathList);
            Iterator it = pathList.iterator();
            while (it.hasNext()) {
                pathBuf.append((String)it.next());
            }
            return pathBuf.toString();
        }
        return null;
    }

    private static List accumulatePath(DataNode node, List path) {
        String prefix;
        String pathEl = node.getPathElement();
        if (pathEl == null) {
            return null;
        }
        CreationState creator = node.getCreator();
        if (creator == null) {
            return null;
        }
        DataNode parent = creator.getParent();
        if (parent == null) {
            prefix = "";
        } else {
            String sep = parent.getPathSeparator();
            if (sep == null) {
                return null;
            }
            prefix = sep;
        }
        path.add(prefix + pathEl);
        return parent == null ? path : NodeUtil.accumulatePath(parent, path);
    }

    public static String toString(DataNode node) {
        String result = node.getLabel().trim();
        String desc = node.getDescription();
        if (desc != null && (desc = desc.trim()).length() > 0) {
            result = result + "  " + desc;
        }
        return result;
    }

    static {
        logger = Logger.getLogger("uk.ac.starlink.datanode.nodes");
    }
}

