/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.ResourceDataSource;

public class ResourceListDataNode
extends DefaultDataNode {
    private List sources;

    public ResourceListDataNode(List resources) {
        super("Resources");
        this.sources = new ArrayList(resources.size());
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            this.sources.add(new ResourceDataSource((String)it.next()));
        }
        this.setCreator(new CreationState(null, null));
    }

    public String getNodeTLA() {
        return "RES";
    }

    public String getNodeType() {
        return "Resource set";
    }

    public String getPathElement() {
        return "[Resources]";
    }

    public String getPathSeparator() {
        return ":";
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        return new Iterator(){
            Iterator it;
            {
                this.it = ResourceListDataNode.this.sources.iterator();
            }

            public Object next() {
                DataSource datsrc = (DataSource)this.it.next();
                DataNode node = ResourceListDataNode.this.makeChild(datsrc);
                node.setLabel(datsrc.getName());
                return node;
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

