/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;

public class ScalarDataNode
extends DefaultDataNode {
    private String desc;
    private String type;
    private String value;
    private static final String QUOTE = "\"";

    public ScalarDataNode(String name, String type, String value) {
        super(name);
        if (!(!type.equalsIgnoreCase("string") || value.startsWith(QUOTE) && value.endsWith(QUOTE))) {
            value = QUOTE + value + QUOTE;
        }
        this.desc = value;
        this.value = value;
        if (type != null && type.trim().length() > 0) {
            this.type = type;
            this.desc = "<" + type + ">" + this.desc;
        }
        this.setIconID((short)103);
    }

    public String getDescription() {
        return this.desc;
    }

    public String getNodeTLA() {
        return "SCA";
    }

    public String nodeType() {
        return "Scalar";
    }

    public void configureDetail(DetailViewer dv) {
        if (this.type != null) {
            dv.addKeyedItem("Type", this.type);
        }
        dv.addKeyedItem("Value", this.value);
    }
}

