/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.SwitchDataSource;
import uk.ac.starlink.datanode.nodes.TarBranchDataNode;
import uk.ac.starlink.util.DataSource;

public class TarStreamDataNode
extends DefaultDataNode {
    private DataSource datsrc;
    private String name;
    private List entries;

    public TarStreamDataNode(DataSource datsrc) throws NoSuchDataException {
        byte[] magic;
        this.datsrc = datsrc;
        try {
            magic = datsrc.getIntro();
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
        if (!TarStreamDataNode.isMagic(magic)) {
            throw new NoSuchDataException("Wrong magic number for tar");
        }
        this.name = datsrc.getName();
        this.setLabel(this.name);
        this.setIconID((short)132);
    }

    public String getName() {
        return this.name;
    }

    public String getPathSeparator() {
        return ":";
    }

    public String getNodeTLA() {
        return "TAR";
    }

    public String getNodeType() {
        return "Tar archive";
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        return this.getChildIteratorAtLevel("", this);
    }

    Iterator getChildIteratorAtLevel(String level, final DataNode parent) {
        TarInputStream tstream;
        Iterator tentIt;
        final TarStreamDataNode tsdn = this;
        DataNodeFactory childMaker = this.getChildMaker();
        final int lleng = level.length();
        try {
            tentIt = this.getEntriesAtLevel(level).iterator();
            tstream = this.getTarInputStream();
        }
        catch (IOException e) {
            return Collections.singleton(this.getChildMaker().makeErrorDataNode(parent, e)).iterator();
        }
        return new Iterator(){

            public boolean hasNext() {
                return tentIt.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public Object next() {
                SwitchDataSource childSrc;
                TarEntry tent = (TarEntry)tentIt.next();
                String tname = tent.getName();
                String subname = tname.substring(lleng);
                if (tent.isDirectory()) {
                    TarBranchDataNode dnode = new TarBranchDataNode(tsdn, tent);
                    TarStreamDataNode.this.getChildMaker().configureDataNode(dnode, parent, null);
                    dnode.setLabel(subname);
                    return dnode;
                }
                try {
                    TarEntry ent;
                    boolean found = false;
                    while ((ent = TarStreamDataNode.getNextEntry(tstream)) != null) {
                        void var6_10;
                        if (!var6_10.getName().equals(tname)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        try {
                            throw new AssertionError((Object)("Can't find entry" + tname));
                        }
                        catch (AssertionError e) {
                            DataNode node = TarStreamDataNode.this.getChildMaker().makeErrorDataNode(parent, (Throwable)((Object)e));
                            node.setLabel(tname);
                            return node;
                        }
                    }
                    SwitchDataSource ssrc = new SwitchDataSource(this, tent.getSize(), tent){
                        private final /* synthetic */ TarEntry val$tent;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$tent = val$tent;
                            super(x0);
                        }

                        public InputStream getBackupRawInputStream() throws IOException {
                            InputStream strm = TarStreamDataNode.access$200(1.access$100(this.this$1), this.val$tent);
                            strm = new BufferedInputStream(strm);
                            return strm;
                        }

                        public URL getURL() {
                            return null;
                        }
                    };
                    ssrc.setName(subname);
                    ssrc.setProvisionalStream(new FilterInputStream(this, tstream){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            super(x0);
                        }

                        public void close() {
                        }
                    });
                    ssrc.getIntro();
                    ssrc.setProvisionalStream(null);
                    ssrc.close();
                    childSrc = ssrc;
                }
                catch (IOException e) {
                    return TarStreamDataNode.this.getChildMaker().makeErrorDataNode(parent, e);
                }
                if (!this.hasNext()) {
                    try {
                        tstream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                DataNode node = TarStreamDataNode.this.getChildMaker().makeChildNode(parent, childSrc);
                node.setLabel(subname);
                return node;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            static /* synthetic */ TarStreamDataNode access$100(1 x0) {
                return x0.TarStreamDataNode.this;
            }
        };
    }

    protected List getEntriesAtLevel(String level) throws IOException {
        HashSet<String> realDirs = new HashSet<String>();
        TreeSet<String> impliedDirs = new TreeSet<String>();
        ArrayList<TarEntry> levEnts = new ArrayList<TarEntry>();
        int lleng = level.length();
        Iterator entIt = this.getEntries().iterator();
        while (entIt.hasNext()) {
            TarEntry ent = (TarEntry)entIt.next();
            String entname = ent.getName();
            if (!entname.startsWith(level) || entname.equals(level)) continue;
            String subname = entname.substring(lleng);
            int slashix = subname.indexOf(47);
            if (slashix >= 0) {
                String dirname = subname.substring(0, slashix + 1);
                if (slashix == subname.length() - 1) {
                    realDirs.add(dirname);
                    levEnts.add(ent);
                    continue;
                }
                impliedDirs.add(dirname);
                continue;
            }
            levEnts.add(ent);
        }
        impliedDirs.removeAll(realDirs);
        Iterator phIt = impliedDirs.iterator();
        while (phIt.hasNext()) {
            String dirname = (String)phIt.next();
            levEnts.add(new TarEntry(level + dirname));
        }
        return levEnts;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized List getEntries() throws IOException {
        if (this.entries == null) {
            TarEntry tent;
            this.entries = new ArrayList();
            TarInputStream ts = this.getTarInputStream();
            while ((tent = TarStreamDataNode.getNextEntry(ts)) != null) {
                void var2_2;
                this.entries.add(var2_2);
            }
            ts.close();
        }
        return this.entries;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream getEntryInputStream(TarEntry reqEnt) throws IOException {
        TarEntry ent;
        String reqName = reqEnt.getName();
        TarInputStream tstream = this.getTarInputStream();
        while ((ent = TarStreamDataNode.getNextEntry(tstream)) != null) {
            void var4_4;
            if (!var4_4.getName().equals(reqName)) continue;
            return tstream;
        }
        tstream.close();
        throw new IOException("Entry " + reqEnt + " not in this archive");
    }

    private TarInputStream getTarInputStream() throws IOException {
        return new TarInputStream(this.datsrc.getInputStream());
    }

    private static TarEntry getNextEntry(TarInputStream tstrm) {
        try {
            TarEntry tent = tstrm.getNextEntry();
            if (tent != null && tent.isDirectory() && !tent.getName().endsWith("/")) {
                tent.setName(tent.getName() + '/');
            }
            return tent;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isMagic(byte[] magic) {
        return magic.length > 264 && (char)magic[257] == 'u' && (char)magic[258] == 's' && (char)magic[259] == 't' && (char)magic[260] == 'a' && (char)magic[261] == 'r' && ((char)magic[262] == '\u0000' || (char)magic[262] == ' ' && (char)magic[263] == ' ' && (char)magic[264] == '\u0000');
    }

    static /* synthetic */ InputStream access$200(TarStreamDataNode x0, TarEntry x1) throws IOException {
        return x0.getEntryInputStream(x1);
    }
}

