/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.datanode.nodes.MetamapGroup;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.UCD;
import uk.ac.starlink.table.ValueInfo;

public class ValueInfoMetamapGroup
extends MetamapGroup {
    public static final String INDEX_KEY = "Index";
    public static final String NAME_KEY = "Name";
    public static final String CLASS_KEY = "Class";
    public static final String SHAPE_KEY = "Shape";
    public static final String VALUE_KEY = "Value";
    public static final String UNITS_KEY = "Units";
    public static final String DESCRIPTION_KEY = "Description";
    public static final String UCD_KEY = "UCD";
    public static final String UCD_DESCRIPTION_KEY = "UCD description";
    public static final String NULLABLE_KEY = "Nullable";
    private static final List keyOrder = Arrays.asList("Index", "Name", "Class", "Shape", "Value", "Units", "Description", "UCD", "UCD description", "Nullable");

    public ValueInfoMetamapGroup(List infos) {
        super(infos.size());
        this.setKeyOrder(keyOrder);
        int i = 0;
        Iterator it = infos.iterator();
        while (it.hasNext()) {
            ValueInfo info;
            Object item = it.next();
            if (item instanceof ValueInfo) {
                info = (ValueInfo)item;
            } else if (item instanceof DescribedValue) {
                DescribedValue dval = (DescribedValue)item;
                info = dval.getInfo();
                this.addEntry(i, VALUE_KEY, dval.getValueAsString(600));
            } else {
                throw new IllegalArgumentException(item + " is not ValueInfo or DescribedValue");
            }
            this.addEntry(i, NAME_KEY, info.getName());
            this.addEntry(i, CLASS_KEY, DefaultValueInfo.formatClass((Class)info.getContentClass()));
            if (info.isArray()) {
                this.addEntry(i, SHAPE_KEY, DefaultValueInfo.formatShape((int[])info.getShape()));
            }
            this.addEntry(i, UNITS_KEY, info.getUnitString());
            this.addEntry(i, DESCRIPTION_KEY, info.getDescription());
            this.addEntry(i, UCD_KEY, info.getUCD());
            if (this.hasEntry(i, UCD_KEY)) {
                UCD ucd = UCD.getUCD((String)((String)this.getEntry(i, UCD_KEY)));
                String desc = ucd != null ? ucd.getDescription() : "<unknown UCD>";
                this.addEntry(i, UCD_DESCRIPTION_KEY, desc);
            }
            ++i;
        }
    }
}

