/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.ast.AstException;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.xml.XAstReader;
import uk.ac.starlink.ast.xml.XAstWriter;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.HDSDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.nodes.WCSChannel;
import uk.ac.starlink.datanode.viewers.AstFITSShower;
import uk.ac.starlink.datanode.viewers.AstTextShower;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.NDFNdxHandler;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.SourceReader;

public class WCSDataNode
extends DefaultDataNode {
    private FrameSet wcs;
    private String description;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$FrameDataNode;

    public WCSDataNode(FrameSet wcs) throws NoSuchDataException {
        super("WCS");
        this.wcs = wcs;
        this.description = wcs.getNframe() + " frames;" + " current domain \"" + wcs.getDomain() + "\"";
        this.setIconID((short)110);
    }

    public WCSDataNode(HDSObject hobj) throws NoSuchDataException {
        this(WCSDataNode.getWcsFromHds(hobj));
    }

    public WCSDataNode(String path) throws NoSuchDataException {
        this(HDSDataNode.getHDSFromPath(path));
    }

    public WCSDataNode(Source xsrc) throws NoSuchDataException {
        this(WCSDataNode.getWcsFromSource(xsrc));
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        ArrayList<DataNode> children = new ArrayList<DataNode>();
        int nframe = this.wcs.getNframe();
        DataNodeFactory childMaker = new DataNodeFactory(this.getChildMaker());
        childMaker.setPreferredClass(class$uk$ac$starlink$datanode$nodes$FrameDataNode == null ? (class$uk$ac$starlink$datanode$nodes$FrameDataNode = WCSDataNode.class$("uk.ac.starlink.datanode.nodes.FrameDataNode")) : class$uk$ac$starlink$datanode$nodes$FrameDataNode);
        int i = 1;
        while (i <= nframe) {
            try {
                children.add(childMaker.makeChildNode(this, this.wcs.getFrame(i)));
            }
            catch (AstException e) {
                children.add(this.makeErrorChild(e));
            }
            ++i;
        }
        return children.iterator();
    }

    public String getDescription() {
        return this.description;
    }

    public String getPathSeparator() {
        return ".";
    }

    public String getNodeTLA() {
        return "WCS";
    }

    public String getNodeType() {
        return "World Coordinate System data";
    }

    public void configureDetail(DetailViewer dv) {
        int nframe = this.wcs.getNframe();
        int current = this.wcs.getCurrent();
        int base = this.wcs.getBase();
        dv.addKeyedItem("Number of frames", nframe);
        dv.addKeyedItem("Base frame", Integer.toString(base) + " (\"" + this.wcs.getFrame(base).getDomain() + "\")");
        dv.addKeyedItem("Current frame", Integer.toString(current) + " (\"" + this.wcs.getFrame(current).getDomain() + "\")");
        dv.addSubHead("Frames");
        int i = 1;
        while (i < nframe + 1) {
            Frame frm = this.wcs.getFrame(i);
            String dom = frm.getDomain();
            dv.addText("  " + i + ":  " + dom + (i == current ? "    *" : ""));
            ++i;
        }
        dv.addPane("Text view", new ComponentMaker(){

            public JComponent getComponent() {
                return new AstTextShower((AstObject)WCSDataNode.this.wcs);
            }
        });
        dv.addPane("XML view", new ComponentMaker(){

            public JComponent getComponent() throws TransformerException {
                Element el = new XAstWriter().makeElement((AstObject)WCSDataNode.this.wcs);
                return new TextViewer(new DOMSource(el));
            }
        });
        dv.addPane("FITS view", new ComponentMaker(){

            public JComponent getComponent() {
                return new AstFITSShower((AstObject)WCSDataNode.this.wcs);
            }
        });
    }

    public FrameSet getWcs() {
        return (FrameSet)this.wcs.copy();
    }

    private static FrameSet getWcsFromHds(HDSObject hobj) throws NoSuchDataException {
        FrameSet fs;
        HDSObject data;
        if (!NodeUtil.hasAST()) {
            throw new NoSuchDataException("AST native library not installed");
        }
        try {
            if (!hobj.datName().equals("WCS")) {
                throw new NoSuchDataException("Not called WCS");
            }
            if (!hobj.datStruc()) {
                throw new NoSuchDataException("Not a structure");
            }
            if (!hobj.datThere("DATA")) {
                throw new NoSuchDataException("No DATA child");
            }
            data = hobj.datFind("DATA");
            if (!data.datType().startsWith("_CHAR")) {
                throw new NoSuchDataException("Not character data");
            }
            if (data.datShape().length != 1) {
                throw new NoSuchDataException("DATA child not a vector");
            }
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e.getMessage());
        }
        try {
            HDSObject hparent = hobj.datParen();
            Ndx ndx = NDFNdxHandler.getInstance().makeNdx(hparent, null, AccessMode.READ);
            return Ndxs.getAst((Ndx)ndx);
        }
        catch (IllegalArgumentException e) {
        }
        catch (HDSException e) {
            // empty catch block
        }
        WCSChannel chan = new WCSChannel(data);
        try {
            fs = (FrameSet)chan.read();
        }
        catch (ClassCastException e) {
            throw new NoSuchDataException("Object read from channel is not an AST FrameSet");
        }
        catch (IOException e) {
            throw new NoSuchDataException("Trouble reading from channel: " + e.getMessage());
        }
        catch (AstException e) {
            throw new NoSuchDataException("Trouble reading from channel: " + e.getMessage());
        }
        if (fs == null) {
            throw new NoSuchDataException("No object read from AST channel");
        }
        return fs;
    }

    private static FrameSet getWcsFromSource(Source xsrc) throws NoSuchDataException {
        try {
            Element fsel;
            Element el;
            Node node = new SourceReader().getDOM(xsrc);
            if (node instanceof Element && (el = (Element)node).getTagName().equals("wcs") && el.getAttribute("encoding").equals("AST-XML") && (fsel = DOMUtils.getChildElementByName(el, "FrameSet")) != null) {
                return (FrameSet)new XAstReader().makeAst(fsel);
            }
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
        catch (TransformerException e) {
            throw new NoSuchDataException(e);
        }
        throw new NoSuchDataException("Wrong sort of Source for AST");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

