/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.util.DataSource;

public abstract class ZipArchiveDataNode
extends DefaultDataNode {
    private String name;
    private List entries;

    protected ZipArchiveDataNode(DataSource datsrc) throws NoSuchDataException {
        this.name = datsrc.getName();
        this.setLabel(this.name);
        try {
            if (!ZipArchiveDataNode.isMagic(datsrc.getIntro())) {
                throw new NoSuchDataException("Wrong magic number for zip");
            }
        }
        catch (IOException e) {
            throw new NoSuchDataException("Can't see if it's zip", e);
        }
        this.setIconID((short)108);
        this.registerDataObject(DataType.DATA_SOURCE, datsrc);
    }

    protected abstract List getEntries() throws IOException;

    protected abstract Iterator getChildIteratorAtLevel(String var1, DataNode var2) throws IOException;

    public static boolean isMagic(byte[] magic) {
        return magic.length > 4 && (char)magic[0] == 'P' && (char)magic[1] == 'K' && magic[2] == 3 && magic[3] == 4;
    }

    public String getName() {
        return this.name;
    }

    public String getPathSeparator() {
        return ":";
    }

    public String getNodeTLA() {
        return "ZIP";
    }

    public String getNodeType() {
        return "Zip archive";
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        try {
            return this.getChildIteratorAtLevel("", this);
        }
        catch (IOException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
    }

    protected List getEntriesAtLevel(String level) throws IOException {
        HashSet<String> realDirs = new HashSet<String>();
        TreeSet<String> impliedDirs = new TreeSet<String>();
        ArrayList<ZipEntry> levEnts = new ArrayList<ZipEntry>();
        int lleng = level.length();
        if (this.entries == null) {
            this.entries = this.getEntries();
        }
        Iterator entIt = this.entries.iterator();
        while (entIt.hasNext()) {
            ZipEntry ent = (ZipEntry)entIt.next();
            String entname = ent.getName();
            if (!entname.startsWith(level) || entname.equals(level)) continue;
            String subname = entname.substring(lleng);
            int slashix = subname.indexOf(47);
            if (slashix >= 0) {
                String dirname = subname.substring(0, slashix + 1);
                if (slashix == subname.length() - 1) {
                    realDirs.add(dirname);
                    levEnts.add(ent);
                    continue;
                }
                impliedDirs.add(dirname);
                continue;
            }
            levEnts.add(ent);
        }
        impliedDirs.removeAll(realDirs);
        Iterator phIt = impliedDirs.iterator();
        while (phIt.hasNext()) {
            String dirname = (String)phIt.next();
            levEnts.add(new ZipEntry(level + dirname));
        }
        return levEnts;
    }
}

